/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensearch.ExceptionsHelper;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.securityconf.Hashed;
import org.opensearch.security.securityconf.Hideable;
import org.opensearch.security.securityconf.StaticDefinable;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.Meta;

public class SecurityDynamicConfiguration<T>
implements ToXContent {
    public static final int CURRENT_VERSION = 2;
    private static final TypeReference<HashMap<String, Object>> typeRefMSO = new TypeReference<HashMap<String, Object>>(){};
    @JsonIgnore
    private final Map<String, T> centries = new HashMap<String, T>();
    @JsonIgnore
    private final Object modificationLock = new Object();
    private long seqNo = -1L;
    private long primaryTerm = -1L;
    private CType<T> ctype;
    private CType<?> ctypeUnsafe;
    private int version = -1;
    private SecurityDynamicConfiguration<?> autoConvertedFrom;
    private Meta _meta;

    public static <T> SecurityDynamicConfiguration<T> empty(CType<T> ctype) {
        return new SecurityDynamicConfiguration<T>(ctype);
    }

    public static <T> SecurityDynamicConfiguration<T> empty(CType<T> ctype, int version) {
        SecurityDynamicConfiguration<T> result = new SecurityDynamicConfiguration<T>(ctype);
        result.version = version;
        return result;
    }

    @JsonIgnore
    public boolean notEmpty() {
        return !this.centries.isEmpty();
    }

    public static <T> SecurityDynamicConfiguration<T> fromJson(String json, CType<T> ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return SecurityDynamicConfiguration.fromJson(json, ctype, version, seqNo, primaryTerm, false);
    }

    public static <T> SecurityDynamicConfiguration<T> fromJson(String json, CType<T> ctype, int version, long seqNo, long primaryTerm, boolean acceptInvalid) throws IOException {
        SecurityDynamicConfiguration sdc = null;
        if (ctype != null) {
            CType.OldConfigVersion<?, T> oldConfigVersion = ctype.findOldConfigVersion(version);
            if (oldConfigVersion != null) {
                sdc = oldConfigVersion.parseJson(ctype, json, acceptInvalid);
                if (sdc._meta == null) {
                    sdc._meta = new Meta();
                    sdc._meta.setConfig_version(2);
                    sdc._meta.setType(ctype.toLCString());
                }
                if (sdc.getAutoConvertedFrom() != null) {
                    sdc.getAutoConvertedFrom().version = version;
                }
                version = 2;
            } else {
                sdc = (SecurityDynamicConfiguration)DefaultObjectMapper.readValue(json, DefaultObjectMapper.getTypeFactory().constructParametricType(SecurityDynamicConfiguration.class, new Class[]{ctype.getConfigClass()}));
            }
            SecurityDynamicConfiguration.validate(sdc, version, ctype);
        } else {
            sdc = new SecurityDynamicConfiguration();
        }
        sdc.ctype = ctype;
        sdc.ctypeUnsafe = ctype;
        sdc.seqNo = seqNo;
        sdc.primaryTerm = primaryTerm;
        sdc.version = version;
        if (sdc.getAutoConvertedFrom() != null) {
            sdc.getAutoConvertedFrom().seqNo = seqNo;
            sdc.getAutoConvertedFrom().primaryTerm = primaryTerm;
            sdc.getAutoConvertedFrom().ctypeUnsafe = ctype;
        }
        return sdc;
    }

    public static SecurityDynamicConfiguration<?> fromJsonWithoutAutoConversion(String json, CType<?> ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return SecurityDynamicConfiguration.fromNodeWithoutAutoConversion(DefaultObjectMapper.readTree(json), ctype, version, seqNo, primaryTerm);
    }

    public static SecurityDynamicConfiguration<?> fromNodeWithoutAutoConversion(JsonNode jsonNode, CType<?> ctype, int version, long seqNo, long primaryTerm) throws IOException {
        CType.OldConfigVersion<?, ?> oldConfigVersion = ctype.findOldConfigVersion(version);
        Class<?> configClass = oldConfigVersion != null ? oldConfigVersion.getOldType() : ctype.getConfigClass();
        SecurityDynamicConfiguration sdc = (SecurityDynamicConfiguration)DefaultObjectMapper.convertValue(jsonNode, DefaultObjectMapper.getTypeFactory().constructParametricType(SecurityDynamicConfiguration.class, new Class[]{configClass}));
        SecurityDynamicConfiguration.validate(sdc, version, ctype);
        sdc.seqNo = seqNo;
        sdc.primaryTerm = primaryTerm;
        sdc.version = version;
        return sdc;
    }

    public static <T> SecurityDynamicConfiguration<T> fromMap(Map<String, Object> map, CType<T> ctype) throws JsonProcessingException {
        SecurityDynamicConfiguration result = (SecurityDynamicConfiguration)DefaultObjectMapper.objectMapper.convertValue(map, DefaultObjectMapper.getTypeFactory().constructParametricType(SecurityDynamicConfiguration.class, new Class[]{ctype.getConfigClass()}));
        result.ctype = ctype;
        return result;
    }

    public static void validate(SecurityDynamicConfiguration<?> sdc, int version, CType<?> ctype) throws IOException {
        if (version < 2 && sdc.get_meta() != null) {
            throw new IOException("A version of " + version + " can not have a _meta key for " + ctype);
        }
        if (version >= 2 && sdc.get_meta() == null) {
            throw new IOException("A version of " + version + " must have a _meta key for " + ctype);
        }
        if (!(version >= 2 || ctype != CType.CONFIG || sdc.getCEntries().size() == 1 && sdc.getCEntries().keySet().contains("opendistro_security"))) {
            throw new IOException("A version of " + version + " must have a single toplevel key named 'opendistro_security' for " + ctype);
        }
        if (!(version < 2 || ctype != CType.CONFIG || sdc.getCEntries().size() == 1 && sdc.getCEntries().keySet().contains("config"))) {
            throw new IOException("A version of " + version + " must have a single toplevel key named 'config' for " + ctype);
        }
    }

    public static <T> SecurityDynamicConfiguration<T> fromNode(JsonNode json, CType<T> ctype, int version, long seqNo, long primaryTerm) throws IOException {
        return SecurityDynamicConfiguration.fromJson(DefaultObjectMapper.writeValueAsString(json, false), ctype, version, seqNo, primaryTerm);
    }

    public static <T> SecurityDynamicConfiguration<T> fromYaml(String yaml, CType<T> ctype) throws JsonProcessingException {
        Class<T> implementationClass = ctype.getConfigClass();
        SecurityDynamicConfiguration result = (SecurityDynamicConfiguration)DefaultObjectMapper.YAML_MAPPER.readValue(yaml, DefaultObjectMapper.getTypeFactory().constructParametricType(SecurityDynamicConfiguration.class, new Class[]{implementationClass}));
        result.ctype = ctype;
        result.version = 2;
        return result;
    }

    private SecurityDynamicConfiguration() {
    }

    private SecurityDynamicConfiguration(CType<T> ctype) {
        this.ctype = ctype;
        this.ctypeUnsafe = ctype;
    }

    public Meta get_meta() {
        return this._meta;
    }

    public void set_meta(Meta _meta) {
        this._meta = _meta;
    }

    @JsonAnySetter
    void setCEntries(String key, T value) {
        this.putCEntry(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonAnyGetter
    public Map<String, T> getCEntries() {
        Object object = this.modificationLock;
        synchronized (object) {
            return new HashMap<String, T>(this.centries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public void removeHidden() {
        Object object = this.modificationLock;
        synchronized (object) {
            Iterator<Map.Entry<String, T>> iterator = this.centries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, T> entry = iterator.next();
                if (!(entry.getValue() instanceof Hideable) || !((Hideable)entry.getValue()).isHidden()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public void removeStatic() {
        Object object = this.modificationLock;
        synchronized (object) {
            Iterator<Map.Entry<String, T>> iterator = this.centries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, T> entry = iterator.next();
                if (!(entry.getValue() instanceof StaticDefinable) || !((StaticDefinable)entry.getValue()).isStatic()) continue;
                iterator.remove();
            }
        }
    }

    @JsonIgnore
    public void clearHashes() {
        for (Map.Entry<String, T> entry : this.centries.entrySet()) {
            if (!(entry.getValue() instanceof Hashed)) continue;
            ((Hashed)entry.getValue()).clearHash();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOthers(String key) {
        Object object = this.modificationLock;
        synchronized (object) {
            T tmp = this.centries.get(key);
            this.centries.clear();
            this.centries.put(key, tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public T putCEntry(String key, T value) {
        Object object = this.modificationLock;
        synchronized (object) {
            return this.centries.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public void putCObject(String key, Object value) {
        Object object = this.modificationLock;
        synchronized (object) {
            this.centries.put(key, value);
        }
    }

    @JsonIgnore
    public T getCEntry(String key) {
        return this.centries.get(key);
    }

    @JsonIgnore
    public boolean exists(String key) {
        return this.centries.containsKey(key);
    }

    public String toString() {
        return "SecurityDynamicConfiguration [seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", ctype=" + this.ctype + ", version=" + this.version + ", centries=" + this.centries + ", getImplementingClass()=" + this.getImplementingClass() + "]";
    }

    @JsonIgnore
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean omitDefaults = params != null && params.paramAsBoolean("omit_defaults", false);
        return builder.map((Map)DefaultObjectMapper.readValue(DefaultObjectMapper.writeValueAsString(this, omitDefaults), typeRefMSO));
    }

    @JsonIgnore
    public boolean isFragment() {
        return false;
    }

    @JsonIgnore
    public long getSeqNo() {
        return this.seqNo;
    }

    @JsonIgnore
    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @JsonIgnore
    public void setSeqNoPrimaryTerm(long seqNo, long primaryTerm) {
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    @JsonIgnore
    public CType<T> getCType() {
        return this.ctype;
    }

    @JsonIgnore
    public int getVersion() {
        return this.version;
    }

    @JsonIgnore
    public SecurityDynamicConfiguration<?> getAutoConvertedFrom() {
        return this.autoConvertedFrom;
    }

    @JsonIgnore
    public void setAutoConvertedFrom(SecurityDynamicConfiguration<?> autoConvertedFrom) {
        this.autoConvertedFrom = autoConvertedFrom;
    }

    @JsonIgnore
    public Class<?> getImplementingClass() {
        return this.getCType() == null ? null : this.getCType().getConfigClass();
    }

    @JsonIgnore
    public SecurityDynamicConfiguration<T> clone() {
        SecurityDynamicConfiguration<T> result = new SecurityDynamicConfiguration<T>();
        result.version = this.version;
        result.ctype = this.ctype;
        result.primaryTerm = this.primaryTerm;
        result.seqNo = this.seqNo;
        result._meta = this._meta;
        result.centries.putAll(this.centries);
        return result;
    }

    @JsonIgnore
    public SecurityDynamicConfiguration<T> deepClone() {
        try {
            if (this.ctype != null) {
                SecurityDynamicConfiguration<T> result = SecurityDynamicConfiguration.fromJson(DefaultObjectMapper.writeValueAsString(this, false), this.ctype, this.version, this.seqNo, this.primaryTerm);
                result.autoConvertedFrom = this.autoConvertedFrom;
                return result;
            }
            SecurityDynamicConfiguration<?> result = SecurityDynamicConfiguration.fromJsonWithoutAutoConversion(DefaultObjectMapper.writeValueAsString(this, false), this.ctypeUnsafe, this.version, this.seqNo, this.primaryTerm);
            return result;
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    @JsonIgnore
    public SecurityDynamicConfiguration<T> deepCloneWithRedaction() {
        try {
            if (this.ctype != null) {
                SecurityDynamicConfiguration<T> result = SecurityDynamicConfiguration.fromJson(DefaultObjectMapper.writeValueAsStringAndRedactSensitive(this), this.ctype, this.version, this.seqNo, this.primaryTerm);
                result.autoConvertedFrom = this.autoConvertedFrom;
                return result;
            }
            SecurityDynamicConfiguration<?> result = SecurityDynamicConfiguration.fromJsonWithoutAutoConversion(DefaultObjectMapper.writeValueAsStringAndRedactSensitive(this), this.ctypeUnsafe, this.version, this.seqNo, this.primaryTerm);
            return result;
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public void remove(String key) {
        Object object = this.modificationLock;
        synchronized (object) {
            this.centries.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public void remove(List<String> keySet) {
        Object object = this.modificationLock;
        synchronized (object) {
            keySet.stream().forEach(this.centries::remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(SecurityDynamicConfiguration other) {
        Object object = this.modificationLock;
        synchronized (object) {
            if (other.ctype == null || !other.ctype.equals(this.ctype)) {
                return false;
            }
            if (other.getImplementingClass() == null || !other.getImplementingClass().equals(this.getImplementingClass())) {
                return false;
            }
            if (other.version != this.version) {
                return false;
            }
            this.centries.putAll(other.centries);
            return true;
        }
    }

    @JsonIgnore
    public boolean containsAny(SecurityDynamicConfiguration other) {
        return !Collections.disjoint(this.getCEntries().keySet(), other.getCEntries().keySet());
    }

    public boolean isHidden(String resourceName) {
        T o = this.centries.get(resourceName);
        return o instanceof Hideable && ((Hideable)o).isHidden();
    }

    @JsonIgnore
    public boolean isStatic(String resourceName) {
        T o = this.centries.get(resourceName);
        return o instanceof StaticDefinable && ((StaticDefinable)o).isStatic();
    }

    @JsonIgnore
    public boolean isReserved(String resourceName) {
        T o = this.centries.get(resourceName);
        return o instanceof Hideable && ((Hideable)o).isReserved();
    }
}

