/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.config;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.opensearch.OpenSearchException;

final class KeyStoreUtils {
    KeyStoreUtils() {
    }

    public static X509Certificate[] x509Certificates(Path file) {
        X509Certificate[] certificates = SecuritySslContext.toX509Certificates(file.toFile());
        if (certificates == null || certificates.length == 0) {
            throw new OpenSearchException("Couldn't read SSL certificates from " + file, new Object[0]);
        }
        return certificates;
    }

    public static KeyStore loadTrustStore(Path path, String type, String alias, char[] password) {
        try {
            KeyStore keyStore = KeyStoreUtils.loadKeyStore(path, type, password);
            if (alias != null) {
                if (!keyStore.isCertificateEntry(alias)) {
                    throw new OpenSearchException("Alias " + alias + " does not contain a certificate entry", new Object[0]);
                }
                X509Certificate aliasCertificate = (X509Certificate)keyStore.getCertificate(alias);
                if (aliasCertificate == null) {
                    throw new OpenSearchException("Couldn't find SSL certificate for alias " + alias, new Object[0]);
                }
                keyStore = KeyStoreUtils.newKeyStore();
                keyStore.setCertificateEntry(alias, aliasCertificate);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new OpenSearchException("Failed to load trust store from " + path, (Throwable)e, new Object[0]);
        }
    }

    public static KeyStore newTrustStoreFromPem(Path pemFile) {
        try {
            X509Certificate[] certs = KeyStoreUtils.x509Certificates(pemFile);
            KeyStore keyStore = KeyStoreUtils.newKeyStore();
            for (int i = 0; i < certs.length; ++i) {
                X509Certificate c = certs[i];
                keyStore.setCertificateEntry("os-sec-plugin-pem-cert-" + i, c);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new OpenSearchException("Failed to load SSL certificates from " + pemFile, (Throwable)e, new Object[0]);
        }
    }

    private static KeyStore newKeyStore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        return keyStore;
    }

    public static void validateKeyStoreCertificates(KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String a = aliases.nextElement();
                if (keyStore.isCertificateEntry(a)) {
                    X509Certificate c = (X509Certificate)keyStore.getCertificate(a);
                    if (c == null) {
                        throw new CertificateException("Alias " + a + " does not contain a certificate entry");
                    }
                    c.checkValidity();
                    continue;
                }
                if (!keyStore.isKeyEntry(a)) continue;
                Certificate[] cc = keyStore.getCertificateChain(a);
                if (cc == null) {
                    throw new CertificateException("Alias " + a + " does not contain a certificate chain");
                }
                for (Certificate c : cc) {
                    ((X509Certificate)c).checkValidity();
                }
            }
        }
        catch (KeyStoreException e) {
            throw new OpenSearchException("Couldn't load keys store", (Throwable)e, new Object[0]);
        }
        catch (CertificateException e) {
            throw new OpenSearchException("Invalid certificates", (Throwable)e, new Object[0]);
        }
    }

    public static KeyStore loadKeyStore(Path path, String type, char[] password) {
        KeyStore keyStore;
        block11: {
            KeyStore keyStore2 = KeyStore.getInstance(type);
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                keyStore2.load(in, password);
                keyStore = keyStore2;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Exception e) {
                    throw new OpenSearchException("Failed to load keystore from " + path, (Throwable)e, new Object[0]);
                }
            }
            in.close();
        }
        return keyStore;
    }

    public static KeyStore newKeyStore(Path path, String type, String alias, char[] password, char[] keyPassword) {
        try {
            KeyStore keyStore = KeyStoreUtils.loadKeyStore(path, type, password);
            if (alias != null) {
                if (!keyStore.isKeyEntry(alias)) {
                    throw new CertificateException("Couldn't find SSL key for alias " + alias);
                }
                Certificate[] certificateChain = keyStore.getCertificateChain(alias);
                if (certificateChain == null) {
                    throw new CertificateException("Couldn't find certificate chain for alias " + alias);
                }
                Key key = keyStore.getKey(alias, keyPassword);
                keyStore = KeyStoreUtils.newKeyStore();
                keyStore.setKeyEntry(alias, key, keyPassword, certificateChain);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new OpenSearchException("Failed to load key store from " + path, (Throwable)e, new Object[0]);
        }
    }

    public static KeyStore newKeyStoreFromPem(Path certificateChainPath, Path keyPath, char[] keyPassword) {
        try {
            Certificate[] certificateChain = KeyStoreUtils.x509Certificates(certificateChainPath);
            KeyStore keyStore = KeyStoreUtils.newKeyStore();
            PrivateKey key = SecuritySslContext.toPrivateKey(keyPath.toFile(), keyPassword != null ? new String(keyPassword) : null);
            keyStore.setKeyEntry("key", key, keyPassword, certificateChain);
            return keyStore;
        }
        catch (Exception e) {
            throw new OpenSearchException("Failed read key from " + keyPath, (Throwable)e, new Object[0]);
        }
    }

    private static final class SecuritySslContext
    extends SslContext {
        private SecuritySslContext() {
        }

        public boolean isClient() {
            throw new UnsupportedOperationException("Method isClient is not supported");
        }

        public List<String> cipherSuites() {
            throw new UnsupportedOperationException("Method cipherSuites is not supported");
        }

        public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
            throw new UnsupportedOperationException("Method applicationProtocolNegotiator is not supported");
        }

        public SSLEngine newEngine(ByteBufAllocator alloc) {
            throw new UnsupportedOperationException("Method newEngine is not supported");
        }

        public SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
            throw new UnsupportedOperationException("Method newEngine is not supported");
        }

        public SSLSessionContext sessionContext() {
            throw new UnsupportedOperationException("Method sessionContext is not supported");
        }

        public static X509Certificate[] toX509Certificates(File file) {
            try {
                return SslContext.toX509Certificates((File)file);
            }
            catch (CertificateException e) {
                throw new OpenSearchException("Couldn't read SSL certificates from " + file, (Throwable)e, new Object[0]);
            }
        }

        protected static PrivateKey toPrivateKey(File keyFile, String keyPassword) throws InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, IOException, KeyException {
            return SslContext.toPrivateKey((File)keyFile, (String)keyPassword);
        }
    }
}

