/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.tools;

import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensearch.common.collect.Tuple;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.securityconf.Migration;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.NodesDn;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v6.ConfigV6;
import org.opensearch.security.securityconf.impl.v6.InternalUserV6;
import org.opensearch.security.securityconf.impl.v6.RoleMappingsV6;
import org.opensearch.security.securityconf.impl.v6.RoleV6;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.InternalUserV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;

public class Migrater {
    public static void main(String[] args) {
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        options.addOption(Option.builder((String)"dir").argName("directory").hasArg().required().desc("Directory containing file to be migrated").build());
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("dir")) {
                File dir = new File(line.getOptionValue("dir"));
                if (!Migrater.migrateDirectory(dir, true)) {
                    System.exit(-1);
                } else {
                    System.exit(0);
                }
            }
        }
        catch (Exception exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            formatter.printHelp("migrater.sh", options, true);
        }
        System.exit(-1);
    }

    public static boolean migrateDirectory(File dir, boolean backup) {
        if (!dir.exists()) {
            System.out.println(dir.getAbsolutePath() + " does not exist");
            return false;
        }
        if (!dir.isDirectory()) {
            System.out.println(dir.getAbsolutePath() + " is not a directory");
            return false;
        }
        boolean retVal = Migrater.migrateFile(new File(dir, "config.yml"), CType.CONFIG, backup);
        retVal = Migrater.migrateFile(new File(dir, "action_groups.yml"), CType.ACTIONGROUPS, backup) && retVal;
        retVal = Migrater.migrateFile(new File(dir, "roles.yml"), CType.ROLES, backup) && retVal;
        retVal = Migrater.migrateFile(new File(dir, "roles_mapping.yml"), CType.ROLESMAPPING, backup) && retVal;
        retVal = Migrater.migrateFile(new File(dir, "internal_users.yml"), CType.INTERNALUSERS, backup) && retVal;
        retVal = Migrater.migrateFile(new File(dir, "nodes_dn.yml"), CType.NODESDN, backup) && retVal;
        retVal = Migrater.migrateFile(new File(dir, "audit.yml"), CType.AUDIT, backup) && retVal;
        return retVal;
    }

    public static boolean migrateFile(File file, CType<?> cType, boolean backup) {
        String absolutePath = file.getAbsolutePath();
        if (!file.exists() && cType != CType.NODESDN) {
            System.out.println("Skip " + absolutePath + " because it does not exist");
            return false;
        }
        if (!file.isFile()) {
            System.out.println("Skip " + absolutePath + " because it is a directory or a special file");
            return false;
        }
        try {
            if (cType == CType.ACTIONGROUPS) {
                SecurityDynamicConfiguration<ActionGroupsV7> val;
                try {
                    val = Migration.migrateActionGroups(SecurityDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(file), CType.ACTIONGROUPS, 0, 0L, 0L));
                }
                catch (Exception e) {
                    val = Migration.migrateActionGroups(SecurityDynamicConfiguration.fromNode(DefaultObjectMapper.YAML_MAPPER.readTree(file), CType.ACTIONGROUPS, 1, 0L, 0L));
                }
                return Migrater.backupAndWrite(file, val, backup);
            }
            if (cType == CType.CONFIG) {
                SecurityDynamicConfiguration<ConfigV7> val = Migration.migrateConfig(Migration.readYaml(file, ConfigV6.class));
                return Migrater.backupAndWrite(file, val, backup);
            }
            if (cType == CType.ROLES) {
                Tuple<SecurityDynamicConfiguration<RoleV7>, SecurityDynamicConfiguration<TenantV7>> tup = Migration.migrateRoles(Migration.readYaml(file, RoleV6.class), null);
                boolean roles = Migrater.backupAndWrite(file, (SecurityDynamicConfiguration)tup.v1(), backup);
                return roles && Migrater.backupAndWrite(new File(file.getParent(), "tenants.yml"), (SecurityDynamicConfiguration)tup.v2(), backup);
            }
            if (cType == CType.ROLESMAPPING) {
                SecurityDynamicConfiguration<RoleMappingsV7> val = Migration.migrateRoleMappings(Migration.readYaml(file, RoleMappingsV6.class));
                return Migrater.backupAndWrite(file, val, backup);
            }
            if (cType == CType.INTERNALUSERS) {
                SecurityDynamicConfiguration<InternalUserV7> val = Migration.migrateInternalUsers(Migration.readYaml(file, InternalUserV6.class));
                return Migrater.backupAndWrite(file, val, backup);
            }
            if (cType == CType.AUDIT) {
                SecurityDynamicConfiguration<AuditConfig> val = Migration.migrateAudit(Migration.readYaml(file, AuditConfig.class));
                return Migrater.backupAndWrite(file, val, backup);
            }
            if (cType == CType.NODESDN) {
                SecurityDynamicConfiguration<NodesDn> val = Migration.migrateNodesDn(Migration.readYaml(file, NodesDn.class));
                return Migrater.backupAndWrite(file, val, backup);
            }
        }
        catch (Exception e) {
            System.out.println("Can not migrate " + file + " due to " + e);
        }
        return false;
    }

    private static boolean backupAndWrite(File file, SecurityDynamicConfiguration<?> val, boolean backup) {
        try {
            if (val == null) {
                System.out.println("NULL object for " + file.getAbsolutePath());
                return false;
            }
            if (backup && file.exists()) {
                Files.copy((File)file, (File)new File(file.getParent(), file.getName() + ".bck6"));
            }
            DefaultObjectMapper.YAML_MAPPER.writeValue(file, val);
            System.out.println("Migrated (as " + val.getCType() + ") " + file.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            System.out.println("Unable to write " + file.getAbsolutePath() + ". This is unexpected and we will abort migration.");
            System.out.println("    Details: " + e.getMessage());
            return false;
        }
    }
}

