/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.ldap.backend;

import com.amazon.dlic.auth.ldap.LdapUser;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.LdapEntry;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchScope;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.ldap.backend.LDAPAuthorizationBackend;
import org.opensearch.security.auth.ldap.util.LdapHelper;
import org.opensearch.security.auth.ldap.util.Utils;
import org.opensearch.security.setting.DeprecatedSettings;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.User;

public class LDAPAuthenticationBackend
implements AuthenticationBackend {
    static final int ZERO_PLACEHOLDER = 0;
    static final String DEFAULT_USERBASE = "";
    static final String DEFAULT_USERSEARCH_PATTERN = "(sAMAccountName={0})";
    protected static final Logger log = LogManager.getLogger(LDAPAuthenticationBackend.class);
    private final Settings settings;
    private final Path configPath;
    private final List<Map.Entry<String, Settings>> userBaseSettings;
    private final int customAttrMaxValueLen;
    private final WildcardMatcher allowlistedCustomLdapAttrMatcher;
    private final String[] returnAttributes;
    private final boolean shouldFollowReferrals;

    public LDAPAuthenticationBackend(Settings settings, Path configPath) {
        this.settings = settings;
        this.configPath = configPath;
        this.userBaseSettings = LDAPAuthenticationBackend.getUserBaseSettings(settings);
        this.returnAttributes = settings.getAsList("custom_return_attributes", Arrays.asList(ReturnAttributes.ALL.value())).toArray(new String[0]);
        this.shouldFollowReferrals = settings.getAsBoolean("follow_referrals", Boolean.valueOf(true));
        this.customAttrMaxValueLen = settings.getAsInt("custom_attr_maxval_len", Integer.valueOf(36));
        DeprecatedSettings.checkForDeprecatedSetting(settings, "custom_attr_whitelist", "custom_attr_allowlist");
        List customAttrAllowList = settings.getAsList("custom_attr_allowlist", settings.getAsList("custom_attr_whitelist", Collections.singletonList("*")));
        this.allowlistedCustomLdapAttrMatcher = WildcardMatcher.from(customAttrAllowList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User authenticate(AuthCredentials credentials) throws OpenSearchSecurityException {
        Connection ldapConnection = null;
        String user = credentials.getUsername();
        byte[] password = credentials.getPassword();
        try {
            ConnectionConfig connectionConfig;
            String dn;
            LdapEntry entry;
            try {
                ldapConnection = LDAPAuthorizationBackend.getConnection(this.settings, this.configPath);
                entry = LDAPAuthenticationBackend.exists(user, ldapConnection, this.settings, this.userBaseSettings, this.returnAttributes, this.shouldFollowReferrals);
                if (entry == null && this.settings.getAsBoolean("fakelogin_enabled", Boolean.valueOf(false)).booleanValue()) {
                    String fakeLognDn = this.settings.get("fakelogin_dn", "CN=faketomakebindfail,DC=" + UUID.randomUUID().toString());
                    entry = new LdapEntry(fakeLognDn);
                    password = this.settings.get("fakelogin_password", "fakeLoginPwd123").getBytes(StandardCharsets.UTF_8);
                } else if (entry == null) {
                    throw new OpenSearchSecurityException("No user " + user + " found", new Object[0]);
                }
                dn = entry.getDn();
                if (log.isTraceEnabled()) {
                    log.trace("Try to authenticate dn {}", (Object)dn);
                }
                connectionConfig = ldapConnection.getConnectionConfig();
            }
            catch (Throwable throwable) {
                Utils.unbindAndCloseSilently(ldapConnection);
                throw throwable;
            }
            Utils.unbindAndCloseSilently(ldapConnection);
            LDAPAuthorizationBackend.checkConnection(connectionConfig, dn, password);
            String usernameAttribute = this.settings.get("username_attribute", null);
            String username = dn;
            if (usernameAttribute != null && entry.getAttribute(usernameAttribute) != null) {
                username = Utils.getSingleStringValue(entry.getAttribute(usernameAttribute));
            }
            if (log.isDebugEnabled()) {
                log.debug("Authenticated username {}", (Object)username);
            }
            LdapUser ldapUser = new LdapUser(username, user, entry, credentials, this.customAttrMaxValueLen, this.allowlistedCustomLdapAttrMatcher);
            return ldapUser;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to authenticate user due to ", (Throwable)e);
            }
            throw new OpenSearchSecurityException(e.toString(), e, new Object[0]);
        }
        finally {
            Arrays.fill(password, (byte)0);
            password = null;
            Utils.unbindAndCloseSilently(ldapConnection);
        }
    }

    @Override
    public String getType() {
        return "ldap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(User user) {
        boolean bl;
        Connection ldapConnection = null;
        String userName = user.getName();
        if (user instanceof LdapUser) {
            userName = ((LdapUser)user).getUserEntry().getDn();
        }
        try {
            boolean exists;
            ldapConnection = LDAPAuthorizationBackend.getConnection(this.settings, this.configPath);
            LdapEntry userEntry = LDAPAuthenticationBackend.exists(userName, ldapConnection, this.settings, this.userBaseSettings, this.returnAttributes, this.shouldFollowReferrals);
            boolean bl2 = exists = userEntry != null;
            if (exists) {
                user.addAttributes(LdapUser.extractLdapAttributes(userName, userEntry, this.customAttrMaxValueLen, this.allowlistedCustomLdapAttrMatcher));
            }
            bl = exists;
        }
        catch (Exception e) {
            boolean bl3;
            try {
                log.warn("User {} does not exist due to ", (Object)userName, (Object)e);
                bl3 = false;
            }
            catch (Throwable throwable) {
                Utils.unbindAndCloseSilently(ldapConnection);
                throw throwable;
            }
            Utils.unbindAndCloseSilently(ldapConnection);
            return bl3;
        }
        Utils.unbindAndCloseSilently(ldapConnection);
        return bl;
    }

    static List<Map.Entry<String, Settings>> getUserBaseSettings(Settings settings) {
        HashMap<String, Settings> userBaseSettingsMap = new HashMap<String, Settings>(settings.getGroups("users"));
        if (!userBaseSettingsMap.isEmpty()) {
            if (settings.hasValue("userbase")) {
                throw new RuntimeException("Both old-style and new-style configuration defined for LDAP authentication backend: " + String.valueOf(settings));
            }
            return Utils.getOrderedBaseSettings(userBaseSettingsMap);
        }
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("base", settings.get("userbase", DEFAULT_USERBASE));
        settingsBuilder.put("search", settings.get("usersearch", DEFAULT_USERSEARCH_PATTERN));
        return Collections.singletonList(Pair.of((Object)"_legacyConfig", (Object)settingsBuilder.build()));
    }

    static LdapEntry exists(String user, Connection ldapConnection, Settings settings, List<Map.Entry<String, Settings>> userBaseSettings, String[] returnAttributes, boolean shouldFollowReferrals) throws Exception {
        if (settings.getAsBoolean("fakelogin_enabled", Boolean.valueOf(false)).booleanValue() || settings.getAsBoolean("search_all_bases", Boolean.valueOf(false)).booleanValue() || settings.hasValue("userbase")) {
            return LDAPAuthenticationBackend.existsSearchingAllBases(user, ldapConnection, userBaseSettings, returnAttributes, shouldFollowReferrals);
        }
        return LDAPAuthenticationBackend.existsSearchingUntilFirstHit(user, ldapConnection, userBaseSettings, returnAttributes, shouldFollowReferrals);
    }

    private static LdapEntry existsSearchingUntilFirstHit(String user, Connection ldapConnection, List<Map.Entry<String, Settings>> userBaseSettings, String[] returnAttributes, boolean shouldFollowReferrals) throws Exception {
        String username = user;
        boolean isDebugEnabled = log.isDebugEnabled();
        for (Map.Entry<String, Settings> entry : userBaseSettings) {
            Settings baseSettings = entry.getValue();
            SearchFilter f = new SearchFilter();
            f.setFilter(baseSettings.get("search", DEFAULT_USERSEARCH_PATTERN));
            f.setParameter(0, (Object)username);
            List<LdapEntry> result = LdapHelper.search(ldapConnection, baseSettings.get("base", DEFAULT_USERBASE), f, SearchScope.SUBTREE, returnAttributes, shouldFollowReferrals);
            if (isDebugEnabled) {
                log.debug("Results for LDAP search for {} in base {} is {}", (Object)user, (Object)entry.getKey(), result);
            }
            if (result == null || result.size() < 1) continue;
            return result.get(0);
        }
        return null;
    }

    private static LdapEntry existsSearchingAllBases(String user, Connection ldapConnection, List<Map.Entry<String, Settings>> userBaseSettings, String[] returnAttributes, boolean shouldFollowReferrals) throws Exception {
        String username = user;
        HashSet<LdapEntry> result = new HashSet<LdapEntry>();
        boolean isDebugEnabled = log.isDebugEnabled();
        for (Map.Entry<String, Settings> entry : userBaseSettings) {
            Settings baseSettings = entry.getValue();
            SearchFilter f = new SearchFilter();
            f.setFilter(baseSettings.get("search", DEFAULT_USERSEARCH_PATTERN));
            f.setParameter(0, (Object)username);
            List<LdapEntry> foundEntries = LdapHelper.search(ldapConnection, baseSettings.get("base", DEFAULT_USERBASE), f, SearchScope.SUBTREE, returnAttributes, shouldFollowReferrals);
            if (isDebugEnabled) {
                log.debug("Results for LDAP search for " + user + " in base " + entry.getKey() + ":\n" + String.valueOf(result));
            }
            if (foundEntries == null) continue;
            result.addAll(foundEntries);
        }
        if (result.isEmpty()) {
            log.debug("No user {} found", (Object)username);
            return null;
        }
        if (result.size() > 1) {
            log.debug("More than one user for '{}' found", (Object)username);
            return null;
        }
        return (LdapEntry)result.iterator().next();
    }
}

