/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchParseException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.NamedRoute;
import org.opensearch.rest.RestHandler;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.user.User;

public class Utils {
    public static final String PLUGIN_ROUTE_PREFIX = "/_plugins/_security";
    @Deprecated
    public static final String LEGACY_PLUGIN_ROUTE_PREFIX = "/_opendistro/_security";
    public static final String PLUGIN_API_ROUTE_PREFIX = "/_plugins/_security/api";
    @Deprecated
    public static final String LEGACY_PLUGIN_API_ROUTE_PREFIX = "/_opendistro/_security/api";
    public static final String OPENDISTRO_API_DEPRECATION_MESSAGE = "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead.";
    private static final ObjectMapper internalMapper = new ObjectMapper();

    public static Map<String, Object> convertJsonToxToStructuredMap(ToXContent jsonContent) {
        Map map = null;
        try {
            BytesReference bytes = XContentHelper.toXContent((ToXContent)jsonContent, (XContentType)XContentType.JSON, (boolean)false);
            map = (Map)XContentHelper.convertToMap((BytesReference)bytes, (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e1);
        }
        return map;
    }

    public static Map<String, Object> convertJsonToxToStructuredMap(String jsonContent) {
        Map map;
        block8: {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonContent);
            try {
                map = parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e1) {
                    throw ExceptionsHelper.convertToOpenSearchException((Exception)e1);
                }
            }
            parser.close();
        }
        return map;
    }

    private static BytesReference convertStructuredMapToBytes(Map<String, ?> structuredMap) {
        try {
            return BytesReference.bytes((XContentBuilder)JsonXContent.contentBuilder().map(structuredMap));
        }
        catch (IOException e) {
            throw new OpenSearchParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static String convertStructuredMapToJson(Map<String, ?> structuredMap) {
        try {
            return XContentHelper.convertToJson((BytesReference)Utils.convertStructuredMapToBytes(structuredMap), (boolean)false, (MediaType)XContentType.JSON);
        }
        catch (IOException e) {
            throw new OpenSearchParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static JsonNode convertJsonToJackson(BytesReference jsonContent) {
        try {
            return DefaultObjectMapper.readTree(jsonContent.utf8ToString());
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e1);
        }
    }

    public static JsonNode toJsonNode(String content) throws IOException {
        return DefaultObjectMapper.readTree(content);
    }

    public static Object toConfigObject(JsonNode content, Class<?> clazz) throws IOException {
        return DefaultObjectMapper.readTree(content, clazz);
    }

    public static JsonNode convertJsonToJackson(ToXContent jsonContent, boolean omitDefaults) {
        try {
            return DefaultObjectMapper.readTree(Strings.toString((MediaType)XContentType.JSON, (ToXContent)jsonContent, (ToXContent.Params)new ToXContent.MapParams(Map.of("omit_defaults", String.valueOf(omitDefaults)))));
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e1);
        }
    }

    public static byte[] jsonMapToByteArray(Map<String, Object> jsonAsMap) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> internalMapper.writeValueAsBytes((Object)jsonAsMap));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof JsonProcessingException) {
                throw (JsonProcessingException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static Map<String, Object> byteArrayToMutableJsonMap(byte[] jsonBytes) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> (Map)internalMapper.readValue(jsonBytes, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static Set<String> generateFieldResourcePaths(Set<String> fields, String prefix) {
        return (Set)fields.stream().map(field -> prefix + field).collect(ImmutableSet.toImmutableSet());
    }

    public static List<RestHandler.Route> addRoutesPrefix(List<RestHandler.Route> routes) {
        return Utils.addRoutesPrefix(routes, PLUGIN_API_ROUTE_PREFIX);
    }

    @Deprecated
    public static List<RestHandler.DeprecatedRoute> addLegacyRoutesPrefix(List<RestHandler.DeprecatedRoute> routes) {
        return Utils.addDeprecatedRoutesPrefix(routes, LEGACY_PLUGIN_API_ROUTE_PREFIX);
    }

    public static List<RestHandler.Route> addRoutesPrefix(List<RestHandler.Route> routes, String ... prefixes) {
        return (List)routes.stream().flatMap(r -> Arrays.stream(prefixes).map(p -> {
            if (r instanceof NamedRoute) {
                NamedRoute nr = (NamedRoute)r;
                return new NamedRoute.Builder().method(nr.getMethod()).path(p + nr.getPath()).uniqueName(nr.name()).legacyActionNames(nr.actionNames()).build();
            }
            return new RestHandler.Route(r.getMethod(), p + r.getPath());
        })).collect(ImmutableList.toImmutableList());
    }

    public static List<RestHandler.DeprecatedRoute> addDeprecatedRoutesPrefix(List<RestHandler.DeprecatedRoute> deprecatedRoutes) {
        return Utils.addDeprecatedRoutesPrefix(deprecatedRoutes, LEGACY_PLUGIN_API_ROUTE_PREFIX, PLUGIN_API_ROUTE_PREFIX);
    }

    public static List<RestHandler.DeprecatedRoute> addDeprecatedRoutesPrefix(List<RestHandler.DeprecatedRoute> deprecatedRoutes, String ... prefixes) {
        return (List)deprecatedRoutes.stream().flatMap(r -> Arrays.stream(prefixes).map(p -> new RestHandler.DeprecatedRoute(r.getMethod(), p + r.getPath(), r.getDeprecationMessage()))).collect(ImmutableList.toImmutableList());
    }

    public static Pair<User, TransportAddress> userAndRemoteAddressFrom(ThreadContext threadContext) {
        User user = (User)threadContext.getTransient("_opendistro_security_user");
        TransportAddress remoteAddress = (TransportAddress)threadContext.getTransient("_opendistro_security_remote_address");
        return Pair.of((Object)user, (Object)remoteAddress);
    }

    public static <T> T withIOException(CheckedSupplier<T, IOException> action) {
        try {
            return (T)action.get();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

