/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.interfaces.XECKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.jcajce.interfaces.DSTU4145Key;
import org.bouncycastle.jcajce.interfaces.DSTU4145PrivateKey;
import org.bouncycastle.jcajce.interfaces.DSTU4145PublicKey;
import org.bouncycastle.jcajce.interfaces.ECGOST3410PrivateKey;
import org.bouncycastle.jcajce.interfaces.ECGOST3410PublicKey;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.GOST3410Key;
import org.bouncycastle.jcajce.interfaces.GOST3410PrivateKey;
import org.bouncycastle.jcajce.interfaces.GOST3410PublicKey;
import org.bouncycastle.jcajce.interfaces.LMSKey;
import org.bouncycastle.jcajce.interfaces.LMSPrivateKey;
import org.bouncycastle.jcajce.interfaces.LMSPublicKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.jcajce.spec.DSTU4145ParameterSpec;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410DomainParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ConsistentKeyPair {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public ConsistentKeyPair(final PublicKey publicKey, final PrivateKey privateKey) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ConsistentKeyPair.this.checkKeyPairForConsistency(publicKey, privateKey);
                return null;
            }
        });
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkKeyPairForConsistency(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey instanceof ECKey && privateKey instanceof ECKey) {
            ECPrivateKey priv = (ECPrivateKey)privateKey;
            ECPublicKey pub = (ECPublicKey)publicKey;
            if (!(priv.getParams().getCurve().equals(pub.getParams().getCurve()) && priv.getParams().getGenerator().equals(pub.getParams().getGenerator()) && priv.getParams().getOrder().equals(pub.getParams().getOrder()) && priv.getParams().getCofactor() == pub.getParams().getCofactor())) {
                throw new IllegalArgumentException("EC keys do not have the same domain parameters");
            }
            ECDomainParameterSpec spec = new ECDomainParameterSpec(priv.getParams());
            if (spec.getDomainParameters().getG().multiply(priv.getS()).normalize().equals(spec.getDomainParameters().getCurve().createPoint(pub.getW().getAffineX(), pub.getW().getAffineY()))) return;
            throw new IllegalArgumentException("EC public key not consistent with EC private key");
        }
        if (publicKey instanceof DHKey && privateKey instanceof DHKey) {
            DHPrivateKey priv = (DHPrivateKey)privateKey;
            DHPublicKey pub = (DHPublicKey)publicKey;
            DHParameterSpec dhParameters = priv.getParams();
            if (!dhParameters.getG().equals(pub.getParams().getG()) && !dhParameters.getP().equals(pub.getParams().getP())) {
                throw new IllegalArgumentException("DH keys do not have the same domain parameters");
            }
            if (dhParameters.getG().modPow(priv.getX(), dhParameters.getP()).equals(pub.getY())) return;
            throw new IllegalArgumentException("DH public key not consistent with DH private key");
        }
        if (publicKey instanceof DSAKey && privateKey instanceof DSAKey) {
            DSAPrivateKey priv = (DSAPrivateKey)privateKey;
            DSAPublicKey pub = (DSAPublicKey)publicKey;
            DSAParams dsaParameters = priv.getParams();
            if (!(dsaParameters.getG().equals(pub.getParams().getG()) || dsaParameters.getP().equals(pub.getParams().getP()) || dsaParameters.getQ().equals(pub.getParams().getQ()))) {
                throw new IllegalArgumentException("DSA keys do not have the same domain parameters");
            }
            if (dsaParameters.getG().modPow(priv.getX(), dsaParameters.getP()).equals(pub.getY())) return;
            throw new IllegalArgumentException("DSA public key not consistent with DSA private key");
        }
        if (publicKey instanceof RSAKey && privateKey instanceof RSAKey) {
            RSAPrivateKey priv = (RSAPrivateKey)privateKey;
            RSAPublicKey pub = (RSAPublicKey)publicKey;
            if (!priv.getModulus().equals(pub.getModulus())) {
                throw new IllegalArgumentException("RSA keys do not have the same modulus");
            }
            BigInteger val = BigInteger.valueOf(2L);
            if (val.modPow(priv.getPrivateExponent(), priv.getModulus()).modPow(pub.getPublicExponent(), priv.getModulus()).equals(val)) return;
            throw new IllegalArgumentException("RSA public key not consistent with RSA private key");
        }
        if (publicKey instanceof GOST3410Key && privateKey instanceof GOST3410Key) {
            if (!((GOST3410Key)((Object)publicKey)).getParams().equals(((GOST3410Key)((Object)privateKey)).getParams())) {
                throw new IllegalArgumentException("GOST3410 parameters mismatch");
            }
            if (publicKey instanceof GOST3410PublicKey && privateKey instanceof GOST3410PrivateKey) {
                GOST3410PrivateKey priv = (GOST3410PrivateKey)privateKey;
                GOST3410PublicKey pub = (GOST3410PublicKey)publicKey;
                GOST3410ParameterSpec gostParameters = priv.getParams();
                GOST3410DomainParameterSpec gParams = (GOST3410DomainParameterSpec)gostParameters.getDomainParametersSpec();
                if (gParams.getA().modPow(priv.getX(), gParams.getP()).equals(pub.getY())) return;
                throw new IllegalArgumentException("GOST3410 public key not consistent with GOST3410 private key");
            }
            if (!(publicKey instanceof ECGOST3410PublicKey) || !(privateKey instanceof ECGOST3410PrivateKey)) throw new IllegalArgumentException("GOST3410 key pair inconsistent");
            ECGOST3410PrivateKey priv = (ECGOST3410PrivateKey)privateKey;
            ECGOST3410PublicKey pub = (ECGOST3410PublicKey)publicKey;
            GOST3410ParameterSpec gostParameters = priv.getParams();
            ECDomainParameterSpec gParams = (ECDomainParameterSpec)gostParameters.getDomainParametersSpec();
            ECDomainParameterSpec spec = new ECDomainParameterSpec(gParams);
            if (spec.getDomainParameters().getG().multiply(priv.getS()).normalize().equals(spec.getDomainParameters().getCurve().createPoint(pub.getW().getAffineX(), pub.getW().getAffineY()))) return;
            throw new IllegalArgumentException("ECGOST3410 public key not consistent with ECGOST3410 private key");
        }
        if (publicKey instanceof DSTU4145Key && privateKey instanceof DSTU4145Key) {
            DSTU4145PrivateKey priv = (DSTU4145PrivateKey)privateKey;
            DSTU4145PublicKey pub = (DSTU4145PublicKey)publicKey;
            if (!priv.getParams().equals(pub.getParams())) {
                throw new IllegalArgumentException("DSTU4145 keys do not have the same domain parameters");
            }
            DSTU4145ParameterSpec dstu4145Parameters = priv.getParams();
            ECDomainParameterSpec spec = new ECDomainParameterSpec(dstu4145Parameters);
            if (spec.getDomainParameters().getG().multiply(priv.getS()).negate().normalize().equals(spec.getDomainParameters().getCurve().createPoint(pub.getW().getAffineX(), pub.getW().getAffineY()))) return;
            throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
        }
        if (publicKey instanceof EdDSAKey && privateKey instanceof EdDSAKey) {
            EdDSAKey priv = (EdDSAKey)((Object)privateKey);
            EdDSAKey pub = (EdDSAKey)((Object)publicKey);
            if (!priv.getAlgorithm().equals(pub.getAlgorithm())) {
                throw new IllegalArgumentException("EdDSA keys do not have the same domain parameters");
            }
            if (Arrays.areEqual(priv.getPublicData(), pub.getPublicData())) return;
            throw new IllegalArgumentException("EdDSA public key not consistent with EdDSA private key");
        }
        if (publicKey instanceof XDHKey && privateKey instanceof XDHKey) {
            XDHKey priv = (XDHKey)((Object)privateKey);
            XDHKey pub = (XDHKey)((Object)publicKey);
            if (!priv.getAlgorithm().equals(pub.getAlgorithm())) {
                throw new IllegalArgumentException("XDH keys do not have the same domain parameters");
            }
            if (Arrays.areEqual(priv.getPublicData(), pub.getPublicData())) return;
            throw new IllegalArgumentException("XDH public key not consistent with XDH private key");
        }
        if (publicKey instanceof EdECKey && privateKey instanceof EdECKey) {
            if (!privateKey.getAlgorithm().equals(publicKey.getAlgorithm())) {
                throw new IllegalArgumentException("EdECKey keys do not have the same domain parameters");
            }
            try {
                AsymmetricEdDSAPrivateKey priv = new AsymmetricEdDSAPrivateKey(privateKey.getEncoded());
                AsymmetricEdDSAPublicKey pub = new AsymmetricEdDSAPublicKey(publicKey.getEncoded());
                if (Arrays.areEqual(priv.getPublicData(), pub.getPublicData())) return;
                throw new IllegalArgumentException("EdECKey public key not consistent with EdECKey private key");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("EdDSA public key not consistent with EdDSA private key", e);
            }
        }
        if (publicKey instanceof XECKey && privateKey instanceof XECKey) {
            if (!privateKey.getAlgorithm().equals(publicKey.getAlgorithm())) {
                throw new IllegalArgumentException("XECKey keys do not have the same domain parameters");
            }
            try {
                SubjectPublicKeyInfo keyInfo;
                AsymmetricXDHPrivateKey priv = new AsymmetricXDHPrivateKey(privateKey.getEncoded());
                byte[] publicData = priv.getPublicData();
                if (publicData == null || Arrays.areEqual(publicData, (keyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded())).getPublicKeyData().getBytes())) return;
                throw new IllegalArgumentException("XECKey public key not consistent with XECKey private key");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("XECKey public key not consistent with XECKey private key", e);
            }
        }
        if (!(publicKey instanceof LMSKey) || !(privateKey instanceof LMSKey)) throw new IllegalArgumentException("Key pair inconsistent");
        LMSPrivateKey priv = (LMSPrivateKey)privateKey;
        LMSPublicKey pub = (LMSPublicKey)publicKey;
        if (!priv.getAlgorithm().equals(pub.getAlgorithm())) {
            throw new IllegalArgumentException("LMS keys do not have the same domain parameters");
        }
        if (Arrays.areEqual(priv.getPublicKey().getEncoded(), pub.getEncoded())) return;
        throw new IllegalArgumentException("LMS public key not consistent with LMS private key");
    }

    public PublicKey getPublic() {
        return this.publicKey;
    }

    public PrivateKey getPrivate() {
        return this.privateKey;
    }
}

