/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.validator;

import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.spark.utils.SQLQueryUtils;
import org.opensearch.sql.spark.validator.GrammarElementValidator;
import org.opensearch.sql.spark.validator.GrammarElementValidatorProvider;
import org.opensearch.sql.spark.validator.SQLQueryValidationVisitor;

public class SQLQueryValidator {
    private static final Logger log = LogManager.getLogger(SQLQueryValidator.class);
    private final GrammarElementValidatorProvider grammarElementValidatorProvider;

    public void validate(String sqlQuery, DataSourceType datasourceType) {
        GrammarElementValidator grammarElementValidator = this.grammarElementValidatorProvider.getValidatorForDatasource(datasourceType);
        SQLQueryValidationVisitor visitor = new SQLQueryValidationVisitor(grammarElementValidator);
        try {
            visitor.visit((ParseTree)SQLQueryUtils.getBaseParser(sqlQuery).singleStatement());
        }
        catch (IllegalArgumentException e) {
            log.error("Query validation failed. DataSourceType=" + datasourceType, (Throwable)e);
            throw e;
        }
    }

    public void validateFlintExtensionQuery(String sqlQuery, DataSourceType dataSourceType) {
    }

    @Generated
    public SQLQueryValidator(GrammarElementValidatorProvider grammarElementValidatorProvider) {
        this.grammarElementValidatorProvider = grammarElementValidatorProvider;
    }
}

