/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene;

import lombok.Generated;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;

public class RangeQuery
extends LuceneQuery {
    private final Comparison comparison;

    @Override
    protected QueryBuilder doBuild(String fieldName, ExprType fieldType, ExprValue literal) {
        Object value = this.value(literal, fieldType);
        RangeQueryBuilder query = QueryBuilders.rangeQuery((String)fieldName);
        switch (this.comparison) {
            case LT: {
                return query.lt(value);
            }
            case GT: {
                return query.gt(value);
            }
            case LTE: {
                return query.lte(value);
            }
            case GTE: {
                return query.gte(value);
            }
        }
        throw new IllegalStateException("Comparison is supported by range query: " + this.comparison);
    }

    @Generated
    public RangeQuery(Comparison comparison) {
        this.comparison = comparison;
    }

    public static enum Comparison {
        LT,
        GT,
        LTE,
        GTE,
        BETWEEN;

    }
}

