/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import org.opensearch.client.Client;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.domain.ColumnTypeProvider;
import org.opensearch.sql.legacy.domain.Delete;
import org.opensearch.sql.legacy.domain.IndexStatement;
import org.opensearch.sql.legacy.domain.JoinSelect;
import org.opensearch.sql.legacy.domain.QueryActionRequest;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.exception.SQLFeatureDisabledException;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.ElasticResultHandler;
import org.opensearch.sql.legacy.executor.Format;
import org.opensearch.sql.legacy.executor.QueryActionElasticExecutor;
import org.opensearch.sql.legacy.executor.adapter.QueryPlanQueryAction;
import org.opensearch.sql.legacy.executor.adapter.QueryPlanRequestBuilder;
import org.opensearch.sql.legacy.parser.ElasticLexer;
import org.opensearch.sql.legacy.parser.SqlParser;
import org.opensearch.sql.legacy.parser.SubQueryExpression;
import org.opensearch.sql.legacy.query.AggregationQueryAction;
import org.opensearch.sql.legacy.query.DefaultQueryAction;
import org.opensearch.sql.legacy.query.DeleteQueryAction;
import org.opensearch.sql.legacy.query.DescribeQueryAction;
import org.opensearch.sql.legacy.query.QueryAction;
import org.opensearch.sql.legacy.query.ShowQueryAction;
import org.opensearch.sql.legacy.query.join.OpenSearchJoinQueryActionFactory;
import org.opensearch.sql.legacy.query.multi.MultiQueryAction;
import org.opensearch.sql.legacy.query.multi.MultiQuerySelect;
import org.opensearch.sql.legacy.query.planner.core.BindingTupleQueryPlanner;
import org.opensearch.sql.legacy.rewriter.RewriteRuleExecutor;
import org.opensearch.sql.legacy.rewriter.alias.TableAliasPrefixRemoveRule;
import org.opensearch.sql.legacy.rewriter.identifier.UnquoteIdentifierRule;
import org.opensearch.sql.legacy.rewriter.join.JoinRewriteRule;
import org.opensearch.sql.legacy.rewriter.matchtoterm.TermFieldRewriter;
import org.opensearch.sql.legacy.rewriter.nestedfield.NestedFieldRewriter;
import org.opensearch.sql.legacy.rewriter.ordinal.OrdinalRewriterRule;
import org.opensearch.sql.legacy.rewriter.parent.SQLExprParentSetterRule;
import org.opensearch.sql.legacy.rewriter.subquery.SubQueryRewriteRule;
import org.opensearch.sql.legacy.utils.StringUtils;
import org.opensearch.sql.legacy.utils.Util;

public class OpenSearchActionFactory {
    public static QueryAction create(Client client, String sql) throws SqlParseException, SQLFeatureNotSupportedException, SQLFeatureDisabledException {
        return OpenSearchActionFactory.create(client, new QueryActionRequest(sql, new ColumnTypeProvider(), Format.JSON));
    }

    public static QueryAction create(Client client, QueryActionRequest request) throws SqlParseException, SQLFeatureNotSupportedException, SQLFeatureDisabledException {
        String sql = request.getSql();
        if ((sql = sql.replaceAll("\\R", " ").trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        switch (OpenSearchActionFactory.getFirstWord(sql)) {
            case "SELECT": {
                SQLExpr rawExpr = Util.toSqlExpr(sql);
                if (!(rawExpr instanceof SQLQueryExpr)) {
                    throw new SqlParseException("Expected a query expression, but found a " + rawExpr.getClass().getSimpleName() + ". The query is not runnable.");
                }
                SQLQueryExpr sqlExpr = (SQLQueryExpr)rawExpr;
                RewriteRuleExecutor<SQLQueryExpr> ruleExecutor = RewriteRuleExecutor.builder().withRule(new SQLExprParentSetterRule()).withRule(new OrdinalRewriterRule(sql)).withRule(new UnquoteIdentifierRule()).withRule(new TableAliasPrefixRemoveRule()).withRule(new SubQueryRewriteRule()).build();
                ruleExecutor.executeOn(sqlExpr);
                sqlExpr.accept((SQLASTVisitor)new NestedFieldRewriter());
                if (OpenSearchActionFactory.isMulti(sqlExpr)) {
                    sqlExpr.accept((SQLASTVisitor)new TermFieldRewriter(TermFieldRewriter.TermRewriterFilter.MULTI_QUERY));
                    MultiQuerySelect multiSelect = new SqlParser().parseMultiSelect((SQLUnionQuery)sqlExpr.getSubQuery().getQuery());
                    return new MultiQueryAction(client, multiSelect);
                }
                if (OpenSearchActionFactory.isJoin(sqlExpr, sql)) {
                    new JoinRewriteRule(LocalClusterState.state()).rewrite(sqlExpr);
                    sqlExpr.accept((SQLASTVisitor)new TermFieldRewriter(TermFieldRewriter.TermRewriterFilter.JOIN));
                    JoinSelect joinSelect = new SqlParser().parseJoinSelect(sqlExpr);
                    return OpenSearchJoinQueryActionFactory.createJoinAction(client, joinSelect);
                }
                sqlExpr.accept((SQLASTVisitor)new TermFieldRewriter());
                if (OpenSearchActionFactory.shouldMigrateToQueryPlan(sqlExpr, request.getFormat())) {
                    return new QueryPlanQueryAction(new QueryPlanRequestBuilder(new BindingTupleQueryPlanner(client, sqlExpr, request.getTypeProvider())));
                }
                Select select = new SqlParser().parseSelect(sqlExpr);
                return OpenSearchActionFactory.handleSelect(client, select);
            }
            case "DELETE": {
                if (OpenSearchActionFactory.isSQLDeleteEnabled()) {
                    SQLStatementParser parser = OpenSearchActionFactory.createSqlStatementParser(sql);
                    SQLDeleteStatement deleteStatement = parser.parseDeleteStatement();
                    Delete delete = new SqlParser().parseDelete(deleteStatement);
                    return new DeleteQueryAction(client, delete);
                }
                throw new SQLFeatureDisabledException(StringUtils.format("DELETE clause is disabled by default and will be deprecated. Using the %s setting to enable it", Settings.Key.SQL_DELETE_ENABLED.getKeyValue()));
            }
            case "SHOW": {
                IndexStatement showStatement = new IndexStatement(IndexStatement.StatementType.SHOW, sql);
                return new ShowQueryAction(client, showStatement);
            }
            case "DESCRIBE": {
                IndexStatement describeStatement = new IndexStatement(IndexStatement.StatementType.DESCRIBE, sql);
                return new DescribeQueryAction(client, describeStatement);
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("Query must start with SELECT, DELETE, SHOW or DESCRIBE: %s", sql));
    }

    private static boolean isSQLDeleteEnabled() {
        return (Boolean)LocalClusterState.state().getSettingValue(Settings.Key.SQL_DELETE_ENABLED);
    }

    private static String getFirstWord(String sql) {
        int endOfFirstWord = sql.indexOf(32);
        return sql.substring(0, endOfFirstWord > 0 ? endOfFirstWord : sql.length()).toUpperCase();
    }

    private static boolean isMulti(SQLQueryExpr sqlExpr) {
        return sqlExpr.getSubQuery().getQuery() instanceof SQLUnionQuery;
    }

    private static void executeAndFillSubQuery(Client client, SubQueryExpression subQueryExpression, QueryAction queryAction) throws SqlParseException {
        Object queryResult;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            queryResult = QueryActionElasticExecutor.executeAnyAction(client, queryAction);
        }
        catch (Exception e) {
            throw new SqlParseException("could not execute SubQuery: " + e.getMessage());
        }
        String returnField = subQueryExpression.getReturnField();
        if (queryResult instanceof SearchHits) {
            SearchHits hits = (SearchHits)queryResult;
            for (SearchHit hit : hits) {
                values.add(ElasticResultHandler.getFieldValue(hit, returnField));
            }
        } else {
            throw new SqlParseException("on sub queries only support queries that return Hits and not aggregations");
        }
        subQueryExpression.setValues(values.toArray());
    }

    private static QueryAction handleSelect(Client client, Select select) {
        if (select.isAggregate) {
            return new AggregationQueryAction(client, select);
        }
        return new DefaultQueryAction(client, select);
    }

    private static SQLStatementParser createSqlStatementParser(String sql) {
        ElasticLexer lexer = new ElasticLexer(sql);
        lexer.nextToken();
        return new MySqlStatementParser((Lexer)lexer);
    }

    private static boolean isJoin(SQLQueryExpr sqlExpr, String sql) {
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)sqlExpr.getSubQuery().getQuery();
        return query.getFrom() instanceof SQLJoinTableSource && ((SQLJoinTableSource)query.getFrom()).getJoinType() != SQLJoinTableSource.JoinType.COMMA;
    }

    @VisibleForTesting
    public static boolean shouldMigrateToQueryPlan(SQLQueryExpr expr, Format format) {
        if (format == Format.JSON) {
            return false;
        }
        QueryPlannerScopeDecider decider = new QueryPlannerScopeDecider();
        return decider.isInScope(expr);
    }

    private static class QueryPlannerScopeDecider
    extends MySqlASTVisitorAdapter {
        private boolean hasAggregationFunc = false;
        private boolean hasNestedFunction = false;
        private boolean hasGroupBy = false;
        private boolean hasAllColumnExpr = false;

        private QueryPlannerScopeDecider() {
        }

        public boolean isInScope(SQLQueryExpr expr) {
            expr.accept((SQLASTVisitor)this);
            return !this.hasAllColumnExpr && !this.hasNestedFunction && (this.hasGroupBy || this.hasAggregationFunc);
        }

        public boolean visit(SQLSelectItem expr) {
            if (expr.getExpr() instanceof SQLAllColumnExpr) {
                this.hasAllColumnExpr = true;
            }
            return super.visit(expr);
        }

        public boolean visit(SQLSelectGroupByClause expr) {
            this.hasGroupBy = true;
            return super.visit(expr);
        }

        public boolean visit(SQLAggregateExpr expr) {
            this.hasAggregationFunc = true;
            return super.visit(expr);
        }

        public boolean visit(SQLMethodInvokeExpr expr) {
            if (expr.getMethodName().equalsIgnoreCase("nested")) {
                this.hasNestedFunction = true;
            }
            return super.visit(expr);
        }
    }
}

