/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.value;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.common.time.FormatNames;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchBinaryType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDateType;
import org.opensearch.sql.opensearch.data.type.OpenSearchIpType;
import org.opensearch.sql.opensearch.data.utils.Content;
import org.opensearch.sql.opensearch.data.utils.ObjectContent;
import org.opensearch.sql.opensearch.data.utils.OpenSearchJsonContent;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprBinaryValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprGeoPointValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprIpValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprTextValue;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.utils.DateTimeFormatters;
import org.opensearch.sql.utils.DateTimeUtils;

public class OpenSearchExprValueFactory {
    private final Map<String, OpenSearchDataType> typeMapping;
    private final boolean fieldTypeTolerance;
    private OpenSearchAggregationResponseParser parser;
    private static final String TOP_PATH = "";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Map<ExprType, BiFunction<Content, ExprType, ExprValue>> typeActionMap = new ImmutableMap.Builder().put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Integer), (c, dt) -> new ExprIntegerValue((Number)c.intValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Long), (c, dt) -> new ExprLongValue((Number)c.longValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Short), (c, dt) -> new ExprShortValue((Number)c.shortValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Byte), (c, dt) -> new ExprByteValue((Number)c.byteValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Float), (c, dt) -> new ExprFloatValue((Number)c.floatValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Double), (c, dt) -> new ExprDoubleValue((Number)c.doubleValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Text), (c, dt) -> new OpenSearchExprTextValue(c.stringValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Keyword), (c, dt) -> new ExprStringValue(c.stringValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Boolean), (c, dt) -> ExprBooleanValue.of((Boolean)c.booleanValue())).put((Object)OpenSearchDateType.of(ExprCoreType.TIME), OpenSearchExprValueFactory::createOpenSearchDateType).put((Object)OpenSearchDateType.of(ExprCoreType.DATE), OpenSearchExprValueFactory::createOpenSearchDateType).put((Object)OpenSearchDateType.of(ExprCoreType.TIMESTAMP), OpenSearchExprValueFactory::createOpenSearchDateType).put((Object)OpenSearchDateType.of(ExprCoreType.DATETIME), OpenSearchExprValueFactory::createOpenSearchDateType).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Ip), (c, dt) -> new OpenSearchExprIpValue(c.stringValue())).put((Object)OpenSearchDataType.of(OpenSearchDataType.MappingType.Binary), (c, dt) -> new OpenSearchExprBinaryValue(c.stringValue())).build();

    public void extendTypeMapping(Map<String, OpenSearchDataType> typeMapping) {
        for (String field : typeMapping.keySet()) {
            if (this.typeMapping.containsKey(field)) continue;
            this.typeMapping.put(field, typeMapping.get(field));
        }
    }

    public OpenSearchExprValueFactory(Map<String, OpenSearchDataType> typeMapping, boolean fieldTypeTolerance) {
        this.typeMapping = OpenSearchDataType.traverseAndFlatten(typeMapping);
        this.fieldTypeTolerance = fieldTypeTolerance;
    }

    public ExprValue construct(String jsonString, boolean supportArrays) {
        try {
            return this.parse(new OpenSearchJsonContent(OBJECT_MAPPER.readTree(jsonString)), TOP_PATH, Optional.of(ExprCoreType.STRUCT), this.fieldTypeTolerance || supportArrays);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(String.format("invalid json: %s.", jsonString), e);
        }
    }

    public ExprValue construct(String field, Object value, boolean supportArrays) {
        return this.parse(new ObjectContent(value), field, this.type(field), supportArrays);
    }

    private ExprValue parse(Content content, String field, Optional<ExprType> fieldType, boolean supportArrays) {
        if (content.isNull() || !fieldType.isPresent()) {
            return ExprNullValue.of();
        }
        ExprType type = fieldType.get();
        if (type.equals(OpenSearchDataType.of(OpenSearchDataType.MappingType.GeoPoint))) {
            return this.parseGeoPoint(content, supportArrays);
        }
        if (type.equals(OpenSearchDataType.of(OpenSearchDataType.MappingType.Nested)) || content.isArray()) {
            return this.parseArray(content, field, type, supportArrays);
        }
        if (type.equals(OpenSearchDataType.of(OpenSearchDataType.MappingType.Object)) || type == ExprCoreType.STRUCT) {
            return this.parseStruct(content, field, supportArrays);
        }
        if (typeActionMap.containsKey(type)) {
            return typeActionMap.get(type).apply(content, type);
        }
        throw new IllegalStateException(String.format("Unsupported type: %s for value: %s.", type.typeName(), content.objectValue()));
    }

    private Optional<ExprType> type(String field) {
        return Optional.ofNullable((ExprType)this.typeMapping.get(field));
    }

    private static ExprValue parseDateTimeString(String value, OpenSearchDateType dataType) {
        List<DateFormatter> formatters = dataType.getAllNamedFormatters();
        formatters.addAll(dataType.getAllCustomFormatters());
        ExprCoreType returnFormat = dataType.getExprCoreType();
        for (DateFormatter formatter : formatters) {
            try {
                TemporalAccessor accessor = formatter.parse(value);
                ZonedDateTime zonedDateTime = DateFormatters.from((TemporalAccessor)accessor);
                switch (returnFormat) {
                    case TIME: {
                        return new ExprTimeValue(zonedDateTime.withZoneSameLocal(DateTimeUtils.UTC_ZONE_ID).toLocalTime());
                    }
                    case DATE: {
                        return new ExprDateValue(zonedDateTime.withZoneSameLocal(DateTimeUtils.UTC_ZONE_ID).toLocalDate());
                    }
                }
                return new ExprTimestampValue(zonedDateTime.withZoneSameLocal(DateTimeUtils.UTC_ZONE_ID).toInstant());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        try {
            switch (returnFormat) {
                case TIME: {
                    return new ExprTimeValue(DateFormatters.from((TemporalAccessor)DateTimeFormatters.STRICT_HOUR_MINUTE_SECOND_FORMATTER.parse(value)).toLocalTime());
                }
                case DATE: {
                    return new ExprDateValue(DateFormatters.from((TemporalAccessor)DateTimeFormatters.STRICT_YEAR_MONTH_DAY_FORMATTER.parse(value)).toLocalDate());
                }
            }
            return new ExprTimestampValue(DateFormatters.from((TemporalAccessor)DateTimeFormatters.DATE_TIME_FORMATTER.parse(value)).toInstant());
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new IllegalArgumentException(String.format("Construct %s from \"%s\" failed, unsupported format.", returnFormat, value));
        }
    }

    private static ExprValue createOpenSearchDateType(Content value, ExprType type) {
        OpenSearchDateType dt = (OpenSearchDateType)type;
        ExprCoreType returnFormat = dt.getExprCoreType();
        if (value.isNumber()) {
            List<DateFormatter> numFormatters = dt.getNumericNamedFormatters();
            if (numFormatters.size() > 0 || !dt.hasFormats()) {
                long epochMillis = 0L;
                epochMillis = numFormatters.contains(DateFormatter.forPattern((String)FormatNames.EPOCH_SECOND.getSnakeCaseName())) ? value.longValue() * 1000L : value.longValue();
                Instant instant = Instant.ofEpochMilli(epochMillis);
                switch (returnFormat) {
                    case TIME: {
                        return new ExprTimeValue(LocalTime.from(instant.atZone(DateTimeUtils.UTC_ZONE_ID)));
                    }
                    case DATE: {
                        return new ExprDateValue(LocalDate.ofInstant(instant, DateTimeUtils.UTC_ZONE_ID));
                    }
                }
                return new ExprTimestampValue(instant);
            }
            return OpenSearchExprValueFactory.parseDateTimeString(value.objectValue().toString(), dt);
        }
        if (value.isString()) {
            return OpenSearchExprValueFactory.parseDateTimeString(value.stringValue(), dt);
        }
        return new ExprTimestampValue((Instant)value.objectValue());
    }

    private ExprValue parseStruct(Content content, String prefix, boolean supportArrays) {
        LinkedHashMap result = new LinkedHashMap();
        content.map().forEachRemaining(entry -> result.put((String)entry.getKey(), this.parse((Content)entry.getValue(), this.makeField(prefix, (String)entry.getKey()), this.type(this.makeField(prefix, (String)entry.getKey())), supportArrays)));
        return new ExprTupleValue(result);
    }

    private ExprValue parseArray(Content content, String prefix, ExprType type, boolean supportArrays) {
        ArrayList<ExprValue> result = new ArrayList<ExprValue>();
        if (content.objectValue() instanceof ObjectNode) {
            result.add(this.parseStruct(content, prefix, supportArrays));
        } else {
            if (!(type instanceof OpenSearchDataType && ((OpenSearchDataType)type).getExprType().equals(ExprCoreType.ARRAY) || supportArrays)) {
                return this.parseInnerArrayValue(content.array().next(), prefix, type, supportArrays);
            }
            content.array().forEachRemaining(v -> result.add(this.parseInnerArrayValue((Content)v, prefix, type, supportArrays)));
        }
        return new ExprCollectionValue(result);
    }

    private ExprValue parseGeoPoint(Content content, boolean supportArrays) {
        if (!content.isArray()) {
            Pair<Double, Double> pair = content.geoValue();
            return new OpenSearchExprGeoPointValue((Double)pair.getLeft(), (Double)pair.getRight());
        }
        Iterator<? extends Content> elements = content.array();
        Content first = elements.next();
        if (first.isNumber()) {
            double lon = first.doubleValue();
            Content second = elements.next();
            if (!second.isNumber()) {
                throw new OpenSearchParseException("lat must be a number, got " + String.valueOf(second.objectValue()), new Object[0]);
            }
            return new OpenSearchExprGeoPointValue(second.doubleValue(), lon);
        }
        Pair<Double, Double> pair = first.geoValue();
        OpenSearchExprGeoPointValue firstPoint = new OpenSearchExprGeoPointValue((Double)pair.getLeft(), (Double)pair.getRight());
        if (supportArrays) {
            ArrayList<OpenSearchExprGeoPointValue> result = new ArrayList<OpenSearchExprGeoPointValue>();
            result.add(firstPoint);
            elements.forEachRemaining(e -> {
                Pair<Double, Double> p = e.geoValue();
                result.add(new OpenSearchExprGeoPointValue((Double)p.getLeft(), (Double)p.getRight()));
            });
            return new ExprCollectionValue(result);
        }
        return firstPoint;
    }

    private ExprValue parseInnerArrayValue(Content content, String prefix, ExprType type, boolean supportArrays) {
        if (type instanceof OpenSearchIpType || type instanceof OpenSearchBinaryType || type instanceof OpenSearchDateType) {
            return this.parse(content, prefix, Optional.of(type), supportArrays);
        }
        if (content.isString()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of((ExprType)ExprCoreType.STRING)), supportArrays);
        }
        if (content.isLong()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of((ExprType)ExprCoreType.LONG)), supportArrays);
        }
        if (content.isFloat()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of((ExprType)ExprCoreType.FLOAT)), supportArrays);
        }
        if (content.isDouble()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of((ExprType)ExprCoreType.DOUBLE)), supportArrays);
        }
        if (content.isNumber()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of((ExprType)ExprCoreType.INTEGER)), supportArrays);
        }
        if (content.isBoolean()) {
            return this.parse(content, prefix, Optional.of(OpenSearchDataType.of((ExprType)ExprCoreType.BOOLEAN)), supportArrays);
        }
        return this.parse(content, prefix, Optional.of(ExprCoreType.STRUCT), supportArrays);
    }

    private String makeField(String path, String field) {
        return path.equalsIgnoreCase(TOP_PATH) ? field : String.join((CharSequence)".", path, field);
    }

    @Generated
    public OpenSearchAggregationResponseParser getParser() {
        return this.parser;
    }

    @Generated
    public void setParser(OpenSearchAggregationResponseParser parser) {
        this.parser = parser;
    }
}

