/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.nio.ssl;

import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.opensearch.OpenSearchSecurityException;

public class SslUtils {
    private static final String[] DEFAULT_SSL_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1"};

    private SslUtils() {
    }

    public static SSLEngine createDefaultServerSSLEngine() {
        try {
            SSLEngine engine = SSLContext.getDefault().createSSLEngine();
            engine.setEnabledProtocols(DEFAULT_SSL_PROTOCOLS);
            engine.setUseClientMode(false);
            return engine;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new OpenSearchSecurityException("Unable to initialize default server SSL engine", (Exception)ex, new Object[0]);
        }
    }

    public static SSLEngine createDefaultClientSSLEngine() {
        try {
            SSLEngine engine = SSLContext.getDefault().createSSLEngine();
            engine.setEnabledProtocols(DEFAULT_SSL_PROTOCOLS);
            engine.setUseClientMode(true);
            return engine;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new OpenSearchSecurityException("Unable to initialize default client SSL engine", (Exception)ex, new Object[0]);
        }
    }
}

