#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-KGPBLci5WqNEmpN1ybPZ6n
key:                  postgrest-10.0.0-KGPBLci5WqNEmpN1ybPZ6n
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  19cf9d681af88509033e2a3c286c2159
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-KGPBLci5WqNEmpN1ybPZ6n
depends:
    HTTP-4000.4.1-4X0iYpdvMvfHpXuBcZhrsF
    Ranged-sets-0.4.0-Ihgt3gwNu1NAk2wki9E21J
    aeson-2.1.2.1-8pX4IwvbwpcwXiIiReOQk
    auto-update-0.1.6-2fXVoLOsUf6BJ2znLdlsIo base-4.17.2.1
    base64-bytestring-1.2.1.0-JXBkDm4ttKKHxHDfgEAUvp
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4CWBjbNVYtn1DyQhk43ZQ9
    cassava-0.5.3.2-C9C1AlKduhdJfw2yg2pSYr
    configurator-pg-0.2.9-JFWxsueUxLMFow39ehIwgM containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-DGiD7fHpusZFAepsosu6Un
    gitrev-1.3.1-H2G7FNkm0RTIvLJOJ6VmrQ
    hasql-1.5.0.4-5K2OmqV8JiVEYM8A0fIMTC
    hasql-dynamic-statements-0.3.1.1-C7p2pb28EpFBP6aVUytEj6
    hasql-notifications-0.2.0.4-6MxbeGJtSCz7O5EKzckFxg
    hasql-pool-0.5.2.2-C7iObxJ2Sg0J02RP2i3qvZ
    hasql-transaction-1.0.1.1-FnD6UZghtO46d62pVFxFYH
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-7BozLfTXeEWGYT0EKpPSnr
    insert-ordered-containers-0.2.5.3-9CrmTLzr4Dd92CP4S2n6N
    interpolatedstring-perl6-1.0.2-D9nglKkID3wGOpaGhASIP3
    jose-0.10-GpJDWbg5N8xI8ObptJCnhU lens-5.2.3-ECHdyiBhGt3AEK5VHs81a3
    lens-aeson-1.2.3-4EyH0ANHI089tUAAdmVrIQ mtl-2.2.2
    network-3.1.4.0-ExLckjbUqaB9dQ68XDq8jI
    network-uri-2.6.4.2-FySjo3JLI85BEi0FUQGaO
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parsec-3.1.16.1 protolude-0.3.4-4u9ijFfTbhdAFUizgCGGgc
    regex-tdfa-1.3.2.2-D95SuRi2xoOHQuT5KVAOCg
    retry-0.9.3.1-IiAphxUSn4vFDrawM2PosP
    scientific-0.3.7.0-D2shAS6j7tCClWMfBXaB6J
    swagger2-2.8.9-7aQ5ClOd6m8CFmh96MI0p0 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-8U9CBLajvKUXcrLJVqNaj
    vault-0.3.1.5-6p4dZQAAgcVExMNDGe8aL4
    vector-0.13.1.0-3m7HMvWbOJNDnUiYgFdHrI
    wai-3.2.4-KXaRlag2H8u14yPy2nJnqM
    wai-cors-0.2.7-2AhW9Dor6fq6yrXefuEkhJ
    wai-extra-3.1.15-Q65XhisThLHHUf6JXHACt
    wai-logger-2.5.0-BN6CiObAggjJBOlbJqVrsf
    warp-3.3.30-Dl0dGRDWV133XOwu4MlsFM

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

