#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-C7kM6zAHDKU8BeomUBSHeR
key:                  postgrest-10.0.0-C7kM6zAHDKU8BeomUBSHeR
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  9b9bc762f7ded884edffd9effcbf4ad8
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-C7kM6zAHDKU8BeomUBSHeR
depends:
    HTTP-4000.4.1-2ouX606MORK6qAEuwzWm6C
    Ranged-sets-0.4.0-Gu3BEGqFC7iIsb9is6FqB0
    aeson-2.1.2.1-HgTvGelKFeMCs4MoB4HQQ3
    auto-update-0.1.6-JieGKtau1agIwYwJbPzwoO base-4.17.2.1
    base64-bytestring-1.2.1.0-4fqTDsScuuX4b4re0JajdK
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-AtT9PetKXQ46vh6orGagap
    cassava-0.5.3.2-C2gMEhnlEQHJL03wfJ5NM6
    configurator-pg-0.2.9-I3oYZWUtD501xQ7wwJ2U8r containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-9oxJ0RL4QyWJZ2hRIvlmbO
    gitrev-1.3.1-H2G7FNkm0RTIvLJOJ6VmrQ
    hasql-1.5.0.4-2kuCqdQXWICWXdSw5OTlm
    hasql-dynamic-statements-0.3.1.1-DWKHiKrReT83r9ukkUb0dO
    hasql-notifications-0.2.0.4-ArTRzVusTjiHGfocWgI7de
    hasql-pool-0.5.2.2-IHKBh7E7YjCLkLqsxfOfsg
    hasql-transaction-1.0.1.1-1lU8ejpJn4eHd3UTXj364Y
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-cGP4COhpCbDmQiO5iBXAE
    insert-ordered-containers-0.2.5.3-Afk5M7TBmdFAIucHvFjdLl
    interpolatedstring-perl6-1.0.2-8Wq01igw0DfI3TZTsm9cA4
    jose-0.10-I2je4l3SxrjInwYUdB6Lsp lens-5.2.3-I3BlAHfqsGAEvCz93DUGGV
    lens-aeson-1.2.3-GOpJefQVMHsI8AQLt97zKd mtl-2.2.2
    network-3.1.4.0-HsnWpJCBJSkHDu8PyPRvYR
    network-uri-2.6.4.2-A65zHnygYht3ea081U7fDv
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parsec-3.1.16.1 protolude-0.3.4-1Ydy4wGVZlqGJE8aNsd8MW
    regex-tdfa-1.3.2.2-Lx2wVcETmehVQz7NWfugc
    retry-0.9.3.1-CgN7pZ7I6dnDH7S8qvtitV
    scientific-0.3.7.0-Jh9tJE2sLMpFL2bSsP8DMA
    swagger2-2.8.9-4zkkbqwUiBFBoyTZmjKndP text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    vault-0.3.1.5-J8aog0d1AinGM1oiewxgNt
    vector-0.13.1.0-DP5vqiFKsIZ25TyoutQAjD
    wai-3.2.4-GUoXUoY24VCBryLqTBaLdB
    wai-cors-0.2.7-CGE1rSDkVeD2tcBkTjwb3r
    wai-extra-3.1.15-8tjZLPgxNd9L0t5wVWsdiH
    wai-logger-2.5.0-2FVdqasH6MlCtguzxET3G1
    warp-3.3.30-BGR5Wbz9ZcR2jBwEhCRmIG

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

