#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-1ROfS4onStzEqPGFC9RzY5
key:                  postgrest-10.0.0-1ROfS4onStzEqPGFC9RzY5
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  8bdcfd5851dd0726c50eaa4de80471a0
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-1ROfS4onStzEqPGFC9RzY5
depends:
    HTTP-4000.4.1-Ihf8Kajf6HkBLD4h53LXw4
    Ranged-sets-0.4.0-Gu3BEGqFC7iIsb9is6FqB0
    aeson-2.1.2.1-Kzzie09M6AYFH8VDx0mx86
    auto-update-0.1.6-JieGKtau1agIwYwJbPzwoO base-4.17.2.1
    base64-bytestring-1.2.1.0-4fqTDsScuuX4b4re0JajdK
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-AtT9PetKXQ46vh6orGagap
    cassava-0.5.3.2-DFrCUVuqbOkG6iHhe49yMt
    configurator-pg-0.2.9-I3oYZWUtD501xQ7wwJ2U8r containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-9550az1aJXYCamgHJfPTw3
    gitrev-1.3.1-H2G7FNkm0RTIvLJOJ6VmrQ
    hasql-1.5.0.4-1ILxWqEVabGEsBh1l6FL0Y
    hasql-dynamic-statements-0.3.1.1-Jbrsb4F4oJ718I4Axo4QyO
    hasql-notifications-0.2.0.4-65FQDdxJmx8KkPTbFPxJI9
    hasql-pool-0.5.2.2-E1I9m2Pn1atLJdZV3l9z8e
    hasql-transaction-1.0.1.1-KavJRBeWCNaIV72Z9y1aY6
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-D2DAVTmHvcDBQ0h7IvaEn9
    insert-ordered-containers-0.2.5.3-2h4Kgz8ldoB5da8YtSLPZF
    interpolatedstring-perl6-1.0.2-8Wq01igw0DfI3TZTsm9cA4
    jose-0.10-A55gpeVYLTkDNSe8gGHSsC lens-5.2.3-JlyZXwZS00NBv5ScwlVipn
    lens-aeson-1.2.3-4yI2R6VnFSF6DjVj21qL7C mtl-2.2.2
    network-3.1.4.0-HsnWpJCBJSkHDu8PyPRvYR
    network-uri-2.6.4.2-A65zHnygYht3ea081U7fDv
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parsec-3.1.16.1 protolude-0.3.4-1Ydy4wGVZlqGJE8aNsd8MW
    regex-tdfa-1.3.2.2-Lx2wVcETmehVQz7NWfugc
    retry-0.9.3.1-CgN7pZ7I6dnDH7S8qvtitV
    scientific-0.3.7.0-Jh9tJE2sLMpFL2bSsP8DMA
    swagger2-2.8.9-Kh6vQ2kYNatHIac6Caya3q text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    vault-0.3.1.5-J8aog0d1AinGM1oiewxgNt
    vector-0.13.1.0-DP5vqiFKsIZ25TyoutQAjD
    wai-3.2.4-8wgjzYdHzERLEzwoQEllrh
    wai-cors-0.2.7-4PwDXcUSEuY2rseTWDWJoc
    wai-extra-3.1.15-7yoWhADQOc5GZynrbLZpws
    wai-logger-2.5.0-8vG8c4jRKPZ2adJXe5nww2
    warp-3.3.30-15r15uPEVSRCpfRnQ2XK8J

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

