#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-6XPsByfS9x1zSdbmdsmKz
key:                  postgrest-10.0.0-6XPsByfS9x1zSdbmdsmKz
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  53fce0db7d4d49004a715b16b3bb6d3f
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-6XPsByfS9x1zSdbmdsmKz
depends:
    HTTP-4000.4.1-KVfQMtbYF6f55XKTj3j4d3
    Ranged-sets-0.4.0-GyUpDcs3N6p7qUyHBmseM6
    aeson-2.1.2.1-3xjz2RyG2JVHhJgBzFxi7A
    auto-update-0.1.6-EOLb1ANaASJByEN3pUlUBf base-4.17.2.1
    base64-bytestring-1.2.1.0-9rjbyifcAWs81fTufDCHjJ
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-GbIPZPr2YUt5gu3TjAsadi
    cassava-0.5.3.2-4if38KQLdfpKUZhCbBCJdB
    configurator-pg-0.2.9-HFXExPBeygkDZalLdUGBnX containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-1qrh2ytujkN7dXMvPhu67j
    gitrev-1.3.1-H2G7FNkm0RTIvLJOJ6VmrQ
    hasql-1.5.0.4-FKEtFK2TqJZAG9Q6jKnb25
    hasql-dynamic-statements-0.3.1.1-cNvaZO19sY7uLdzxltS3c
    hasql-notifications-0.2.0.4-KYEimgpfYkcCyVaXUX4g8H
    hasql-pool-0.5.2.2-9pbRTsMJd7ss3tvicN60k
    hasql-transaction-1.0.1.1-5MEArf1XT4g1uwF18zXP0R
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-GwcjbD6je3aL0GKpFarP8k
    insert-ordered-containers-0.2.5.3-6DT7DaEyqos1fgK425c2kf
    interpolatedstring-perl6-1.0.2-AU3AWUy2kTKEdfbjlSdsrN
    jose-0.10-8bh4odgVtA8LQ5uHhM0AoE lens-5.2.3-9tvnz3pLdcPH5JzlkQxTXA
    lens-aeson-1.2.3-GWcMF35OfnfKTdugvKpoWH mtl-2.2.2
    network-3.1.4.0-4LxzNodBXIzL8bUGme1k8m
    network-uri-2.6.4.2-2U8duEjYT0p2SuyLAFgLE2
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parsec-3.1.16.1 protolude-0.3.4-JjYkXiGZeuGGrRQrg7xNSC
    regex-tdfa-1.3.2.2-LivcOdtZX8FLXw70uGvuNe
    retry-0.9.3.1-8n1PJy4g5olSjsVVPwqge
    scientific-0.3.7.0-LKd2L2qVPICBdMYOyCcex4
    swagger2-2.8.9-32FiETsCjn2KUOKkQMPBBm text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-4cFR6FXPxn69oePlCyMUKW
    vault-0.3.1.5-3q6mqIrjfj474YbXFidFVf
    vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX
    wai-3.2.4-E2qRrDkmNMh7x5fpA0TmD6
    wai-cors-0.2.7-DCKPQ394PkzEZw49GK5ksm
    wai-extra-3.1.15-KsYJmZVSEkS29jNlMUexWP
    wai-logger-2.5.0-Jsjoak0gfbhC7SiXrQEjEC
    warp-3.3.30-L1ctWyNaALU8oLcnPk9wEY

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

