#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-1KTNXmgeGMv337DOz45at6
key:                  postgrest-10.0.0-1KTNXmgeGMv337DOz45at6
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  d51295da1d26a593cad18deed8691926
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-1KTNXmgeGMv337DOz45at6
depends:
    HTTP-4000.4.1-J6Frvix7vMZ2AZ2hWfcan2
    Ranged-sets-0.4.0-GyUpDcs3N6p7qUyHBmseM6
    aeson-2.1.2.1-25ntyCXNIMdHgIjcbgcdOM
    auto-update-0.1.6-JuwzBKpoGZNFHxTEb0Z7WK base-4.17.2.1
    base64-bytestring-1.2.1.0-9rjbyifcAWs81fTufDCHjJ
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-GbIPZPr2YUt5gu3TjAsadi
    cassava-0.5.3.2-GBWiwl9tt5e3TT3fh1pBGf
    configurator-pg-0.2.9-HFXExPBeygkDZalLdUGBnX containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-6aNHGy4tQhtHx1RN95SwYf
    gitrev-1.3.1-H2G7FNkm0RTIvLJOJ6VmrQ
    hasql-1.5.0.4-5S1GejKL5LdGvdjdAgmXIX
    hasql-dynamic-statements-0.3.1.1-LAzhZCMA9KFHqCY0vYIcI8
    hasql-notifications-0.2.0.4-9dQ8tmGZSRDHR1hBJsTDC6
    hasql-pool-0.5.2.2-LMChIobCSuz4BBbac1LB4i
    hasql-transaction-1.0.1.1-JMG4JYK4g10CuZ3dDgjrW8
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-84PTldXFVlSHvwiFY4h2Wj
    insert-ordered-containers-0.2.5.3-1VjJzQNVdyg1tfW0q3ZNjE
    interpolatedstring-perl6-1.0.2-AU3AWUy2kTKEdfbjlSdsrN
    jose-0.10-8gutJVx21lJFi2MvdMq5tt lens-5.2.3-9B9P7XM4qGB6Xd7Di9aRFA
    lens-aeson-1.2.3-1lTKci8Zbtx83P0a0xfX7P mtl-2.2.2
    network-3.1.4.0-4LxzNodBXIzL8bUGme1k8m
    network-uri-2.6.4.2-2U8duEjYT0p2SuyLAFgLE2
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parsec-3.1.16.1 protolude-0.3.4-JjYkXiGZeuGGrRQrg7xNSC
    regex-tdfa-1.3.2.2-LOCZw2rru5CARfqoQF4uzE
    retry-0.9.3.1-5jbBx1Cee3C7aqDlijPUno
    scientific-0.3.7.0-LKd2L2qVPICBdMYOyCcex4
    swagger2-2.8.9-1w4llRaN1RtCAjBhtX4MBE text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-2oScjwZejU42oDENjBi2vG
    vault-0.3.1.5-G2HaUpHmWt97UYQ6YQOO3p
    vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX
    wai-3.2.4-EQmFL7xABCGF5LTxYaF04l
    wai-cors-0.2.7-HXEkpb2dEYIA4CKCfMtOR2
    wai-extra-3.1.15-41dDaWlg83MTU2NmqfRAb
    wai-logger-2.5.0-2jT91xZOIhG9AQGkOAm7tS
    warp-3.3.30-InrHVAHvwNM9xTnQ2Vn2RB

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

