#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-7QkdsHItnUfAG5LTEBksOk
key:                  postgrest-10.0.0-7QkdsHItnUfAG5LTEBksOk
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  c6a59fbef86d318d8ccfd957e89ad0a1
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-7QkdsHItnUfAG5LTEBksOk
depends:
    HTTP-4000.4.1-8TB7pwxSBpK2yl7sQHuu5L
    Ranged-sets-0.4.0-H4pMI6sYBOJBxLVYshIiw7
    aeson-2.1.2.1-LpT6Mf0v1IAHC9jBcKu3TC
    auto-update-0.1.6-1lOVSbLNGxnLZ9UaTRlWtc base-4.17.2.1
    base64-bytestring-1.2.1.0-4q5KLdrxF6BHAwlK9Y3XXj
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-BBd0FN3VG9pHwba5nfbZ8v
    cassava-0.5.3.2-9YdPkA9Zvnu4MTXu1i9Ss5
    configurator-pg-0.2.9-89AHk4q0WSnBpUGmBhJajP containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-1FLUGibzyADGigtNoiMtU
    gitrev-1.3.1-H2G7FNkm0RTIvLJOJ6VmrQ
    hasql-1.5.0.4-B93rIGhKuvyFoV5ff2bGt2
    hasql-dynamic-statements-0.3.1.1-3kaAS8nhijLCbsvXVF7eZo
    hasql-notifications-0.2.0.4-8O9nEd3M4wVKYl5nXAj3WU
    hasql-pool-0.5.2.2-4vo3p8Mk3JIYmBLW3Ykvv
    hasql-transaction-1.0.1.1-C1zvjcLRqAyKrAVIScngwq
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-1DZFzfvJVK9AHfgKU8FkY3
    insert-ordered-containers-0.2.5.3-KYtHsboSxvp1jhNzOyrBnu
    interpolatedstring-perl6-1.0.2-ByKR9yqHkXSCauYEPhVESk
    jose-0.10-4TJrEOo4PHULuT8gHA4PDw lens-5.2.3-1xyXEUn2kF27mSgPIa0sOB
    lens-aeson-1.2.3-DkmcD9Ux9E52urdjwzmY4A mtl-2.2.2
    network-3.1.4.0-7d91dIi13MzEkgRQe6YDcO
    network-uri-2.6.4.2-EDr74t9h07L15oCNeDNFfl
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parsec-3.1.16.1 protolude-0.3.4-APRYKiJWvq3ESy2RFIQiqz
    regex-tdfa-1.3.2.2-9m5fW19lHnMJYjjJRSkncP
    retry-0.9.3.1-JYdmDaWXtvm1YOGn2bFJ9v
    scientific-0.3.7.0-BkypiqTAkpN3suN2c81wMx
    swagger2-2.8.9-1wlVD3U7mPK3ocNqWLKjJB text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    vault-0.3.1.5-8H3tTavQv2TDi1YBNlWJrz
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O
    wai-3.2.4-LaZv3Kj0Ed9gV12y2mMCG
    wai-cors-0.2.7-LcnNruth6zoIh4WZcQMk94
    wai-extra-3.1.16-90xPXqg6GEyHJEXMBTCsAt
    wai-logger-2.5.0-IEJ1BDozKwc6Z14LwYmPNh
    warp-3.3.30-B4zO7YdYeQD9KXkHKAxZ1h

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

