#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-AENafIuSF8g1sbKR7XHtoQ
key:                  postgrest-10.0.0-AENafIuSF8g1sbKR7XHtoQ
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  aca373d27b309c42541246c79336cd35
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-AENafIuSF8g1sbKR7XHtoQ
depends:
    HTTP-4000.4.1-4ooukAZOunOKhYzW9i7g1R
    Ranged-sets-0.5.0-KEzGrz71xK95w6vHFVPqWS
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm
    auto-update-0.1.6-J8J06qdEnBo48arlG4qopS base-4.17.2.1
    base64-bytestring-1.2.1.0-AvS7geCgwfzr74cccAlCm bytestring-0.11.5.3
    case-insensitive-1.2.1.0-rTys5srD4l50KQCiQKWYt
    cassava-0.5.4.1-6O7kru283RtIozOzZOk1wc
    configurator-pg-0.2.10-CEwsXyGBUPdKBpMYt9IOVm containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-73MLXCQBVC87HSiWToTBdZ
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-GfbqGOi0yv1ACsS8skVOLS
    hasql-dynamic-statements-0.3.1.1-DFNeqV1tgq3tPkmyFzTGe
    hasql-notifications-0.2.0.5-G0bkYb2lWvyGerqZr6Ij0L
    hasql-pool-0.5.2.2-54WbH9Nj9LxghlXmYdvGV
    hasql-transaction-1.0.1.1-GMxiJe4jjCBsdjziChMD4
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-8KsSLLTB3zVcsjL7f3kez
    insert-ordered-containers-0.2.5.3-KpjV0VIsrAPCpfOCbqY2ip
    interpolatedstring-perl6-1.0.2-GrLOA0dCSro7xZisBw2PgS
    jose-0.10-HVlj8Go6MWa5vtkT31ZPUu lens-5.3.2-Do7BRGZKCykCgu16LW7xBK
    lens-aeson-1.2.3-J5wrAS2jjlfHNDtrPLSptM mtl-2.2.2
    network-3.1.4.0-5tdSDQBC1SF9do6vOgsoy3
    network-uri-2.6.4.2-60V3uLcyBv8HHhnYdb8knn
    optparse-applicative-0.18.1.0-Fys7kMiK5mr3sU6DxR5vVs
    parsec-3.1.16.1 protolude-0.3.5-8s1pM0xA0FP32qOQYBnPWA
    regex-tdfa-1.3.2.4-6Wgi5UAwR4D9inZoGIf9gY
    retry-0.9.3.1-3bUYJDNyvAP6gIXwQbcOxD
    scientific-0.3.8.0-3KgWCwEWnxjIUGX8ssH1BR
    swagger2-2.8.10-Uh8rMy0rPVDZTC4dxjukf text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    vault-0.3.1.5-FlafIjEMT5q6GDikkGAyLI
    vector-0.13.2.0-EQFZws9ZIK8A2ESM3MR23n
    wai-3.2.4-IDOjyIeGcOSAX1FlCquc7y
    wai-cors-0.2.7-2hN9WbD1k966TKuZKjILMS
    wai-extra-3.1.18-8UERkDsigqS8xVFGaK5QEN
    wai-logger-2.5.0-Yggc007xCx1fNvW0q7Oaf
    warp-3.3.31-3VN7dF0c4Q9DjhZFcdhmmp

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

