/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.OutOfProcessRetries;
import com.intellij.RetriesImpl;
import com.intellij.TestCaseLoader;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.idea.IJIgnore;
import com.intellij.idea.IgnoreJUnit3;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.tests.ExternalClasspathClassLoader;
import com.intellij.tests.IgnoreException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.io.Decompressor;
import com.intellij.util.lang.UrlClassLoader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestAdapterCache;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Parameterized;

public class TestAll
implements Test {
    private static final String MAX_FAILURE_TEST_COUNT_FLAG = "idea.max.failure.test.count";
    private static final int MAX_FAILURE_TEST_COUNT;
    private static final Filter PERFORMANCE_ONLY;
    private static final Filter NO_PERFORMANCE;
    private static final Filter NOT_IGNORED;
    private final TestCaseLoader myTestCaseLoader = TestCaseLoader.Builder.fromDefaults().build();
    private int myRunTests = -1;
    private int myIgnoredTests;
    private static final List<Throwable> ourClassLoadingProblems;
    private static JUnit4TestAdapterCache ourUnit4TestAdapterCache;
    private static final String ourCollectTestsFile;

    public TestAll(String rootPackage) throws Throwable {
        this(rootPackage, TestAll.getClassRoots());
    }

    public TestAll(String rootPackage, List<? extends Path> classesRoots) throws ClassNotFoundException {
        if (TestAll.shouldAddFirstAndLastTests()) {
            this.myTestCaseLoader.addFirstTest(Class.forName("_FirstInSuiteTest"));
            this.myTestCaseLoader.addLastTest(Class.forName("_LastInSuiteTest"));
        }
        this.myTestCaseLoader.fillTestCases(rootPackage, classesRoots);
        ourClassLoadingProblems.addAll(this.myTestCaseLoader.getClassLoadingErrors());
    }

    public static List<Throwable> getLoadingClassProblems() {
        return ourClassLoadingProblems;
    }

    public static @Unmodifiable List<Path> getClassRoots() {
        return (List)TeamCityLogger.block("Collecting tests from ...", () -> TestAll.doGetClassRoots());
    }

    private static @Unmodifiable List<Path> doGetClassRoots() {
        String jarsToRunTestsFrom = System.getProperty("jar.dependencies.to.tests");
        if (jarsToRunTestsFrom != null) {
            String[] jars = jarsToRunTestsFrom.split(";");
            List<Path> classpath = Objects.requireNonNull(ExternalClasspathClassLoader.getRoots());
            List<Path> testPaths = Arrays.stream(jars).map(jarName -> {
                List resultJars = ContainerUtil.filter((Collection)classpath, path -> path.getFileName().toString().startsWith((String)jarName));
                if (resultJars.size() != 1) {
                    String classpathPretty = classpath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
                    throw new IllegalStateException((resultJars.isEmpty() ? "Cannot find " : "More than one ") + jarName + " in " + classpathPretty);
                }
                return (Path)resultJars.get(0);
            }).map(Path::normalize).map(jar -> {
                try {
                    if (!Files.exists(jar, new LinkOption[0])) {
                        throw new IllegalStateException(jar + " doesn't exist");
                    }
                    String jarNameWithoutExtension = StringUtil.substringBefore((String)jar.getFileName().toString(), (String)".");
                    Path out = Paths.get(PathManager.getHomePath(), "out", "jar-dependencies-to-test", jarNameWithoutExtension);
                    new Decompressor.Zip(jar).extract(out);
                    return out;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList());
            System.out.println("Collecting tests from roots specified by jar.dependencies.to.tests property: " + testPaths);
            return testPaths;
        }
        String testRoots = System.getProperty("test.roots");
        if (testRoots != null) {
            System.out.println("Collecting tests from roots specified by test.roots property: " + testRoots);
            return ContainerUtil.map((Object[])testRoots.split(";"), x$0 -> Paths.get(x$0, new String[0]));
        }
        List<Path> roots = ExternalClasspathClassLoader.getRoots();
        if (roots != null) {
            List<Path> excludeRoots = ExternalClasspathClassLoader.getExcludeRoots();
            if (excludeRoots != null) {
                System.out.println("Skipping tests from " + excludeRoots.size() + " roots");
                roots = new ArrayList<Path>(roots);
                roots.removeAll(FileCollectionFactory.createCanonicalPathSet(excludeRoots));
            }
            System.out.println("Collecting tests from roots specified by classpath.file property: " + roots);
            return roots;
        }
        ClassLoader loader = TestAll.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            return ContainerUtil.map(TestAll.getClassRoots(((URLClassLoader)loader).getURLs()), url -> Paths.get(url.toUri()));
        }
        if (loader instanceof UrlClassLoader) {
            List urls = ((UrlClassLoader)loader).getBaseUrls();
            System.out.println("Collecting tests from " + urls);
            return urls;
        }
        return ContainerUtil.map((Object[])System.getProperty("java.class.path").split(File.pathSeparator), x$0 -> Paths.get(x$0, new String[0]));
    }

    private static List<Path> getClassRoots(URL[] urls) {
        List classLoaderRoots = ContainerUtil.map((Object[])urls, url -> {
            try {
                return Paths.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
        System.out.println("Collecting tests from " + classLoaderRoots);
        return classLoaderRoots;
    }

    public int countTestCases() {
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        if (!this.hasRealTests()) {
            return 0;
        }
        int count = 0;
        for (Class<?> aClass : this.myTestCaseLoader.getClasses()) {
            Test test = this.getTest(aClass);
            if (test == null) continue;
            count += test.countTestCases();
        }
        return count;
    }

    private void addErrorMessage(TestResult testResult, String message) {
        String processedTestsMessage = this.myRunTests <= 0 ? "None of tests was run" : this.myRunTests + " tests processed";
        try {
            testResult.startTest((Test)this);
            testResult.addError((Test)this, new Throwable(processedTestsMessage + " before: " + message));
            testResult.endTest((Test)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(TestResult testResult) {
        OutOfProcessRetries.OutOfProcessRetryListener outOfProcessRetryListener;
        if (!this.hasRealTests()) {
            return;
        }
        TestListener testListener = TestAll.loadDiscoveryListener();
        if (testListener != null) {
            testResult.addListener(testListener);
        }
        if ((outOfProcessRetryListener = OutOfProcessRetries.getListenerForOutOfProcessRetry()) != null) {
            testResult.addListener((TestListener)outOfProcessRetryListener);
        }
        testResult = RetriesImpl.maybeEnable(testResult);
        List<Class<?>> classes = this.myTestCaseLoader.getClasses();
        ArrayList testsToRun = new ArrayList(classes.size());
        for (Class<Object> aClass : classes) {
            if (!TestAll.isPotentiallyATest(aClass)) continue;
            testsToRun.add(aClass);
        }
        System.out.println("------");
        System.out.println("Running tests classes (list may contain classes which will not be actually run):");
        for (Class<Object> aClass : testsToRun) {
            System.out.println(aClass.getName());
        }
        System.out.println("------");
        TestAll.dumpSuite(testsToRun);
        System.out.println("------");
        int totalTests = classes.size();
        ArrayList<String> collectedTests = ourCollectTestsFile != null ? new ArrayList<String>(totalTests) : null;
        for (Class clazz : testsToRun) {
            this.runOrCollectNextTest(testResult, totalTests, clazz, collectedTests);
            if (!testResult.shouldStop()) continue;
            break;
        }
        if (testListener instanceof Closeable) {
            try {
                ((Closeable)testListener).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (outOfProcessRetryListener != null) {
            try {
                outOfProcessRetryListener.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (collectedTests != null) {
            Path path = Path.of(ourCollectTestsFile, new String[0]);
            try {
                collectedTests.remove("_FirstInSuiteTest");
                collectedTests.remove("_LastInSuiteTest");
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, collectedTests, new OpenOption[0]);
            }
            catch (IOException iOException) {
                System.err.printf("Cannot save list of test classes to '%s': %s%n", path.toAbsolutePath(), iOException);
                iOException.printStackTrace();
            }
        }
        TestCaseLoader.sendTestRunResultsToNastradamus();
    }

    private static void dumpSuite(List<Class<?>> testsToRun) {
        try {
            File suite = FileUtil.createTempFile((String)"TestAllSuite", (String)".java");
            String suiteName = FileUtil.getNameWithoutExtension((File)suite);
            StringBuilder sb = new StringBuilder();
            sb.append("import org.junit.runner.RunWith;\n");
            sb.append("import org.junit.runners.Suite;\n");
            sb.append("@RunWith(Suite.class)\n");
            sb.append("@Suite.SuiteClasses({\n");
            for (Class<?> aClass : testsToRun) {
                String name = aClass.getName();
                sb.append("  ").append(name.replace('$', '.')).append(".class,\n");
            }
            sb.append("})\n");
            sb.append("public class ").append(suiteName).append(" {}\n");
            FileUtil.writeToFile((File)suite, (String)sb.toString());
            if (TeamCityLogger.isUnderTC) {
                System.out.println("Generated suite file: '" + suite.getName() + "'. Could be found in 'suites' artifacts directory");
                System.out.println("##teamcity[publishArtifacts '" + suite.getAbsolutePath() + "=>suites/']");
            } else {
                System.out.println("Generated suite file: " + suite.getAbsolutePath());
            }
            System.out.println("Place it in `tests/integration/testSrc/` or similar directory");
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot dump test suite for reproducibility", e);
        }
    }

    private boolean hasRealTests() {
        return ContainerUtil.exists(this.myTestCaseLoader.getClasses(false), aClass -> this.getTest((Class<?>)aClass) != null);
    }

    private static TestListener loadDiscoveryListener() {
        String discoveryListener = System.getProperty("test.discovery.listener");
        if (discoveryListener != null) {
            try {
                return (TestListener)Class.forName(discoveryListener).newInstance();
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    private static boolean shouldAddFirstAndLastTests() {
        return !"true".equals(System.getProperty("intellij.build.test.ignoreFirstAndLastTests"));
    }

    private void runOrCollectNextTest(@NotNull TestResult testResult, int totalTests, @NotNull Class<?> testCaseClass, @Nullable List<String> collectedTests) {
        if (testResult == null) {
            TestAll.$$$reportNull$$$0(0);
        }
        if (testCaseClass == null) {
            TestAll.$$$reportNull$$$0(1);
        }
        ++this.myRunTests;
        int errorCount = testResult.errorCount();
        int count = errorCount + testResult.failureCount() - this.myIgnoredTests;
        if (count > MAX_FAILURE_TEST_COUNT && MAX_FAILURE_TEST_COUNT >= 0) {
            this.addErrorMessage(testResult, "Too many errors (" + count + ", MAX_FAILURE_TEST_COUNT = " + MAX_FAILURE_TEST_COUNT + "). Executed: " + this.myRunTests + " of " + totalTests);
            testResult.stop();
            return;
        }
        String caseClassName = testCaseClass.getName();
        Test test = this.getTest(testCaseClass);
        if (test == null) {
            TestAll.log("\nSkipping " + caseClassName + ": no Test detected");
            return;
        }
        TestAll.log("\nRunning " + caseClassName);
        if (collectedTests != null) {
            collectedTests.add(caseClassName);
            return;
        }
        try {
            test.run(testResult);
        }
        catch (Throwable t) {
            testResult.addError(test, t);
        }
        if (testResult.errorCount() > errorCount) {
            Enumeration errors2 = testResult.errors();
            while (errors2.hasMoreElements()) {
                TestFailure failure = (TestFailure)errors2.nextElement();
                if (errorCount-- > 0 || !IgnoreException.isIgnoringThrowable(failure.thrownException())) continue;
                ++this.myIgnoredTests;
            }
        }
    }

    @Nullable
    private Test getTest(final @NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            TestAll.$$$reportNull$$$0(2);
        }
        try {
            if (!Modifier.isPublic(testCaseClass.getModifiers())) {
                return null;
            }
            Method suiteMethod = TestAll.safeFindMethod(testCaseClass, "suite");
            if (suiteMethod != null && !TestCaseLoader.isPerformanceTestsRun()) {
                return (Test)suiteMethod.invoke(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
            }
            if (TestFrameworkUtil.isJUnit4TestClass(testCaseClass, false)) {
                boolean runEverything;
                boolean isPerformanceTest = TestCaseLoader.isPerformanceTest(null, testCaseClass.getSimpleName());
                boolean bl = runEverything = TestCaseLoader.isIncludingPerformanceTestsRun() || isPerformanceTest && TestCaseLoader.isPerformanceTestsRun();
                if (runEverything) {
                    return this.createJUnit4Adapter(testCaseClass);
                }
                RunWith runWithAnnotation = testCaseClass.getAnnotation(RunWith.class);
                if (runWithAnnotation != null && Parameterized.class.isAssignableFrom(runWithAnnotation.value())) {
                    if (TestCaseLoader.isPerformanceTestsRun() != isPerformanceTest) {
                        return null;
                    }
                    return this.createJUnit4Adapter(testCaseClass);
                }
                JUnit4TestAdapter adapter = this.createJUnit4Adapter(testCaseClass);
                try {
                    adapter.filter(NOT_IGNORED.intersect(TestCaseLoader.isPerformanceTestsRun() ? PERFORMANCE_ONLY : NO_PERFORMANCE));
                }
                catch (NoTestsRemainException noTestsRemainException) {
                    // empty catch block
                }
                return adapter;
            }
            final int[] testsCount = new int[]{0};
            TestSuite suite = new TestSuite(testCaseClass){

                public void addTest(Test test) {
                    if (!(test instanceof TestCase)) {
                        this.doAddTest(test);
                    } else {
                        String name = ((TestCase)test).getName();
                        if ("warning".equals(name)) {
                            return;
                        }
                        if (!TestCaseLoader.isIncludingPerformanceTestsRun() && TestCaseLoader.isPerformanceTestsRun() ^ TestCaseLoader.isPerformanceTest(name, testCaseClass.getSimpleName())) {
                            return;
                        }
                        Method method = 4.findTestMethod((TestCase)test);
                        if (method != null && (method.getAnnotation(IgnoreJUnit3.class) != null || method.getAnnotation(IJIgnore.class) != null)) {
                            return;
                        }
                        this.doAddTest(test);
                    }
                }

                private void doAddTest(Test test) {
                    testsCount[0] = testsCount[0] + 1;
                    super.addTest(test);
                }

                @Nullable
                private static Method findTestMethod(TestCase testCase) {
                    return TestAll.safeFindMethod(testCase.getClass(), testCase.getName());
                }
            };
            return testsCount[0] > 0 ? suite : null;
        }
        catch (Throwable t) {
            System.err.println("Failed to load test: " + testCaseClass.getName());
            t.printStackTrace(System.err);
            return null;
        }
    }

    private static boolean isPotentiallyATest(@NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            TestAll.$$$reportNull$$$0(3);
        }
        try {
            if (!Modifier.isPublic(testCaseClass.getModifiers())) {
                return false;
            }
            if (TestAll.safeFindMethod(testCaseClass, "suite") != null && !TestCaseLoader.isPerformanceTestsRun()) {
                return true;
            }
            if (TestFrameworkUtil.isJUnit4TestClass(testCaseClass, false)) {
                boolean runEverything;
                boolean isPerformanceTest = TestCaseLoader.isPerformanceTest(null, testCaseClass.getSimpleName());
                boolean bl = runEverything = TestCaseLoader.isIncludingPerformanceTestsRun() || isPerformanceTest && TestCaseLoader.isPerformanceTestsRun();
                if (runEverything) {
                    return true;
                }
                RunWith runWithAnnotation = testCaseClass.getAnnotation(RunWith.class);
                return runWithAnnotation == null || !Parameterized.class.isAssignableFrom(runWithAnnotation.value()) || TestCaseLoader.isPerformanceTestsRun() == isPerformanceTest;
            }
            try {
                if (TestSuite.getTestConstructor(testCaseClass) == null) {
                    return false;
                }
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            return Test.class.isAssignableFrom(testCaseClass);
        }
        catch (Throwable t) {
            System.err.println("Failed to load test: " + testCaseClass.getName());
            t.printStackTrace(System.err);
            return false;
        }
    }

    @NotNull
    protected JUnit4TestAdapter createJUnit4Adapter(@NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            TestAll.$$$reportNull$$$0(4);
        }
        return new JUnit4TestAdapter(testCaseClass, TestAll.getJUnit4TestAdapterCache());
    }

    private static JUnit4TestAdapterCache getJUnit4TestAdapterCache() {
        if (ourUnit4TestAdapterCache == null) {
            JUnit4TestAdapterCache cache;
            if ("junit5".equals(System.getProperty("intellij.build.test.runner"))) {
                try {
                    cache = (JUnit4TestAdapterCache)Class.forName("com.intellij.tests.JUnit5TeamCityRunnerForTestAllSuite").getMethod("createJUnit4TestAdapterCache", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    cache = JUnit4TestAdapterCache.getDefault();
                }
            } else {
                try {
                    cache = (JUnit4TestAdapterCache)Class.forName("org.apache.tools.ant.taskdefs.optional.junit.CustomJUnit4TestAdapterCache").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    System.out.println("Failed to create CustomJUnit4TestAdapterCache, the default JUnit4TestAdapterCache will be used and ignored tests won't be properly reported: " + e);
                    cache = JUnit4TestAdapterCache.getDefault();
                }
            }
            ourUnit4TestAdapterCache = RetriesImpl.maybeEnable(cache);
        }
        return ourUnit4TestAdapterCache;
    }

    @Nullable
    private static Method safeFindMethod(Class<?> klass, String name) {
        return ReflectionUtil.getMethod(klass, (String)name, (Class[])new Class[0]);
    }

    private static void log(@NotNull String message) {
        if (message == null) {
            TestAll.$$$reportNull$$$0(5);
        }
        TeamCityLogger.info(message);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static {
        Logger.setFactory(TestLoggerFactory.class);
        MAX_FAILURE_TEST_COUNT = Integer.parseInt(Objects.requireNonNullElse(System.getProperty(MAX_FAILURE_TEST_COUNT_FLAG), "150"));
        PERFORMANCE_ONLY = new Filter(){

            public boolean shouldRun(Description description) {
                String className = description.getClassName();
                String methodName = description.getMethodName();
                return TestFrameworkUtil.isPerformanceTest(methodName, className);
            }

            public String describe() {
                return "Performance Tests Only";
            }
        };
        NO_PERFORMANCE = new Filter(){

            public boolean shouldRun(Description description) {
                return !PERFORMANCE_ONLY.shouldRun(description);
            }

            public String describe() {
                return "All Except Performance";
            }
        };
        NOT_IGNORED = new Filter(){

            public boolean shouldRun(Description description) {
                return description.getAnnotation(IgnoreJUnit3.class) == null && description.getAnnotation(IJIgnore.class) == null;
            }

            public String describe() {
                return "Not @IgnoreJUnit3";
            }
        };
        ourClassLoadingProblems = new ArrayList<Throwable>();
        ourCollectTestsFile = System.getProperty("intellij.build.test.list.classes", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testResult";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/TestAll";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runOrCollectNextTest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPotentiallyATest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createJUnit4Adapter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

