/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.TransparentInstruction;
import com.intellij.codeInsight.controlflow.impl.ConditionalInstructionImpl;
import com.intellij.codeInsight.controlflow.impl.TransparentInstructionImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.PyFinallyFailExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.PyRaiseInstruction;
import com.jetbrains.python.codeInsight.controlflow.PyTypeAssertionEvaluator;
import com.jetbrains.python.codeInsight.controlflow.PyWithContextExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.RefutablePatternInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAsPattern;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyClassPattern;
import com.jetbrains.python.psi.PyComprehensionComponent;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyComprehensionIfComponent;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGroupPattern;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyOrPattern;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyValuePattern;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWildcardPattern;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyControlFlowBuilder
extends PyRecursiveElementVisitor {
    private final ControlFlowBuilder myBuilder = new ControlFlowBuilder();
    @Nullable
    private TrueFalseNodes myTrueFalseNodes;

    public ControlFlow buildControlFlow(@NotNull ScopeOwner owner) {
        if (owner == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(0);
        }
        return this.myBuilder.build((PsiElementVisitor)this, (PsiElement)owner);
    }

    @NotNull
    protected ControlFlowBuilder getBuilder() {
        ControlFlowBuilder controlFlowBuilder = this.myBuilder;
        if (controlFlowBuilder == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(1);
        }
        return controlFlowBuilder;
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        PyAnnotation annotation;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(2);
        }
        this.myBuilder.startNode((PsiElement)node);
        this.visitParameterListExpressions(node.getParameterList());
        this.visitDecorators(node.getDecoratorList());
        if (node.getTypeParameterList() == null && (annotation = node.getAnnotation()) != null) {
            annotation.acceptChildren(this);
        }
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
    }

    @Override
    public void visitPyDecoratorList(@NotNull PyDecoratorList node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(3);
        }
    }

    private void visitDecorators(PyDecoratorList list) {
        if (list != null) {
            for (PyDecorator decorator : list.getDecorators()) {
                decorator.accept(this);
            }
        }
    }

    private void visitParameterListExpressions(final PyParameterList parameterList) {
        ParamHelper.walkDownParamArray(parameterList.getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                PyAnnotation annotation;
                PyFunction function;
                PsiElement psiElement;
                PyExpression defaultValue = param.getDefaultValue();
                if (defaultValue != null) {
                    defaultValue.accept(PyControlFlowBuilder.this);
                }
                if ((psiElement = parameterList.getParent()) instanceof PyFunction && (function = (PyFunction)psiElement).getTypeParameterList() == null && (annotation = param.getAnnotation()) != null) {
                    annotation.acceptChildren(PyControlFlowBuilder.this);
                }
            }
        });
    }

    @Override
    public void visitPyClass(@NotNull PyClass node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(4);
        }
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression element : node.getSuperClassExpressions()) {
            element.accept(this);
        }
        this.visitDecorators(node.getDecoratorList());
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
    }

    @Override
    public void visitPyStatement(@NotNull PyStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(5);
        }
        this.myBuilder.startNode((PsiElement)node);
        super.visitPyStatement(node);
    }

    @Override
    public void visitPyElement(@NotNull PyElement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(6);
        }
        if (node instanceof PsiNamedElement && !(node instanceof PyKeywordArgument)) {
            this.myBuilder.startNode((PsiElement)node);
            this.myBuilder.addNode((Instruction)ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getName(), ReadWriteInstruction.ACCESS.WRITE));
        }
        super.visitPyElement(node);
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(7);
        }
        super.visitPyCallExpression(node);
        CallInstruction callInstruction = new CallInstruction(this.myBuilder, node);
        this.myBuilder.addNodeAndCheckPending((Instruction)callInstruction);
        if (node.isCalleeText(new String[]{"assertIsInstance"})) {
            this.addTypeAssertionNodes(node, true);
        }
    }

    @Override
    public void visitPySubscriptionExpression(@NotNull PySubscriptionExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(8);
        }
        this.myBuilder.startNode((PsiElement)node);
        node.getOperand().accept(this);
        PyExpression expression = node.getIndexExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        PyExpression qualifier;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(9);
        }
        if ((qualifier = node.getQualifier()) != null) {
            qualifier.accept(this);
            return;
        }
        if (PyImportStatementNavigator.getImportStatementByElement((PsiElement)node) != null) {
            return;
        }
        ReadWriteInstruction.ACCESS access = PyAugAssignmentStatementNavigator.getStatementByTarget((PsiElement)node) != null ? ReadWriteInstruction.ACCESS.READWRITE : ReadWriteInstruction.ACCESS.READ;
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getName(), access);
        this.myBuilder.addNodeAndCheckPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyBoolLiteralExpression(@NotNull PyBoolLiteralExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(10);
        }
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getText(), ReadWriteInstruction.ACCESS.READ);
        this.myBuilder.addNodeAndCheckPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyNoneLiteralExpression(@NotNull PyNoneLiteralExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(11);
        }
        ReadWriteInstruction readWriteInstruction = ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)node, node.getText(), ReadWriteInstruction.ACCESS.READ);
        this.myBuilder.addNodeAndCheckPending((Instruction)readWriteInstruction);
    }

    @Override
    public void visitPyTypeDeclarationStatement(@NotNull PyTypeDeclarationStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(12);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyAnnotation annotation = node.getAnnotation();
        if (annotation != null) {
            annotation.accept(this);
        }
        node.getTarget().accept(this);
    }

    @Override
    public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
        PyAnnotation annotation;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(13);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression value = node.getAssignedValue();
        if (value != null) {
            value.accept(this);
        }
        if ((annotation = node.getAnnotation()) != null) {
            annotation.accept(this);
        }
        for (PyExpression expression : node.getRawTargets()) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyDelStatement(@NotNull PyDelStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(14);
        }
        this.myBuilder.startNode((PsiElement)node);
        for (PyExpression target : node.getTargets()) {
            if (target instanceof PyReferenceExpression) {
                PyReferenceExpression expr = (PyReferenceExpression)target;
                this.myBuilder.addNode((Instruction)ReadWriteInstruction.newInstruction(this.myBuilder, (PsiElement)target, expr.getName(), ReadWriteInstruction.ACCESS.DELETE));
                PyExpression qualifier = expr.getQualifier();
                if (qualifier == null) continue;
                qualifier.accept(this);
                continue;
            }
            target.accept(this);
        }
    }

    @Override
    public void visitPyAugAssignmentStatement(@NotNull PyAugAssignmentStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(15);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression value = node.getValue();
        if (value != null) {
            value.accept(this);
        }
        node.getTarget().accept(this);
    }

    @Override
    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        PyExpression qualifier;
        QualifiedName qName;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(16);
        }
        if ((qName = node.asQualifiedName()) != null) {
            ReadWriteInstruction instruction = ReadWriteInstruction.newInstruction(this.myBuilder, node, qName.toString(), ReadWriteInstruction.ACCESS.WRITE);
            this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
        }
        if ((qualifier = node.getQualifier()) != null) {
            qualifier.accept(this);
        }
    }

    @Override
    public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
        PyAnnotation annotation;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(17);
        }
        if ((annotation = node.getAnnotation()) != null) {
            annotation.accept(this);
        }
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
    }

    @Override
    public void visitPyAnnotation(@NotNull PyAnnotation node) {
        PyFunction function;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(18);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)true, (Class[])new Class[]{PyStatement.class})) == null || function.getTypeParameterList() != null) {
            super.visitPyAnnotation(node);
        }
    }

    @Override
    public void visitPyImportStatement(@NotNull PyImportStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(19);
        }
        this.visitPyImportStatementBase(node);
    }

    @Override
    public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(20);
        }
        this.visitPyImportStatementBase(node);
        PyStarImportElement starImportElement = node.getStarImportElement();
        if (starImportElement != null) {
            starImportElement.accept(this);
        }
    }

    @Override
    public void visitPyStarImportElement(@NotNull PyStarImportElement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(21);
        }
        this.myBuilder.startNode((PsiElement)node);
    }

    private void visitPyImportStatementBase(PyImportStatementBase node) {
        this.myBuilder.startNode((PsiElement)node);
        for (PyImportElement importElement : node.getImportElements()) {
            ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, importElement, importElement.getVisibleName());
            this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
        }
    }

    @Override
    public void visitPyConditionalExpression(@NotNull PyConditionalExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(22);
        }
        this.myBuilder.startNode((PsiElement)node);
        TransparentInstruction trueNode = this.addTransparentInstruction();
        TransparentInstruction falseNode = this.addTransparentInstruction();
        TransparentInstruction exitNode = this.addTransparentInstruction();
        PyExpression condition = node.getCondition();
        if (condition != null) {
            this.visitCondition(condition, (Instruction)trueNode, (Instruction)falseNode);
        }
        PyExpression truePart = node.getTruePart();
        PyExpression falsePart = node.getFalsePart();
        if (truePart != null) {
            this.myBuilder.prevInstruction = trueNode;
            truePart.accept(this);
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)exitNode);
        }
        if (falsePart != null) {
            this.myBuilder.prevInstruction = falseNode;
            falsePart.accept(this);
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)exitNode);
        }
        this.myBuilder.prevInstruction = exitNode;
    }

    @Override
    public void visitPyMatchStatement(@NotNull PyMatchStatement matchStatement) {
        if (matchStatement == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(23);
        }
        this.myBuilder.startNode((PsiElement)matchStatement);
        PyExpression subject = matchStatement.getSubject();
        if (subject != null) {
            subject.accept(this);
        }
        for (PyCaseClause caseClause : matchStatement.getCaseClauses()) {
            this.visitPyCaseClause(caseClause);
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)new TransparentInstructionImpl(this.myBuilder, (PsiElement)matchStatement, ""));
        if (!this.myBuilder.prevInstruction.allPred().isEmpty()) {
            this.addTypeAssertionNodes(matchStatement, false);
        }
        this.myBuilder.addPendingEdge((PsiElement)matchStatement, this.myBuilder.prevInstruction);
        this.myBuilder.prevInstruction = null;
    }

    @Override
    public void visitPyCaseClause(@NotNull PyCaseClause clause) {
        PyPattern pattern;
        if (clause == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(24);
        }
        if ((pattern = clause.getPattern()) != null) {
            pattern.accept(this);
            this.addTypeAssertionNodes(pattern, true);
        }
        TransparentInstruction trueNode = this.addTransparentInstruction();
        TransparentInstruction falseNode = this.addTransparentInstruction();
        PyExpression guard = clause.getGuardCondition();
        if (guard != null) {
            this.visitCondition(guard, (Instruction)trueNode, (Instruction)falseNode);
            this.addTypeAssertionNodes(guard, true);
        } else {
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)trueNode);
        }
        this.myBuilder.addPendingEdge((PsiElement)clause, (Instruction)falseNode);
        this.myBuilder.prevInstruction = trueNode;
        clause.getStatementList().accept(this);
        PsiElement psiElement = clause.getParent();
        if (psiElement instanceof PyMatchStatement) {
            PyMatchStatement matchStatement = (PyMatchStatement)psiElement;
            this.myBuilder.addPendingEdge((PsiElement)matchStatement, this.myBuilder.prevInstruction);
            this.myBuilder.updatePendingElementScope((PsiElement)clause.getStatementList(), (PsiElement)matchStatement);
        }
        this.myBuilder.prevInstruction = null;
    }

    @Override
    public void visitWildcardPattern(@NotNull PyWildcardPattern node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(25);
        }
        this.myBuilder.startNode((PsiElement)node);
    }

    @Override
    public void visitPyPattern(@NotNull PyPattern node) {
        boolean isRefutable;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(26);
        }
        boolean bl = isRefutable = !node.isIrrefutable();
        if (isRefutable) {
            this.myBuilder.addNodeAndCheckPending((Instruction)new RefutablePatternInstruction(this.myBuilder, node, false));
            this.myBuilder.addPendingEdge(node.getParent(), this.myBuilder.prevInstruction);
        }
        node.acceptChildren(this);
        this.myBuilder.updatePendingElementScope((PsiElement)node, node.getParent());
        if (isRefutable) {
            this.myBuilder.addNode((Instruction)new RefutablePatternInstruction(this.myBuilder, node, true));
        }
    }

    @Override
    public void visitPyOrPattern(@NotNull PyOrPattern node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(27);
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)new RefutablePatternInstruction(this.myBuilder, node, false));
        TransparentInstructionImpl onSuccess = new TransparentInstructionImpl(this.myBuilder, (PsiElement)node, "onSuccess");
        List<PyPattern> alternatives = node.getAlternatives();
        PyPattern lastAlternative = (PyPattern)ContainerUtil.getLastItem(alternatives);
        for (PyPattern alternative : alternatives) {
            alternative.accept(this);
            if (alternative != lastAlternative) {
                this.myBuilder.updatePendingElementScope((PsiElement)node, (PsiElement)alternative);
            }
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)onSuccess);
            this.myBuilder.prevInstruction = null;
        }
        this.myBuilder.addNode((Instruction)onSuccess);
        this.myBuilder.addNode((Instruction)new RefutablePatternInstruction(this.myBuilder, node, true));
        this.myBuilder.updatePendingElementScope((PsiElement)node, node.getParent());
    }

    @Override
    public void visitPyClassPattern(@NotNull PyClassPattern node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(28);
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)new RefutablePatternInstruction(this.myBuilder, node, false));
        node.getClassNameReference().accept(this);
        this.myBuilder.addPendingEdge(node.getParent(), this.myBuilder.prevInstruction);
        node.getArgumentList().acceptChildren(this);
        this.myBuilder.updatePendingElementScope((PsiElement)node, node.getParent());
        this.myBuilder.addNode((Instruction)new RefutablePatternInstruction(this.myBuilder, node, true));
    }

    @Override
    public void visitPyValuePattern(@NotNull PyValuePattern node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(29);
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)new RefutablePatternInstruction(this.myBuilder, node, false));
        node.getValue().accept(this);
        this.myBuilder.addPendingEdge(node.getParent(), this.myBuilder.prevInstruction);
        this.myBuilder.addNode((Instruction)new RefutablePatternInstruction(this.myBuilder, node, true));
    }

    @Override
    public void visitPyAsPattern(@NotNull PyAsPattern node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(30);
        }
        this.myBuilder.startNode((PsiElement)node);
        node.acceptChildren(this);
        this.myBuilder.updatePendingElementScope((PsiElement)node, node.getParent());
    }

    @Override
    public void visitPyGroupPattern(@NotNull PyGroupPattern node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(31);
        }
        node.acceptChildren(this);
        this.myBuilder.updatePendingElementScope((PsiElement)node, node.getParent());
    }

    @Override
    public void visitPyIfStatement(@NotNull PyIfStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(32);
        }
        this.myBuilder.startNode((PsiElement)node);
        ArrayList<Instruction> exitInstructions = new ArrayList<Instruction>();
        boolean unreachable = false;
        for (PyIfPart ifPart : StreamEx.of((Object)node.getIfPart()).append((Object[])node.getElifParts())) {
            TransparentInstruction thenNode = this.addTransparentInstruction();
            TransparentInstruction elseNode = this.addTransparentInstruction();
            PyExpression condition = ifPart.getCondition();
            if (condition != null) {
                this.visitCondition(condition, (Instruction)thenNode, (Instruction)elseNode);
            }
            Boolean conditionResult = PyEvaluator.evaluateAsBooleanNoResolve(condition);
            TransparentInstruction transparentInstruction = this.myBuilder.prevInstruction = unreachable || Boolean.FALSE.equals(conditionResult) ? null : thenNode;
            if (Boolean.TRUE.equals(conditionResult)) {
                unreachable = true;
            }
            this.visitPyStatementPart(ifPart);
            exitInstructions.add(this.myBuilder.prevInstruction);
            this.myBuilder.prevInstruction = elseNode;
        }
        PyElsePart elsePart = node.getElsePart();
        if (elsePart != null) {
            if (unreachable) {
                this.myBuilder.prevInstruction = null;
            }
            this.visitPyStatementPart(elsePart);
        }
        exitInstructions.add(this.myBuilder.prevInstruction);
        this.myBuilder.prevInstruction = this.addTransparentInstruction();
        for (Instruction exitInstruction : Lists.reverse(exitInstructions)) {
            this.myBuilder.addEdge(exitInstruction, this.myBuilder.prevInstruction);
        }
    }

    @Override
    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(33);
        }
        if (this.myTrueFalseNodes != null && node.getOperator() == PyTokenTypes.NOT_KEYWORD) {
            PyExpression operand = node.getOperand();
            if (operand != null) {
                this.visitCondition(operand, this.myTrueFalseNodes.falseNode, this.myTrueFalseNodes.trueNode);
            }
        } else {
            super.visitPyPrefixExpression(node);
        }
    }

    @Override
    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        PyElementType operator;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(34);
        }
        if ((operator = node.getOperator()) == PyTokenTypes.AND_KEYWORD || operator == PyTokenTypes.OR_KEYWORD) {
            Instruction trueNode;
            TransparentInstruction falseNode;
            TransparentInstruction exitNode;
            PyExpression left = node.getLeftExpression();
            PyExpression right = node.getRightExpression();
            if (left == null || right == null) {
                return;
            }
            this.myBuilder.startNode((PsiElement)node);
            if (this.myTrueFalseNodes == null) {
                falseNode = exitNode = this.addTransparentInstruction();
                trueNode = exitNode;
            } else {
                trueNode = this.myTrueFalseNodes.trueNode;
                falseNode = this.myTrueFalseNodes.falseNode;
                exitNode = null;
            }
            TransparentInstruction rightNode = this.addTransparentInstruction();
            if (operator == PyTokenTypes.AND_KEYWORD) {
                this.visitCondition(left, (Instruction)rightNode, (Instruction)falseNode);
            } else {
                this.visitCondition(left, trueNode, (Instruction)rightNode);
            }
            this.myBuilder.prevInstruction = rightNode;
            this.visitCondition(right, trueNode, (Instruction)falseNode);
            if (exitNode != null) {
                this.myBuilder.prevInstruction = exitNode;
            }
        } else {
            super.visitPyBinaryExpression(node);
        }
    }

    @Override
    public void visitPyWhileStatement(@NotNull PyWhileStatement node) {
        Boolean conditionResult;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(35);
        }
        Instruction entryNode = this.myBuilder.startNode((PsiElement)node);
        TransparentInstruction thenNode = this.addTransparentInstruction();
        TransparentInstruction elseNode = this.addTransparentInstruction();
        PyWhilePart whilePart = node.getWhilePart();
        PyExpression condition = whilePart.getCondition();
        if (condition != null) {
            this.visitCondition(condition, (Instruction)thenNode, (Instruction)elseNode);
        }
        this.myBuilder.prevInstruction = Boolean.FALSE.equals(conditionResult = PyEvaluator.evaluateAsBooleanNoResolve(condition)) ? null : thenNode;
        this.visitPyStatementPart(whilePart);
        this.myBuilder.checkPending(entryNode);
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, entryNode);
        this.myBuilder.prevInstruction = Boolean.TRUE.equals(conditionResult) ? null : elseNode;
        PyElsePart elsePart = node.getElsePart();
        if (elsePart != null) {
            this.visitPyStatementPart(elsePart);
        }
    }

    @Override
    public void visitPyForStatement(@NotNull PyForStatement node) {
        Instruction body;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(36);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyForPart forPart = node.getForPart();
        PyExpression source = forPart.getSource();
        if (source != null) {
            source.accept(this);
        }
        Instruction head = this.myBuilder.prevInstruction;
        PyElsePart elsePart = node.getElsePart();
        if (elsePart == null && !PyControlFlowBuilder.loopHasAtLeastOneIteration(node)) {
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyStatementList list = forPart.getStatementList();
        PyExpression target = forPart.getTarget();
        if (target != null) {
            body = this.myBuilder.startNode((PsiElement)target);
            target.accept(this);
        } else {
            body = this.myBuilder.startNode((PsiElement)list);
        }
        list.accept(this);
        if (this.myBuilder.prevInstruction != null) {
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, body);
            this.myBuilder.addPendingEdge((PsiElement)list, this.myBuilder.prevInstruction);
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)list, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addEdge(instruction, body);
                this.myBuilder.addPendingEdge((PsiElement)list, instruction);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
        this.myBuilder.prevInstruction = head;
        if (elsePart != null) {
            elsePart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    private static boolean loopHasAtLeastOneIteration(@NotNull PyLoopStatement loopStatement) {
        if (loopStatement == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(37);
        }
        PyExpression expression = loopStatement instanceof PyForStatement ? ((PyForStatement)loopStatement).getForPart().getSource() : (loopStatement instanceof PyWhileStatement ? ((PyWhileStatement)loopStatement).getWhilePart().getCondition() : null);
        return PyEvaluator.evaluateAsBooleanNoResolve(expression, false);
    }

    @Override
    public void visitPyBreakStatement(@NotNull PyBreakStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(38);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyLoopStatement loop = node.getLoopStatement();
        if (loop != null) {
            this.myBuilder.addPendingEdge((PsiElement)loop, this.myBuilder.prevInstruction);
        } else {
            this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyContinueStatement(@NotNull PyContinueStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(39);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyLoopStatement loop = node.getLoopStatement();
        if (loop != null) {
            Instruction instruction = this.myBuilder.findInstructionByElement((PsiElement)loop);
            if (instruction != null) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, instruction);
            } else {
                this.myBuilder.addPendingEdge(null, null);
            }
            if (PyControlFlowBuilder.loopHasAtLeastOneIteration(loop)) {
                this.myBuilder.addPendingEdge((PsiElement)loop, this.myBuilder.prevInstruction);
            }
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(40);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visitPyRaiseStatement(@NotNull PyRaiseStatement node) {
        PyExpression[] expressions;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(41);
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)new PyRaiseInstruction(this.myBuilder, node));
        for (PyExpression expression : expressions = node.getExpressions()) {
            expression.accept(this);
        }
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(42);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
        this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitPyTryExceptStatement(@NotNull PyTryExceptStatement node) {
        Instruction finallyFailInstruction;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(43);
        }
        this.myBuilder.startNode((PsiElement)node);
        PyTryPart tryPart = node.getTryPart();
        this.myBuilder.startNode((PsiElement)tryPart);
        tryPart.accept(this);
        PyElsePart elsePart = node.getElsePart();
        if (elsePart != null) {
            this.myBuilder.startNode((PsiElement)elsePart);
            elsePart.accept(this);
        }
        this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        ArrayList<Instruction> exceptInstructions = new ArrayList<Instruction>();
        ArrayList pendingBackup = new ArrayList();
        for (PyExceptPart exceptPart : node.getExceptParts()) {
            pendingBackup.addAll(this.myBuilder.pending);
            this.myBuilder.pending = new ArrayList();
            this.myBuilder.flowAbrupted();
            Instruction exceptInstruction = this.myBuilder.startNode((PsiElement)exceptPart);
            exceptPart.accept(this);
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
            exceptInstructions.add(exceptInstruction);
        }
        for (Pair pair : pendingBackup) {
            this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
        }
        ArrayList pendingNormalExits = new ArrayList();
        PyFinallyPart finallyPart = node.getFinallyPart();
        if (finallyPart != null) {
            this.myBuilder.processPending((pendingScope, instruction) -> {
                PsiElement pendingElement = instruction.getElement();
                if (pendingElement != null) {
                    boolean isPending;
                    boolean bl = isPending = PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)pendingElement, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)finallyPart, (PsiElement)pendingElement, (boolean)false);
                    if (isPending && pendingScope != null) {
                        pendingNormalExits.add(Pair.createNonNull((Object)pendingScope, (Object)instruction));
                    } else {
                        this.myBuilder.addPendingEdge(pendingScope, instruction);
                    }
                }
            });
        }
        if (finallyPart != null) {
            this.myBuilder.flowAbrupted();
            finallyFailInstruction = this.myBuilder.startNode((PsiElement)finallyPart);
            finallyPart.accept(this);
            this.myBuilder.addNode((Instruction)new PyFinallyFailExitInstruction(this.myBuilder, finallyFailInstruction));
            this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
            this.myBuilder.flowAbrupted();
        } else {
            finallyFailInstruction = null;
        }
        for (Instruction instruction2 : this.myBuilder.instructions) {
            PsiElement e = instruction2.getElement();
            if (e == null || !PyControlFlowBuilder.canRaiseExceptions(instruction2)) continue;
            if (PsiTreeUtil.getParentOfType((PsiElement)e, PyTryPart.class, (boolean)false) == tryPart) {
                for (Instruction inst : exceptInstructions) {
                    this.myBuilder.addEdge(instruction2, inst);
                }
                if (finallyPart != null) {
                    this.myBuilder.addEdge(instruction2, finallyFailInstruction);
                }
            }
            if (finallyPart == null) continue;
            for (PyExceptPart exceptPart : node.getExceptParts()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)exceptPart, (PsiElement)e, (boolean)false)) continue;
                this.myBuilder.addEdge(instruction2, finallyFailInstruction);
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)elsePart, (PsiElement)e, (boolean)false)) continue;
            this.myBuilder.addEdge(instruction2, finallyFailInstruction);
        }
        if (finallyPart != null) {
            Instruction finallyInstruction;
            this.myBuilder.processPending((pendingScope, instruction) -> {
                PsiElement e = instruction.getElement();
                if (e != null) {
                    if (PsiTreeUtil.isAncestor((PsiElement)finallyPart, (PsiElement)e, (boolean)false)) {
                        this.myBuilder.addPendingEdge(null, instruction);
                    } else if (pendingScope == null && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)e, (boolean)false)) {
                        this.myBuilder.addEdge(instruction, finallyFailInstruction);
                    } else {
                        this.myBuilder.addPendingEdge(pendingScope, instruction);
                    }
                }
            });
            if (!pendingNormalExits.isEmpty()) {
                pendingBackup = new ArrayList(this.myBuilder.pending);
                this.myBuilder.pending = new ArrayList();
                this.myBuilder.flowAbrupted();
                Instruction finallySuccessInstruction = this.myBuilder.startNode((PsiElement)finallyPart);
                finallyPart.accept(this);
                for (Pair pair : pendingBackup) {
                    this.myBuilder.addPendingEdge((PsiElement)pair.first, (Instruction)pair.second);
                }
                finallyInstruction = finallySuccessInstruction;
            } else {
                finallyInstruction = finallyFailInstruction;
            }
            for (Pair pendingScopeAndInstruction : pendingNormalExits) {
                PsiElement pendingScope2 = (PsiElement)pendingScopeAndInstruction.first;
                Instruction instruction3 = (Instruction)pendingScopeAndInstruction.second;
                this.myBuilder.addEdge(instruction3, finallyInstruction);
                if (!PsiTreeUtil.isAncestor((PsiElement)pendingScope2, (PsiElement)node, (boolean)true)) continue;
                this.myBuilder.addPendingEdge(pendingScope2, this.myBuilder.prevInstruction);
            }
        }
    }

    @Override
    public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(44);
        }
        PyExpression prevCondition = null;
        this.myBuilder.startNode((PsiElement)node);
        ArrayList<Instruction> iterators = new ArrayList<Instruction>();
        for (PyComprehensionComponent component2 : node.getComponents()) {
            PyComprehensionIfComponent c;
            PyExpression condition;
            if (component2 instanceof PyComprehensionForComponent) {
                PyComprehensionForComponent c2 = (PyComprehensionForComponent)component2;
                PyExpression iteratedList = (PyExpression)c2.getIteratedList();
                PyExpression iteratorVariable = (PyExpression)c2.getIteratorVariable();
                if (prevCondition != null) {
                    this.myBuilder.startConditionalNode((PsiElement)iteratedList, prevCondition, true);
                    prevCondition = null;
                } else {
                    this.myBuilder.startNode((PsiElement)iteratedList);
                }
                iteratedList.accept(this);
                for (Instruction i : iterators) {
                    this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
                }
                this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
                Instruction iterator = this.myBuilder.startNode((PsiElement)iteratorVariable);
                iteratorVariable.accept(this);
                iterators.add(iterator);
                continue;
            }
            if (!(component2 instanceof PyComprehensionIfComponent) || (condition = (PyExpression)(c = (PyComprehensionIfComponent)component2).getTest()) == null) continue;
            if (prevCondition != null) {
                this.myBuilder.startConditionalNode((PsiElement)condition, prevCondition, true);
            } else {
                this.myBuilder.startNode((PsiElement)condition);
            }
            condition.accept(this);
            this.addTypeAssertionNodes(condition, true);
            prevCondition = condition;
            for (Instruction i : iterators) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
            }
            this.myBuilder.addPendingEdge((PsiElement)node, this.myBuilder.prevInstruction);
        }
        PyExpression result2 = node.getResultExpression();
        if (result2 != null) {
            if (prevCondition != null) {
                this.myBuilder.startConditionalNode((PsiElement)result2, prevCondition, true);
            } else {
                this.myBuilder.startNode((PsiElement)result2);
            }
            result2.accept(this);
            for (Instruction i : iterators) {
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, i);
            }
        }
    }

    @Override
    public void visitPyAssertStatement(@NotNull PyAssertStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(45);
        }
        this.myBuilder.startNode((PsiElement)node);
        super.visitPyAssertStatement(node);
        PyExpression[] args = node.getArguments();
        if (args.length >= 1) {
            if (!PyEvaluator.evaluateAsBooleanNoResolve(args[0], true)) {
                this.myBuilder.addNode((Instruction)new PyRaiseInstruction(this.myBuilder, node));
                this.myBuilder.addPendingEdge(null, this.myBuilder.prevInstruction);
                this.myBuilder.flowAbrupted();
                return;
            }
            TransparentInstruction trueNode = this.addTransparentInstruction();
            TransparentInstruction falseNode = this.addTransparentInstruction();
            this.visitCondition(args[0], (Instruction)trueNode, (Instruction)falseNode);
            PyRaiseInstruction raiseInstruction = new PyRaiseInstruction(this.myBuilder, node);
            this.myBuilder.instructions.add(raiseInstruction);
            this.myBuilder.addEdge((Instruction)falseNode, (Instruction)raiseInstruction);
            this.myBuilder.addPendingEdge(null, (Instruction)raiseInstruction);
            this.myBuilder.prevInstruction = trueNode;
        }
    }

    @Override
    public void visitPyLambdaExpression(@NotNull PyLambdaExpression node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(46);
        }
        this.myBuilder.startNode((PsiElement)node);
        this.visitParameterListExpressions(node.getParameterList());
    }

    @Override
    public void visitPyWithStatement(@NotNull PyWithStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(47);
        }
        this.myBuilder.startNode((PsiElement)node);
        ArrayList<PyWithContextExitInstruction> exits = new ArrayList<PyWithContextExitInstruction>();
        for (PyWithItem pyWithItem : node.getWithItems()) {
            int itemStart = this.myBuilder.instructions.size();
            pyWithItem.accept(this);
            int itemEnd = this.myBuilder.instructions.size();
            for (int i = itemStart; i < itemEnd; ++i) {
                Instruction instruction = (Instruction)this.myBuilder.instructions.get(i);
                PsiElement e = instruction.getElement();
                if (e == null || !PyControlFlowBuilder.canRaiseExceptions(instruction) || !PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)e, (boolean)false)) continue;
                for (Instruction instruction2 : exits) {
                    this.myBuilder.addEdge((Instruction)this.myBuilder.instructions.get(i), instruction2);
                }
            }
            PyWithContextExitInstruction nextExit = new PyWithContextExitInstruction(this.myBuilder, pyWithItem);
            exits.add(nextExit);
            this.myBuilder.instructions.add(nextExit);
        }
        TransparentInstruction toAllExits = this.addTransparentInstruction();
        TransparentInstruction fromAllExits = this.addTransparentInstruction();
        for (Instruction instruction : exits) {
            this.myBuilder.addEdge((Instruction)toAllExits, instruction);
            this.myBuilder.addEdge(instruction, (Instruction)fromAllExits);
        }
        int stmtStart = this.myBuilder.instructions.size();
        node.getStatementList().accept(this);
        int n = this.myBuilder.instructions.size();
        for (int j = stmtStart; j < n; ++j) {
            Instruction instruction = (Instruction)this.myBuilder.instructions.get(j);
            PsiElement e = instruction.getElement();
            if (e == null || !PyControlFlowBuilder.canRaiseExceptions(instruction) || !PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)e, (boolean)false)) continue;
            this.myBuilder.addEdge(instruction, (Instruction)toAllExits);
        }
        if (exits.size() > 1 || !toAllExits.allPred().isEmpty()) {
            this.myBuilder.addPendingEdge((PsiElement)node, (Instruction)fromAllExits);
        }
    }

    @Override
    public void visitPyAssignmentExpression(@NotNull PyAssignmentExpression node) {
        PyTargetExpression target;
        PyExpression assignedValue;
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(48);
        }
        if ((assignedValue = node.getAssignedValue()) != null) {
            assignedValue.accept(this);
        }
        if ((target = node.getTarget()) != null) {
            target.accept(this);
        }
    }

    @Override
    public void visitPyTypeAliasStatement(@NotNull PyTypeAliasStatement node) {
        if (node == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(49);
        }
        this.myBuilder.startNode((PsiElement)node);
        ReadWriteInstruction instruction = ReadWriteInstruction.write(this.myBuilder, node, node.getName());
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
    }

    private void visitCondition(@NotNull PyExpression expression, @NotNull Instruction trueNode, @NotNull Instruction falseNode) {
        if (expression == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(50);
        }
        if (trueNode == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(51);
        }
        if (falseNode == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(52);
        }
        TrueFalseNodes prevTrueFalseNodes = this.myTrueFalseNodes;
        this.myTrueFalseNodes = new TrueFalseNodes(trueNode, falseNode);
        expression.accept(this);
        this.myTrueFalseNodes = prevTrueFalseNodes;
        PyExpression condition = PyPsiUtils.flattenParens(expression);
        if (condition != null && !PyControlFlowBuilder.isLogicalExpression(condition)) {
            this.addConditionalNode(expression, false, falseNode);
            this.addConditionalNode(expression, true, trueNode);
        }
    }

    private static boolean isLogicalExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(53);
        }
        if (expression instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)expression;
            PyElementType operator = binaryExpression.getOperator();
            return operator == PyTokenTypes.AND_KEYWORD || operator == PyTokenTypes.OR_KEYWORD;
        }
        if (expression instanceof PyPrefixExpression) {
            PyPrefixExpression prefixExpression = (PyPrefixExpression)expression;
            return prefixExpression.getOperator() == PyTokenTypes.NOT_KEYWORD;
        }
        return false;
    }

    private void addConditionalNode(@NotNull PyExpression condition, boolean result2, @NotNull Instruction target) {
        if (condition == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(54);
        }
        if (target == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(55);
        }
        Instruction prevInstruction = this.myBuilder.prevInstruction;
        this.myBuilder.addNode((Instruction)new ConditionalInstructionImpl(this.myBuilder, null, (PsiElement)condition, result2));
        this.addTypeAssertionNodes(condition, result2);
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, target);
        this.myBuilder.prevInstruction = prevInstruction;
    }

    private void visitPyStatementPart(@NotNull PyStatementPart statementPart) {
        if (statementPart == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(56);
        }
        PyStatementList statementList = statementPart.getStatementList();
        this.myBuilder.startNode((PsiElement)statementList);
        statementList.accept(this);
    }

    private static boolean canRaiseExceptions(@NotNull Instruction instruction) {
        PyReturnStatement returnStatement;
        if (instruction == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(57);
        }
        if (instruction instanceof ReadWriteInstruction) {
            return true;
        }
        PsiElement element = instruction.getElement();
        return !(element instanceof PyReturnStatement && (returnStatement = (PyReturnStatement)element).getExpression() == null || element instanceof PyContinueStatement || element instanceof PyBreakStatement || element instanceof PyPassStatement || element instanceof PyStatementList);
    }

    private void addTypeAssertionNodes(@NotNull PyElement condition, boolean positive) {
        if (condition == null) {
            PyControlFlowBuilder.$$$reportNull$$$0(58);
        }
        PyTypeAssertionEvaluator evaluator = new PyTypeAssertionEvaluator(positive);
        condition.accept(evaluator);
        for (PyTypeAssertionEvaluator.Assertion def : evaluator.getDefinitions()) {
            PyReferenceExpression e = def.getElement();
            QualifiedName qname = e.asQualifiedName();
            String name2 = qname != null ? qname.toString() : e.getName();
            this.myBuilder.addNode((Instruction)ReadWriteInstruction.assertType(this.myBuilder, (PsiElement)e, name2, def.getTypeEvalFunction()));
        }
    }

    private TransparentInstruction addTransparentInstruction() {
        TransparentInstructionImpl instruction = new TransparentInstructionImpl(this.myBuilder, null, "");
        this.myBuilder.instructions.add(instruction);
        return instruction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueNode";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "falseNode";
                break;
            }
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementPart";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildControlFlow";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFunction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDecoratorList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPyElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCallExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitPySubscriptionExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReferenceExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBoolLiteralExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNoneLiteralExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeDeclarationStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDelStatement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAugAssignmentStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTargetExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitPyNamedParameter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAnnotation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitPyImportStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitPyFromImportStatement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStarImportElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitPyConditionalExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitPyMatchStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCaseClause";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitWildcardPattern";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitPyPattern";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitPyOrPattern";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitPyClassPattern";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitPyValuePattern";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAsPattern";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitPyGroupPattern";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitPyIfStatement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitPyPrefixExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBinaryExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitPyWhileStatement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitPyForStatement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loopHasAtLeastOneIteration";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitPyBreakStatement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitPyContinueStatement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitPyYieldExpression";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitPyRaiseStatement";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitPyReturnStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTryExceptStatement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitPyComprehensionElement";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssertStatement";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitPyLambdaExpression";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitPyWithStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitPyAssignmentExpression";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitPyTypeAliasStatement";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitCondition";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isLogicalExpression";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addConditionalNode";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitPyStatementPart";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "canRaiseExceptions";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addTypeAssertionNodes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private record TrueFalseNodes(@NotNull Instruction trueNode, @NotNull Instruction falseNode) {
        @NotNull
        private final Instruction trueNode;
        @NotNull
        private final Instruction falseNode;

        private TrueFalseNodes(@NotNull Instruction trueNode, @NotNull Instruction falseNode) {
            if (trueNode == null) {
                TrueFalseNodes.$$$reportNull$$$0(0);
            }
            if (falseNode == null) {
                TrueFalseNodes.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Instruction trueNode() {
            Instruction instruction = this.trueNode;
            if (instruction == null) {
                TrueFalseNodes.$$$reportNull$$$0(2);
            }
            return instruction;
        }

        @NotNull
        public Instruction falseNode() {
            Instruction instruction = this.falseNode;
            if (instruction == null) {
                TrueFalseNodes.$$$reportNull$$$0(3);
            }
            return instruction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "falseNode";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder$TrueFalseNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyControlFlowBuilder$TrueFalseNodes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trueNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "falseNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

