/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.PyWithContextExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class PyDataFlow {
    private final TypeEvalContext myTypeEvalContext;
    private final Instruction[] myInstructions;
    private final boolean[] myReachability;

    public PyDataFlow(@NotNull ControlFlow controlFlow, @NotNull TypeEvalContext context) {
        if (controlFlow == null) {
            PyDataFlow.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyDataFlow.$$$reportNull$$$0(1);
        }
        this.myTypeEvalContext = context;
        this.myInstructions = controlFlow.getInstructions();
        this.myReachability = new boolean[this.myInstructions.length];
        this.buildReachability();
    }

    private void buildReachability() {
        ArrayDeque<Instruction> toBeProcessed = new ArrayDeque<Instruction>();
        toBeProcessed.add(this.myInstructions[0]);
        while (!toBeProcessed.isEmpty()) {
            Instruction instruction = (Instruction)toBeProcessed.poll();
            this.myReachability[instruction.num()] = true;
            for (Instruction successor : this.getReachableSuccessors(instruction)) {
                if (this.myReachability[successor.num()]) continue;
                toBeProcessed.add(successor);
            }
        }
    }

    @NotNull
    private Collection<Instruction> getReachableSuccessors(@NotNull Instruction instruction) {
        PyWithContextExitInstruction wi;
        CallInstruction ci;
        if (instruction == null) {
            PyDataFlow.$$$reportNull$$$0(2);
        }
        if (instruction instanceof CallInstruction && (ci = (CallInstruction)instruction).isNoReturnCall(this.myTypeEvalContext)) {
            List<Instruction> list = List.of();
            if (list == null) {
                PyDataFlow.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (instruction instanceof PyWithContextExitInstruction && !(wi = (PyWithContextExitInstruction)instruction).isSuppressingExceptions(this.myTypeEvalContext)) {
            List<Instruction> list = List.of();
            if (list == null) {
                PyDataFlow.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection collection = instruction.allSucc();
        if (collection == null) {
            PyDataFlow.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public boolean isUnreachable(@NotNull Instruction instruction) {
        if (instruction == null) {
            PyDataFlow.$$$reportNull$$$0(6);
        }
        return !this.myReachability[instruction.num()];
    }

    public static boolean isUnreachable(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        ScopeOwner scope;
        if (element == null) {
            PyDataFlow.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyDataFlow.$$$reportNull$$$0(8);
        }
        if ((scope = ScopeUtil.getScopeOwner(element)) != null) {
            Instruction[] flow = ControlFlowCache.getControlFlow(scope).getInstructions();
            int idx = ControlFlowUtil.findInstructionNumberByElement((Instruction[])flow, (PsiElement)element);
            if (idx < 0) {
                return false;
            }
            return ControlFlowCache.getDataFlow(scope, context).isUnreachable(flow[idx]);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/controlflow/PyDataFlow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/controlflow/PyDataFlow";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachableSuccessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReachableSuccessors";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

