/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.impl.InstructionImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.controlflow.InstructionTypeCallback;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReadWriteInstruction
extends InstructionImpl {
    private final String myName;
    private final ACCESS myAccess;
    private final InstructionTypeCallback myGetType;

    private static InstructionTypeCallback instructionTypeCallback(@Nullable PsiElement element) {
        InstructionTypeCallback instructionTypeCallback;
        if (element instanceof PyExpression) {
            PyExpression expression = (PyExpression)element;
            instructionTypeCallback = context -> Ref.create((Object)context.getType(expression));
        } else {
            instructionTypeCallback = context -> Ref.create(null);
        }
        return instructionTypeCallback;
    }

    private ReadWriteInstruction(ControlFlowBuilder builder, PsiElement element, String name2, ACCESS access) {
        this(builder, element, name2, access, null);
    }

    private ReadWriteInstruction(ControlFlowBuilder builder, PsiElement element, String name2, ACCESS access, @Nullable InstructionTypeCallback getType) {
        super(builder, element);
        this.myName = name2;
        this.myAccess = access;
        this.myGetType = getType != null ? getType : ReadWriteInstruction.instructionTypeCallback(element);
    }

    public String getName() {
        return this.myName;
    }

    public ACCESS getAccess() {
        return this.myAccess;
    }

    public static ReadWriteInstruction read(ControlFlowBuilder builder, PyElement element, String name2) {
        return new ReadWriteInstruction(builder, (PsiElement)element, name2, ACCESS.READ);
    }

    public static ReadWriteInstruction write(ControlFlowBuilder builder, PyElement element, String name2) {
        return new ReadWriteInstruction(builder, (PsiElement)element, name2, ACCESS.WRITE);
    }

    public static ReadWriteInstruction newInstruction(ControlFlowBuilder builder, PsiElement element, String name2, ACCESS access) {
        return new ReadWriteInstruction(builder, element, name2, access);
    }

    public static ReadWriteInstruction assertType(ControlFlowBuilder builder, PsiElement element, String name2, InstructionTypeCallback getType) {
        return new ReadWriteInstruction(builder, element, name2, ACCESS.ASSERTTYPE, getType);
    }

    @Nullable
    public Ref<PyType> getType(TypeEvalContext context, @Nullable PsiElement anchor) {
        return this.myGetType.getType(context);
    }

    @NotNull
    @NonNls
    public String getElementPresentation() {
        String string = this.myAccess + " ACCESS: " + this.myName;
        if (string == null) {
            ReadWriteInstruction.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/controlflow/ReadWriteInstruction", "getElementPresentation"));
    }

    public static enum ACCESS {
        READ(true, false, false, false),
        WRITE(false, true, false, false),
        ASSERTTYPE(false, false, true, false),
        READWRITE(true, true, false, false),
        DELETE(false, false, false, true);

        private final boolean isWrite;
        private final boolean isRead;
        private final boolean isAssertType;
        private final boolean isDelete;

        private ACCESS(boolean read, boolean write, boolean assertType, boolean delete) {
            this.isRead = read;
            this.isWrite = write;
            this.isAssertType = assertType;
            this.isDelete = delete;
        }

        public boolean isWriteAccess() {
            return this.isWrite;
        }

        public boolean isReadAccess() {
            return this.isRead;
        }

        public boolean isAssertTypeAccess() {
            return this.isAssertType;
        }

        public boolean isDeleteAccess() {
            return this.isDelete;
        }
    }
}

