/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharIntAssociativeContainer;
import com.carrotsearch.hppc.CharIntMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharIntCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.CharIntPredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.CharIntProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharIntHashMap
implements CharIntMap,
Preallocable,
Cloneable,
Accountable {
    public char[] keys;
    public int[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public CharIntHashMap() {
        this(4);
    }

    public CharIntHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharIntHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public CharIntHashMap(CharIntAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int put(char key2, int value) {
        char existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key2 == '\u0000') {
            this.hasEmptyKey = true;
            int previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                int previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key2, value);
        } else {
            keys[slot] = key2;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(CharIntAssociativeContainer container) {
        int count = this.size();
        for (CharIntCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends CharIntCursor> iterable) {
        int count = this.size();
        for (CharIntCursor charIntCursor : iterable) {
            this.put(charIntCursor.key, charIntCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public int putOrAdd(char key2, int putValue, int incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key2);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key2, putValue);
        }
        return putValue;
    }

    @Override
    public int addTo(char key2, int incrementValue) {
        return this.putOrAdd(key2, incrementValue, incrementValue);
    }

    @Override
    public int remove(char key2) {
        char existing;
        int mask = this.mask;
        if (key2 == '\u0000') {
            this.hasEmptyKey = false;
            int previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                int previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int removeAll(CharContainer other) {
        int before2 = this.size();
        if (other.size() >= this.size() && other instanceof CharLookupContainer) {
            if (this.hasEmptyKey && other.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            char[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                char existing = keys[slot];
                if (existing != '\u0000' && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (CharCursor c : other) {
                this.remove(c.value);
            }
        }
        return before2 - this.size();
    }

    @Override
    public int removeAll(CharIntPredicate predicate) {
        int before2 = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply('\u0000', this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        char[] keys = this.keys;
        int[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before2 - this.size();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before2 = this.size();
        if (this.hasEmptyKey && predicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        char[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before2 - this.size();
    }

    @Override
    public int get(char key2) {
        char existing;
        if (key2 == '\u0000') {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int getOrDefault(char key2, int defaultValue) {
        char existing;
        if (key2 == '\u0000') {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(char key2) {
        char existing;
        if (key2 == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(char key2) {
        char existing;
        int mask = this.mask;
        if (key2 == '\u0000') {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public int indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public int indexReplace(int index, int newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        int previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, char key2, int value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key2 == '\u0000') {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == '\u0000');
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key2, value);
            } else {
                this.keys[index] = key2;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        int previousValue = this.values[index];
        if (index > this.mask) {
            this.hasEmptyKey = false;
            this.values[index] = 0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (CharIntCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((CharIntHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(CharIntHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (CharIntCursor c : other) {
            char key2 = c.key;
            if (this.containsKey(key2) && c.value == this.get(key2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            char[] prevKeys = this.keys;
            int[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size());
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<CharIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharIntProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        int[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply('\u0000', values[this.mask + 1]);
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (keys[slot] != '\u0000') {
                procedure.apply(keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends CharIntPredicate> T forEach(T predicate) {
        char[] keys = this.keys;
        int[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply('\u0000', values[this.mask + 1])) {
            return predicate;
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (keys[slot] == '\u0000' || predicate.apply(keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public IntCollection values() {
        return new ValuesContainer();
    }

    public CharIntHashMap clone() {
        try {
            CharIntHashMap cloned = (CharIntHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.nextIterationSeed();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static CharIntHashMap from(char[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharIntHashMap map = new CharIntHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(char key2) {
        assert (key2 != '\u0000');
        return BitMixer.mixPhi(key2);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(char[] fromKeys, int[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        char[] keys = this.keys;
        int[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            char existing = fromKeys[from];
            if (existing == '\u0000') continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        char[] prevKeys = this.keys;
        int[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new char[arraySize + emptyElementSlot];
            this.values = new int[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, char pendingKey, int pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == '\u0000' && pendingKey != '\u0000');
        char[] prevKeys = this.keys;
        int[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        char existing;
        char[] keys = this.keys;
        int[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != '\u0000') {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        values[gapSlot] = 0;
        --this.assigned;
    }

    private final class EntryIterator
    extends AbstractIterator<CharIntCursor> {
        private final CharIntCursor cursor = new CharIntCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = CharIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharIntHashMap.this.mask;
        }

        @Override
        protected CharIntCursor fetch() {
            int mask = CharIntHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharIntHashMap.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = CharIntHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && CharIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = '\u0000';
                this.cursor.value = CharIntHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (CharIntCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharIntHashMap owner;

        public KeysContainer() {
            this.owner = CharIntHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(char e) {
            if (this.owner.containsKey(e)) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final CharIntHashMap owner;

        private ValuesContainer() {
            this.owner = CharIntHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            for (CharIntCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            for (CharIntCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            for (CharIntCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(int e) {
            return this.owner.removeAll((char key2, int value) -> e == value);
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll((char key2, int value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = CharIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharIntHashMap.this.mask;
        }

        @Override
        protected IntCursor fetch() {
            int mask = CharIntHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (CharIntHashMap.this.keys[this.slot] == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = CharIntHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && CharIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = CharIntHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = CharIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharIntHashMap.this.mask;
        }

        @Override
        protected CharCursor fetch() {
            int mask = CharIntHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharIntHashMap.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && CharIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = '\u0000';
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

