/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.terminal.backend.StateAwareTerminalSession;
import com.intellij.terminal.session.TerminalBlocksModelState;
import com.intellij.terminal.session.TerminalCommandFinishedEvent;
import com.intellij.terminal.session.TerminalCommandStartedEvent;
import com.intellij.terminal.session.TerminalContentUpdatedEvent;
import com.intellij.terminal.session.TerminalCursorPositionChangedEvent;
import com.intellij.terminal.session.TerminalInitialStateEvent;
import com.intellij.terminal.session.TerminalInputEvent;
import com.intellij.terminal.session.TerminalOutputEvent;
import com.intellij.terminal.session.TerminalOutputModelState;
import com.intellij.terminal.session.TerminalPromptFinishedEvent;
import com.intellij.terminal.session.TerminalPromptStartedEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalState;
import com.intellij.terminal.session.TerminalStateChangedEvent;
import com.intellij.terminal.session.dto.StyleRangeDto;
import com.intellij.terminal.session.dto.StyleRangeDtoKt;
import com.intellij.terminal.session.dto.TerminalBlocksModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalOutputModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalStateDto;
import com.intellij.terminal.session.dto.TerminalStateDtoKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModelImpl;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/terminal/backend/StateAwareTerminalSession;", "Lcom/intellij/terminal/session/TerminalSession;", "delegate", "<init>", "(Lcom/intellij/terminal/session/TerminalSession;)V", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "alternateBufferModel", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "getInputChannel", "Lkotlinx/coroutines/channels/SendChannel;", "Lcom/intellij/terminal/session/TerminalInputEvent;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOutputFlow", "Lkotlinx/coroutines/flow/Flow;", "", "Lcom/intellij/terminal/session/TerminalOutputEvent;", "isClosed", "", "()Z", "doHandleEvents", "", "events", "handleEvent", "event", "createInitialStateEvent", "Lcom/intellij/terminal/session/TerminalInitialStateEvent;", "getCurrentOutputModel", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nStateAwareTerminalSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateAwareTerminalSession.kt\ncom/intellij/terminal/backend/StateAwareTerminalSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n25#2:126\n1557#3:127\n1628#3,3:128\n*S KotlinDebug\n*F\n+ 1 StateAwareTerminalSession.kt\ncom/intellij/terminal/backend/StateAwareTerminalSession\n*L\n75#1:126\n83#1:127\n83#1:128,3\n*E\n"})
public final class StateAwareTerminalSession
implements TerminalSession {
    @NotNull
    private final TerminalSession delegate;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalOutputModel alternateBufferModel;
    @NotNull
    private final TerminalBlocksModel blocksModel;

    public StateAwareTerminalSession(@NotNull TerminalSession delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.sessionModel = new TerminalSessionModelImpl();
        DocumentImpl outputDocument = new DocumentImpl((CharSequence)"", true);
        this.outputModel = new TerminalOutputModelImpl((Document)outputDocument, TerminalUiUtils.INSTANCE.getDefaultMaxOutputLength());
        DocumentImpl alternateBufferDocument = new DocumentImpl((CharSequence)"", true);
        this.alternateBufferModel = new TerminalOutputModelImpl((Document)alternateBufferDocument, 0);
        this.blocksModel = new TerminalBlocksModelImpl((Document)outputDocument);
    }

    @Nullable
    public Object getInputChannel(@NotNull Continuation<? super SendChannel<? super TerminalInputEvent>> $completion) {
        return this.delegate.getInputChannel($completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object getOutputFlow(@NotNull Continuation<? super Flow<? extends List<? extends TerminalOutputEvent>>> $completion) {
        if (!($completion instanceof getOutputFlow.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StateAwareTerminalSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getOutputFlow((Continuation<? super Flow<? extends List<? extends TerminalOutputEvent>>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.delegate.getOutputFlow((Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (StateAwareTerminalSession)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                originalFlow = (Flow)v0;
                modelsAwareFlow = FlowKt.onEach((Flow)originalFlow, (Function2)((Function2)new Function2<List<? extends TerminalOutputEvent>, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ StateAwareTerminalSession this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                List it = (List)this.L$0;
                                StateAwareTerminalSession.access$doHandleEvents(this.this$0, it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(List<? extends TerminalOutputEvent> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                initialStateEvent = this.createInitialStateEvent();
                initialStateEventFlow = FlowKt.flowOf((Object)CollectionsKt.listOf((Object)initialStateEvent));
                var6_9 = new Flow[]{initialStateEventFlow, modelsAwareFlow};
                return FlowKt.flattenConcat((Flow)FlowKt.flowOf((Object[])var6_9));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    private final void doHandleEvents(List<? extends TerminalOutputEvent> events) {
        for (TerminalOutputEvent terminalOutputEvent : events) {
            try {
                this.handleEvent(terminalOutputEvent);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Throwable t) {
                StateAwareTerminalSession $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(StateAwareTerminalSession.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(t);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleEvent(TerminalOutputEvent event) {
        TerminalOutputEvent terminalOutputEvent = event;
        if (terminalOutputEvent instanceof TerminalContentUpdatedEvent) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((TerminalContentUpdatedEvent)event).getStyles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StyleRangeDto styleRangeDto = (StyleRangeDto)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StyleRangeDtoKt.toStyleRange((StyleRangeDto)it));
            }
            List styles = (List)destination$iv$iv;
            TerminalOutputModel model = this.getCurrentOutputModel();
            model.updateContent(((TerminalContentUpdatedEvent)event).getStartLineLogicalIndex(), ((TerminalContentUpdatedEvent)event).getText(), styles);
        } else if (terminalOutputEvent instanceof TerminalCursorPositionChangedEvent) {
            TerminalOutputModel model = this.getCurrentOutputModel();
            model.updateCursorPosition(((TerminalCursorPositionChangedEvent)event).getLogicalLineIndex(), ((TerminalCursorPositionChangedEvent)event).getColumnIndex());
        } else if (terminalOutputEvent instanceof TerminalStateChangedEvent) {
            TerminalState state = TerminalStateDtoKt.toTerminalState((TerminalStateDto)((TerminalStateChangedEvent)event).getState());
            this.sessionModel.updateTerminalState(state);
        } else if (Intrinsics.areEqual((Object)terminalOutputEvent, (Object)TerminalPromptStartedEvent.INSTANCE)) {
            this.blocksModel.promptStarted(((Number)this.outputModel.getCursorOffsetState().getValue()).intValue());
        } else if (Intrinsics.areEqual((Object)terminalOutputEvent, (Object)TerminalPromptFinishedEvent.INSTANCE)) {
            this.blocksModel.promptFinished(((Number)this.outputModel.getCursorOffsetState().getValue()).intValue());
        } else if (terminalOutputEvent instanceof TerminalCommandStartedEvent) {
            this.blocksModel.commandStarted(((Number)this.outputModel.getCursorOffsetState().getValue()).intValue());
        } else if (terminalOutputEvent instanceof TerminalCommandFinishedEvent) {
            this.blocksModel.commandFinished(((TerminalCommandFinishedEvent)event).getExitCode());
        }
    }

    private final TerminalInitialStateEvent createInitialStateEvent() {
        return new TerminalInitialStateEvent(TerminalStateDtoKt.toDto((TerminalState)((TerminalState)this.sessionModel.getTerminalState().getValue())), TerminalOutputModelStateDtoKt.toDto((TerminalOutputModelState)this.outputModel.dumpState()), TerminalOutputModelStateDtoKt.toDto((TerminalOutputModelState)this.alternateBufferModel.dumpState()), TerminalBlocksModelStateDtoKt.toDto((TerminalBlocksModelState)this.blocksModel.dumpState()));
    }

    private final TerminalOutputModel getCurrentOutputModel() {
        return ((TerminalState)this.sessionModel.getTerminalState().getValue()).isAlternateScreenBuffer() ? this.alternateBufferModel : this.outputModel;
    }

    public static final /* synthetic */ void access$doHandleEvents(StateAwareTerminalSession $this, List events) {
        $this.doHandleEvents(events);
    }
}

