/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.session.TerminalClearBufferEvent;
import com.intellij.terminal.session.TerminalInputEvent;
import com.intellij.terminal.session.TerminalResizeEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalState;
import com.intellij.terminal.session.TerminalWriteBytesEvent;
import com.intellij.terminal.session.dto.TerminalSizeDtoKt;
import com.jediterm.core.util.TermSize;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ClosedSendChannelException;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/terminal/frontend/TerminalInput;", "", "terminalSessionFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/terminal/session/TerminalSession;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Ljava/util/concurrent/CompletableFuture;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lkotlinx/coroutines/CoroutineScope;)V", "bufferChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/terminal/session/TerminalInputEvent;", "inputChannelDeferred", "Lkotlinx/coroutines/Deferred;", "Lkotlinx/coroutines/channels/SendChannel;", "sendString", "", "data", "", "sendBracketedString", "sendBytes", "", "sendClearBuffer", "sendResize", "newSize", "Lcom/jediterm/core/util/TermSize;", "sendEvent", "event", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalInput.kt\ncom/intellij/terminal/frontend/TerminalInput\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n15#2:104\n*S KotlinDebug\n*F\n+ 1 TerminalInput.kt\ncom/intellij/terminal/frontend/TerminalInput\n*L\n27#1:104\n*E\n"})
public final class TerminalInput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletableFuture<TerminalSession> terminalSessionFuture;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final Channel<TerminalInputEvent> bufferChannel;
    @NotNull
    private final Deferred<SendChannel<TerminalInputEvent>> inputChannelDeferred;
    @NotNull
    private static final DataKey<TerminalInput> KEY = DataKey.Companion.create("TerminalInput");
    @NotNull
    private static final Logger LOG;

    public TerminalInput(@NotNull CompletableFuture<TerminalSession> terminalSessionFuture, @NotNull TerminalSessionModel sessionModel, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(terminalSessionFuture, (String)"terminalSessionFuture");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.terminalSessionFuture = terminalSessionFuture;
        this.sessionModel = sessionModel;
        this.bufferChannel = ChannelKt.Channel$default((int)10000, (BufferOverflow)BufferOverflow.DROP_OLDEST, null, (int)4, null);
        this.inputChannelDeferred = BuildersKt.async$default((CoroutineScope)coroutineScope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("Get input channel")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SendChannel<? super TerminalInputEvent>>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalInput this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = FutureKt.await((CompletionStage)TerminalInput.access$getTerminalSessionFuture$p(this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((TerminalSession)v0).getInputChannel((Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SendChannel<? super TerminalInputEvent>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Job job2 = BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ TerminalInput this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = TerminalInput.access$getInputChannelDeferred$p(this.this$0).await((Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        targetChannel = (SendChannel)v0;
                        try {
                            var3_4 = TerminalInput.access$getBufferChannel$p(this.this$0).iterator();
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        catch (ClosedSendChannelException e) {
                            TerminalInput.access$getLOG$cp().warn("Failed to send the event because input channel is closed");
                            return Unit.INSTANCE;
                        }
                        catch (Throwable t) {
                            TerminalInput.access$getLOG$cp().error("Error while sending input event", t);
                            return Unit.INSTANCE;
                        }
lbl26:
                        // 3 sources

                        while (true) {
                            this.L$0 = targetChannel;
                            this.L$1 = var3_4;
                            this.label = 2;
                            v1 = var3_4.hasNext((Continuation)this);
                            if (v1 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl40
                            break;
                        }
                    }
                    case 2: {
                        var3_4 = (ChannelIterator)this.L$1;
                        targetChannel = (SendChannel)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl40:
                            // 2 sources

                            if ((Boolean)v1 == false) return Unit.INSTANCE;
                            event = (TerminalInputEvent)var3_4.next();
                            this.L$0 = targetChannel;
                            this.L$1 = var3_4;
                            this.label = 3;
                            v2 = targetChannel.send((Object)event, (Continuation)this);
                            if (v2 != var5_2) ** GOTO lbl26
                        }
                        return var5_2;
                    }
                    case 3: {
                        var3_4 = (ChannelIterator)this.L$1;
                        targetChannel = (SendChannel)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            ** continue;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        job2.invokeOnCompletion(arg_0 -> TerminalInput._init_$lambda$0(this, arg_0));
    }

    public final void sendString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.sendBytes(byArray);
    }

    public final void sendBracketedString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (((TerminalState)this.sessionModel.getTerminalState().getValue()).isBracketedPasteMode()) {
            this.sendString("\u001b[200~" + data + "\u001b[201~");
        } else {
            this.sendString(data);
        }
    }

    public final void sendBytes(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.sendEvent((TerminalInputEvent)new TerminalWriteBytesEvent(data));
    }

    public final void sendClearBuffer() {
        this.sendEvent((TerminalInputEvent)TerminalClearBufferEvent.INSTANCE);
    }

    public final void sendResize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        if ((TerminalSession)this.terminalSessionFuture.getNow(null) == null) {
            return;
        }
        this.sendEvent((TerminalInputEvent)new TerminalResizeEvent(TerminalSizeDtoKt.toDto((TermSize)newSize)));
    }

    private final void sendEvent(TerminalInputEvent event) {
        Object result = this.bufferChannel.trySend-JP2dKIU((Object)event);
        if (ChannelResult.isClosed-impl((Object)result)) {
            LOG.warn("Terminal input channel is closed, " + event + " won't be sent", ChannelResult.exceptionOrNull-impl((Object)result));
        } else if (ChannelResult.isFailure-impl((Object)result)) {
            LOG.error("Failed to send input event: " + event, ChannelResult.exceptionOrNull-impl((Object)result));
        }
    }

    private static final Unit _init_$lambda$0(TerminalInput this$0, Throwable it) {
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this$0.bufferChannel), null, (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CompletableFuture access$getTerminalSessionFuture$p(TerminalInput $this) {
        return $this.terminalSessionFuture;
    }

    public static final /* synthetic */ Deferred access$getInputChannelDeferred$p(TerminalInput $this) {
        return $this.inputChannelDeferred;
    }

    public static final /* synthetic */ Channel access$getBufferChannel$p(TerminalInput $this) {
        return $this.bufferChannel;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalInput.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/terminal/frontend/TerminalInput$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/terminal/frontend/TerminalInput;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalInput> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

