/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.font.FontRenderContext;
import java.awt.geom.Dimension2D;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.ui.Dimension2DDouble;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0007\u001a,\u0010\n\u001a\u00020\u00012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a,\u0010\u0012\u001a\u00020\u00012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u0007H\u0000\u001a-\u0010\u0014\u001a\u0002H\u0015\"\u0006\b\u0000\u0010\u0015\u0018\u0001*\u00020\u00162\u000e\b\u0004\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\fH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u001a)\u0010\"\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00150\fH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\u001a)\u0010%\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00150\fH\u0081\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\u001a)\u0010&\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00150\fH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\u001a\f\u0010'\u001a\u00020\u0001*\u00020\u0007H\u0001\u001a\u0010\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0000\u001a\f\u0010+\u001a\u00020,*\u00020-H\u0000\u001a\f\u0010.\u001a\u00020/*\u000200H\u0007\u001a/\u00101\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002H\u001504H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105\u001a\u001a\u00106\u001a\u00020\u0001*\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020/\u001a\u0014\u0010;\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010<\u001a\u00020\rH\u0007\u001a\u0014\u0010=\u001a\u0004\u0018\u00010,2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002\u001a\u0010\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u00020,H\u0007\"!\u0010\u0019\u001a\u0015\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00010\u00010\u001a\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\u001e\u001a\u00020\r*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\r8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006B"}, d2={"applyFontSettings", "", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "newSettings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "getCharSize", "Ljava/awt/geom/Dimension2D;", "Lcom/intellij/openapi/editor/Editor;", "calculateTerminalSize", "Lcom/jediterm/core/util/TermSize;", "invokeLater", "expired", "Lkotlin/Function0;", "", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "runnable", "Ljava/lang/Runnable;", "invokeLaterIfNeeded", "getDisposed", "executeInBulk", "T", "Lcom/intellij/openapi/editor/Document;", "block", "(Lcom/intellij/openapi/editor/Document;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "isTerminalOutputScrollChangingActionInProgress", "(Lcom/intellij/openapi/editor/Editor;)Z", "setTerminalOutputScrollChangingActionInProgress", "(Lcom/intellij/openapi/editor/Editor;Z)V", "doTerminalOutputScrollChangingAction", "action", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "doWithScrollingAware", "doWithoutScrollingAnimation", "scrollToBottom", "stickScrollBarToBottom", "verticalScrollBar", "Ljavax/swing/JScrollBar;", "normalize", "", "Lcom/jediterm/terminal/model/CharBuffer;", "getLengthWithoutDwc", "", "Lcom/jediterm/terminal/model/TerminalLine;", "withLock", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "callable", "Lkotlin/Function1;", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "addToLayer", "Lcom/intellij/ui/components/JBLayeredPane;", "component", "Ljavax/swing/JComponent;", "layer", "getClipboardText", "useSystemSelectionClipboardIfAvailable", "getTextContent", "content", "Ljava/awt/datatransfer/Transferable;", "sanitizeLineSeparators", "text", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,547:1\n425#1,7:549\n1#2:548\n507#3,5:556\n1104#3,3:563\n1797#4,2:561\n1799#4:566\n15#5:567\n*S KotlinDebug\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n*L\n437#1:549,7\n480#1:556,5\n486#1:563,3\n485#1:561,2\n485#1:566\n527#1:567\n*E\n"})
public final class TerminalUiUtilsKt {
    @NotNull
    private static final Key<Unit> TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY;

    public static final void applyFontSettings(@NotNull EditorImpl $this$applyFontSettings, @NotNull JBTerminalSystemSettingsProviderBase newSettings) {
        EditorColorsScheme editorColorsScheme;
        Intrinsics.checkNotNullParameter((Object)$this$applyFontSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        EditorColorsScheme $this$applyFontSettings_u24lambda_u240 = editorColorsScheme = $this$applyFontSettings.getColorsScheme();
        boolean bl = false;
        $this$applyFontSettings_u24lambda_u240.setEditorFontName(newSettings.getTerminalFont().getFontName());
        $this$applyFontSettings_u24lambda_u240.setEditorFontSize(newSettings.getTerminalFont().getSize2D());
        $this$applyFontSettings_u24lambda_u240.setLineSpacing(newSettings.getLineSpacing());
        EditorColorsScheme $this$applyFontSettings_u24lambda_u241 = editorColorsScheme = $this$applyFontSettings.getSettings();
        boolean bl2 = false;
        $this$applyFontSettings_u24lambda_u241.setCharacterGridWidthMultiplier(Float.valueOf(newSettings.getColumnSpacing()));
    }

    @NotNull
    public static final Dimension2D getCharSize(@NotNull Editor $this$getCharSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getCharSize, (String)"<this>");
        FontRenderContext baseContext = FontInfo.getFontRenderContext((Component)$this$getCharSize.getContentComponent());
        FontRenderContext context = new FontRenderContext(baseContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)true), UISettings.Companion.getEditorFractionalMetricsHint());
        FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)$this$getCharSize.getColorsScheme().getFont(EditorFontType.PLAIN), (FontRenderContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        FontMetrics fontMetrics2 = fontMetrics;
        float width = FontLayoutService.Companion.getInstance().charWidth2D(fontMetrics2, 37);
        Float f = $this$getCharSize.getSettings().getCharacterGridWidthMultiplier();
        float columnSpacing = f != null ? f.floatValue() : 1.0f;
        return new Dimension2DDouble((double)width * (double)columnSpacing, $this$getCharSize.getLineHeight());
    }

    @Nullable
    public static final TermSize calculateTerminalSize(@NotNull Editor $this$calculateTerminalSize) {
        TermSize termSize;
        Intrinsics.checkNotNullParameter((Object)$this$calculateTerminalSize, (String)"<this>");
        Dimension contentSize = $this$calculateTerminalSize.getScrollingModel().getVisibleArea().getSize();
        Dimension2D charSize = TerminalUiUtilsKt.getCharSize($this$calculateTerminalSize);
        if (contentSize.width > 0 && contentSize.height > 0) {
            Intrinsics.checkNotNull((Object)contentSize);
            termSize = TerminalUiUtils.INSTANCE.calculateTerminalSize(contentSize, charSize);
        } else {
            termSize = null;
        }
        return termSize;
    }

    public static final void invokeLater(@Nullable Function0<Boolean> expired, @NotNull ModalityState modalityState, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (expired != null) {
            ApplicationManager.getApplication().invokeLater(runnable, modalityState, arg_0 -> TerminalUiUtilsKt.invokeLater$lambda$2(expired, arg_0));
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, modalityState);
        }
    }

    public static /* synthetic */ void invokeLater$default(Function0 function0, ModalityState modalityState, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        if ((n & 2) != 0) {
            modalityState = ModalityState.defaultModalityState();
        }
        TerminalUiUtilsKt.invokeLater((Function0<Boolean>)function0, modalityState, runnable);
    }

    public static final void invokeLaterIfNeeded(@Nullable Function0<Boolean> expired, @NotNull ModalityState modalityState, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            TerminalUiUtilsKt.invokeLater(expired, modalityState, runnable);
        }
    }

    public static /* synthetic */ void invokeLaterIfNeeded$default(Function0 function0, ModalityState modalityState, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        if ((n & 2) != 0) {
            modalityState = ModalityState.defaultModalityState();
        }
        TerminalUiUtilsKt.invokeLaterIfNeeded((Function0<Boolean>)function0, modalityState, runnable);
    }

    @NotNull
    public static final Function0<Boolean> getDisposed(@NotNull Editor $this$getDisposed) {
        Intrinsics.checkNotNullParameter((Object)$this$getDisposed, (String)"<this>");
        return () -> TerminalUiUtilsKt.getDisposed$lambda$3($this$getDisposed);
    }

    public static final /* synthetic */ <T> T executeInBulk(Document $this$executeInBulk, Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)$this$executeInBulk, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$executeInBulk = false;
        Ref.ObjectRef result = new Ref.ObjectRef();
        DocumentUtil.executeInBulk((Document)$this$executeInBulk, (Runnable)new Runnable(result, block){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function0<T> $block;
            {
                this.$result = $result;
                this.$block = $block;
            }

            public final void run() {
                this.$result.element = this.$block.invoke();
            }
        });
        Object object = result.element;
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    @ApiStatus.Internal
    public static final boolean isTerminalOutputScrollChangingActionInProgress(@NotNull Editor $this$isTerminalOutputScrollChangingActionInProgress) {
        Intrinsics.checkNotNullParameter((Object)$this$isTerminalOutputScrollChangingActionInProgress, (String)"<this>");
        return $this$isTerminalOutputScrollChangingActionInProgress.getUserData(TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY) != null;
    }

    @ApiStatus.Internal
    public static final void setTerminalOutputScrollChangingActionInProgress(@NotNull Editor $this$isTerminalOutputScrollChangingActionInProgress, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$isTerminalOutputScrollChangingActionInProgress, (String)"<this>");
        $this$isTerminalOutputScrollChangingActionInProgress.putUserData(TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY, value ? Unit.INSTANCE : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static final <T> T doTerminalOutputScrollChangingAction(@NotNull Editor $this$doTerminalOutputScrollChangingAction, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$doTerminalOutputScrollChangingAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$doTerminalOutputScrollChangingAction = false;
        TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress($this$doTerminalOutputScrollChangingAction, true);
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            TerminalUiUtilsKt.setTerminalOutputScrollChangingActionInProgress($this$doTerminalOutputScrollChangingAction, false);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public static final <T> T doWithScrollingAware(@NotNull Editor $this$doWithScrollingAware, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$doWithScrollingAware, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$doWithScrollingAware = false;
        Rectangle it = $this$doWithScrollingAware.getScrollingModel().getVisibleArea();
        boolean bl = false;
        boolean wasAtBottom = it.y + it.height == $this$doWithScrollingAware.getContentComponent().getHeight();
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            if (wasAtBottom) {
                TerminalUiUtilsKt.scrollToBottom($this$doWithScrollingAware);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @RequiresEdt
    public static final <T> T doWithoutScrollingAnimation(@NotNull Editor $this$doWithoutScrollingAnimation, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$doWithoutScrollingAnimation, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$doWithoutScrollingAnimation = false;
        $this$doWithoutScrollingAnimation.getScrollingModel().disableAnimation();
        try {
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$doWithoutScrollingAnimation.getScrollingModel().enableAnimation();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public static final void scrollToBottom(@NotNull Editor $this$scrollToBottom) {
        Intrinsics.checkNotNullParameter((Object)$this$scrollToBottom, (String)"<this>");
        Editor $this$doWithoutScrollingAnimation$iv = $this$scrollToBottom;
        boolean $i$f$doWithoutScrollingAnimation = false;
        $this$doWithoutScrollingAnimation$iv.getScrollingModel().disableAnimation();
        try {
            boolean bl = false;
            Rectangle rectangle = $this$scrollToBottom.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            $this$scrollToBottom.getScrollingModel().scrollVertically($this$scrollToBottom.getContentComponent().getHeight() - visibleArea.height);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$doWithoutScrollingAnimation$iv.getScrollingModel().enableAnimation();
        }
    }

    public static final void stickScrollBarToBottom(@NotNull JScrollBar verticalScrollBar) {
        Intrinsics.checkNotNullParameter((Object)verticalScrollBar, (String)"verticalScrollBar");
        verticalScrollBar.getModel().addChangeListener(new ChangeListener(verticalScrollBar){
            private boolean preventRecursion;
            private int prevValue;
            private int prevMaximum;
            private int prevExtent;
            final /* synthetic */ JScrollBar $verticalScrollBar;
            {
                this.$verticalScrollBar = $verticalScrollBar;
            }

            public final boolean getPreventRecursion() {
                return this.preventRecursion;
            }

            public final void setPreventRecursion(boolean bl) {
                this.preventRecursion = bl;
            }

            public final int getPrevValue() {
                return this.prevValue;
            }

            public final void setPrevValue(int n) {
                this.prevValue = n;
            }

            public final int getPrevMaximum() {
                return this.prevMaximum;
            }

            public final void setPrevMaximum(int n) {
                this.prevMaximum = n;
            }

            public final int getPrevExtent() {
                return this.prevExtent;
            }

            public final void setPrevExtent(int n) {
                this.prevExtent = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (this.preventRecursion) {
                    return;
                }
                BoundedRangeModel model = this.$verticalScrollBar.getModel();
                int maximum = model.getMaximum();
                int extent = model.getExtent();
                if ((extent != this.prevExtent || maximum != this.prevMaximum) && this.prevValue == this.prevMaximum - this.prevExtent) {
                    this.preventRecursion = true;
                    try {
                        model.setValue(maximum - extent);
                    }
                    finally {
                        this.preventRecursion = false;
                    }
                }
                this.prevValue = model.getValue();
                this.prevMaximum = model.getMaximum();
                this.prevExtent = model.getExtent();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String normalize(@NotNull CharBuffer $this$normalize) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        String string2 = $this$normalize.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String s = string2;
        if (StringsKt.contains$default((CharSequence)s, (char)'\ue000', (boolean)false, (int)2, null)) {
            void var3_3;
            void $this$filterTo$iv;
            CharSequence charSequence = s;
            Appendable destination$iv = new StringBuilder(s.length() - 1);
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char element$iv;
                char it = element$iv = $this$filterTo$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != '\ue000')) continue;
                destination$iv.append(element$iv);
            }
            String string3 = ((StringBuilder)var3_3).toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        } else {
            string = s;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final int getLengthWithoutDwc(@NotNull TerminalLine $this$getLengthWithoutDwc) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getLengthWithoutDwc, (String)"<this>");
        List list = $this$getLengthWithoutDwc.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
        Iterable iterable = list;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            TerminalLine.TextEntry textEntry = (TerminalLine.TextEntry)element$iv;
            int curCount = accumulator$iv;
            boolean bl = false;
            CharBuffer charBuffer = entry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
            CharSequence $this$count$iv = (CharSequence)charBuffer;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv2;
                char it = element$iv2 = $this$count$iv.charAt(i);
                boolean bl2 = false;
                if (!(it == '\ue000')) continue;
                ++count$iv;
            }
            int dwcInEntryCount = count$iv;
            accumulator$iv = curCount + dwcInEntryCount;
        }
        int dwcCount = accumulator$iv;
        return $this$getLengthWithoutDwc.length() - dwcCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withLock(@NotNull TerminalTextBuffer $this$withLock, @NotNull Function1<? super TerminalTextBuffer, ? extends T> callable) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$withLock, (String)"<this>");
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        boolean $i$f$withLock = false;
        $this$withLock.lock();
        try {
            object = callable.invoke((Object)$this$withLock);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$withLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    public static final void addToLayer(@NotNull JBLayeredPane $this$addToLayer, @NotNull JComponent component2, int layer) {
        Intrinsics.checkNotNullParameter((Object)$this$addToLayer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Component component3 = component2;
        Intrinsics.checkNotNull((Object)layer, (String)"null cannot be cast to non-null type kotlin.Any");
        $this$addToLayer.add(component3, (Object)layer);
    }

    @ApiStatus.Internal
    @Nullable
    public static final String getClipboardText(boolean useSystemSelectionClipboardIfAvailable) {
        String text;
        if (useSystemSelectionClipboardIfAvailable && (text = TerminalUiUtilsKt.getTextContent(CopyPasteManager.getInstance().getSystemSelectionContents())) != null) {
            return text;
        }
        return TerminalUiUtilsKt.getTextContent(CopyPasteManager.getInstance().getContents());
    }

    public static /* synthetic */ String getClipboardText$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return TerminalUiUtilsKt.getClipboardText(bl);
    }

    private static final String getTextContent(Transferable content) {
        String string;
        if (content == null) {
            return null;
        }
        try {
            String string2;
            if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                Object object = content.getTransferData(DataFlavor.stringFlavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                string2 = (String)object;
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TerminalUiUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to get text from clipboard", t);
            return null;
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public static final String sanitizeLineSeparators(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String t = text;
        if (!SystemInfoRt.isWindows) {
            t = StringsKt.replace$default((String)text, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
        }
        return StringsKt.replace$default((String)t, (String)"\n", (String)"\r", (boolean)false, (int)4, null);
    }

    private static final boolean invokeLater$lambda$2(Function0 $expired, Object it) {
        return (Boolean)$expired.invoke();
    }

    private static final boolean getDisposed$lambda$3(Editor $this_getDisposed) {
        return $this_getDisposed.isDisposed();
    }

    static {
        Key key = Key.create((String)"TERMINAL_EDITOR_SIZE_CHANGING_ACTION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TERMINAL_OUTPUT_SCROLL_CHANGING_ACTION_KEY = key;
    }
}

