/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.fus;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.util.system.OS;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.fus.TerminalCommandUsageStatistics;
import org.jetbrains.plugins.terminal.fus.TerminalShellInfoStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J#\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0007\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0010H\u0007J-\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/terminal/fus/ReworkedTerminalUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "OS_VERSION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "SHELL_STR_FIELD", "EXIT_CODE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "EXECUTION_TIME_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "localShellStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "commandStartedEvent", "commandFinishedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "logLocalShellStarted", "", "project", "Lcom/intellij/openapi/project/Project;", "shellCommand", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)V", "logCommandStarted", "userCommandLine", "logCommandFinished", "exitCode", "", "executionTime", "Lkotlin/time/Duration;", "logCommandFinished-Wn2Vu4Y", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;IJ)V", "intellij.terminal"})
@ApiStatus.Internal
public final class ReworkedTerminalUsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final ReworkedTerminalUsageCollector INSTANCE = new ReworkedTerminalUsageCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("terminal", 1, null, 4, null);
    @NotNull
    private static final StringEventField OS_VERSION_FIELD = EventFields.StringValidatedByRegexpReference$default((String)"os-version", (String)"version", null, (int)4, null);
    @NotNull
    private static final StringEventField SHELL_STR_FIELD = EventFields.String((String)"shell", (List)CollectionsKt.toList((Iterable)TerminalShellInfoStatistics.INSTANCE.getKNOWN_SHELLS()));
    @NotNull
    private static final IntEventField EXIT_CODE_FIELD = EventFields.Int((String)"exit_code");
    @NotNull
    private static final LongEventField EXECUTION_TIME_FIELD = EventFields.Long((String)"execution_time", (String)"Time in milliseconds");
    @NotNull
    private static final EventId2<String, String> localShellStartedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"local.exec", (EventField)((EventField)OS_VERSION_FIELD), (EventField)((EventField)SHELL_STR_FIELD), null, (int)8, null);
    @NotNull
    private static final EventId2<String, String> commandStartedEvent = GROUP.registerEvent("terminal.command.executed", (EventField)TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal(), (EventField)TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal(), "Fired each time when command is started");
    @NotNull
    private static final VarargEventId commandFinishedEvent;

    private ReworkedTerminalUsageCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void logLocalShellStarted(@NotNull Project project, @NotNull String[] shellCommand) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        Object object = Version.parseVersion((String)OS.CURRENT.version);
        if (object == null || (object = object.toCompactString()) == null) {
            object = "unknown";
        }
        localShellStartedEvent.log(project, object, (Object)TerminalShellInfoStatistics.INSTANCE.getShellNameForStat((String)ArraysKt.firstOrNull((Object[])shellCommand)));
    }

    @JvmStatic
    public static final void logCommandStarted(@NotNull Project project, @NotNull String userCommandLine) {
        TerminalCommandUsageStatistics.CommandData commandData;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
        TerminalCommandUsageStatistics.CommandData commandData2 = commandData = TerminalCommandUsageStatistics.INSTANCE.getLoggableCommandData(userCommandLine);
        TerminalCommandUsageStatistics.CommandData commandData3 = commandData;
        commandStartedEvent.log(project, (Object)(commandData2 != null ? commandData2.getCommand() : null), (Object)(commandData3 != null ? commandData3.getSubCommand() : null));
    }

    public final void logCommandFinished-Wn2Vu4Y(@NotNull Project project, @NotNull String userCommandLine, int exitCode, long executionTime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
        TerminalCommandUsageStatistics.CommandData commandData = TerminalCommandUsageStatistics.INSTANCE.getLoggableCommandData(userCommandLine);
        EventPair[] eventPairArray = new EventPair[4];
        TerminalCommandUsageStatistics.CommandData commandData2 = commandData;
        eventPairArray[0] = TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal().with((Object)(commandData2 != null ? commandData2.getCommand() : null));
        TerminalCommandUsageStatistics.CommandData commandData3 = commandData;
        eventPairArray[1] = TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal().with((Object)(commandData3 != null ? commandData3.getSubCommand() : null));
        eventPairArray[2] = EXIT_CODE_FIELD.with((Object)exitCode);
        eventPairArray[3] = EXECUTION_TIME_FIELD.with((Object)Duration.getInWholeMilliseconds-impl((long)executionTime));
        commandFinishedEvent.log(project, eventPairArray);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal(), TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal(), EXIT_CODE_FIELD, EXECUTION_TIME_FIELD};
        commandFinishedEvent = GROUP.registerVarargEvent("terminal.command.finished", "Fired each time when command is finished", eventFieldArray);
    }
}

