/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitConfigurationCache;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableDetector {
    private static final Logger LOG = Logger.getInstance(GitExecutableDetector.class);
    @NonNls
    private static final String[] UNIX_PATHS = new String[]{"/usr/local/bin", "/opt/local/bin", "/usr/bin", "/opt/bin", "/usr/local/git/bin"};
    @NonNls
    private static final String[] APPLEGIT_PATHS = new String[]{"/usr/bin/git"};
    @NonNls
    private static final String[] APPLEGIT_DEPENDENCY_PATHS = new String[]{"/Library/Developer/CommandLineTools/usr/bin/git", "/Library/Preferences/com.apple.dt.Xcode"};
    private static final List<String> WIN_BIN_DIRS = Arrays.asList("cmd", "bin");
    @NonNls
    private static final String UNIX_EXECUTABLE = "git";
    @NonNls
    private static final String WIN_EXECUTABLE = "git.exe";
    private static final int WSL_DETECTION_TIMEOUT_MS = 10000;
    private final ScheduledExecutorService myWslExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"GitExecutableDetector WSL thread", (int)1);
    @NotNull
    private final Object DETECTED_EXECUTABLE_LOCK = new Object();
    @NotNull
    private final AtomicReference<DetectionResult> myEnvExecutable = new AtomicReference();
    @NotNull
    private final AtomicReference<DetectionResult> mySystemExecutable = new AtomicReference();
    @NotNull
    private final Map<WSLDistribution, DetectionResult> myWslExecutables = new ConcurrentHashMap<WSLDistribution, DetectionResult>();
    private volatile boolean myWslDistributionsProcessed;

    @NotNull
    public static String getDefaultExecutable() {
        return SystemInfo.isWindows ? WIN_EXECUTABLE : UNIX_EXECUTABLE;
    }

    @Nullable
    public String getExecutable(@Nullable WSLDistribution projectWslDistribution, boolean detectIfNeeded) {
        if (detectIfNeeded) {
            return this.detect(projectWslDistribution);
        }
        return this.getCachedExecutable(projectWslDistribution);
    }

    @Nullable
    private String getCachedExecutable(@Nullable WSLDistribution projectWslDistribution) {
        List<Detector> detectors = this.collectDetectors(projectWslDistribution);
        return GitExecutableDetector.getExecutable(detectors);
    }

    @NotNull
    public String detect(@Nullable WSLDistribution distribution) {
        List<Detector> detectors = this.collectDetectors(distribution);
        String detectedPath = GitExecutableDetector.getExecutable(detectors);
        if (detectedPath != null) {
            String string = detectedPath;
            if (string == null) {
                GitExecutableDetector.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = (String)GitExecutableManager.runUnderProgressIfNeeded(null, GitBundle.message("git.executable.detect.progress.title", new Object[0]), () -> this.detectExecutable(detectors));
        if (string == null) {
            GitExecutableDetector.$$$reportNull$$$0(1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @NotNull
    private String detectExecutable(@NotNull List<Detector> detectors) {
        if (detectors == null) {
            GitExecutableDetector.$$$reportNull$$$0(2);
        }
        String path = null;
        boolean fireEvent = false;
        Object object = this.DETECTED_EXECUTABLE_LOCK;
        synchronized (object) {
            for (Detector detector : detectors) {
                DetectionResult detectionResult = detector.getPath();
                if (detectionResult == null) {
                    detector.runDetection();
                    fireEvent = true;
                    detectionResult = detector.getPath();
                }
                if (detectionResult == null || detectionResult.detectedPath == null) continue;
                path = detectionResult.detectedPath;
                break;
            }
        }
        if (fireEvent) {
            GitExecutableDetector.fireExecutableChanged();
        }
        if (path != null) {
            String string = path;
            if (string == null) {
                GitExecutableDetector.$$$reportNull$$$0(3);
            }
            return string;
        }
        return GitExecutableDetector.getDefaultExecutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    public void clear() {
        Object object = this.DETECTED_EXECUTABLE_LOCK;
        synchronized (object) {
            this.myEnvExecutable.set(null);
            this.mySystemExecutable.set(null);
            this.myWslExecutables.clear();
            this.myWslDistributionsProcessed = false;
        }
        GitExecutableDetector.fireExecutableChanged();
    }

    static void fireExecutableChanged() {
        GitConfigurationCache.getInstance().clearCache();
        ((GitExecutableListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GitExecutableManager.TOPIC)).executableChanged();
    }

    @Nullable
    private static String getExecutable(@NotNull List<Detector> detectors) {
        if (detectors == null) {
            GitExecutableDetector.$$$reportNull$$$0(4);
        }
        for (Detector detector : detectors) {
            DetectionResult path = detector.getPath();
            if (path == null) {
                return null;
            }
            if (path.detectedPath == null) continue;
            return path.detectedPath;
        }
        return GitExecutableDetector.getDefaultExecutable();
    }

    @NotNull
    private List<Detector> collectDetectors(@Nullable WSLDistribution projectWslDistribution) {
        ArrayList<Detector> detectors = new ArrayList<Detector>();
        if (projectWslDistribution != null && GitExecutableManager.supportWslExecutable()) {
            detectors.add(new WslDetector(projectWslDistribution));
        }
        detectors.add(new EnvDetector());
        if (SystemInfo.isWindows) {
            detectors.add(new WinSystemPathDetector());
        } else {
            detectors.add(new UnixSystemPathDetector());
        }
        if (projectWslDistribution == null && GitExecutableManager.supportWslExecutable() && Registry.is((String)"git.detect.wsl.executables")) {
            detectors.add(new GlobalWslDetector());
        }
        ArrayList<Detector> arrayList = detectors;
        if (arrayList == null) {
            GitExecutableDetector.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static String checkWslDistribution(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            GitExecutableDetector.$$$reportNull$$$0(6);
        }
        Path root = distribution.getUNCRootPath();
        for (String p : UNIX_PATHS) {
            Path f = root.resolve(p).resolve(UNIX_EXECUTABLE);
            if (!Files.exists(f, new LinkOption[0])) continue;
            return f.toString();
        }
        return null;
    }

    private String checkWslDistributionSafe(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            GitExecutableDetector.$$$reportNull$$$0(7);
        }
        Future<String> future = this.myWslExecutor.submit(() -> GitExecutableDetector.checkWslDistribution(distribution));
        try {
            return future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn(String.format("WSL executable detection aborted for %s", distribution), (Throwable)e);
            future.cancel(true);
            return null;
        }
    }

    @VisibleForTesting
    @Nullable
    protected File getWinRootInTests() {
        return null;
    }

    @VisibleForTesting
    @Nullable
    protected String getPathEnv() {
        return PathEnvironmentVariableUtil.getPathVariableValue();
    }

    @Nullable
    public static String patchExecutablePath(@NotNull String path) {
        File patchedFile;
        File file;
        if (path == null) {
            GitExecutableDetector.$$$reportNull$$$0(8);
        }
        if (SystemInfo.isWindows && ((file = new File(path.trim())).getName().equals("git-cmd.exe") || file.getName().equals("git-bash.exe")) && (patchedFile = new File(file.getParent(), "bin/git.exe")).exists()) {
            return patchedFile.getPath();
        }
        return null;
    }

    @Nullable
    public static String getBashExecutablePath(@NotNull String gitExecutable) {
        File bashFile;
        if (gitExecutable == null) {
            GitExecutableDetector.$$$reportNull$$$0(9);
        }
        if (!SystemInfo.isWindows) {
            return null;
        }
        File gitFile = new File(gitExecutable.trim());
        File gitDirFile = gitFile.getParentFile();
        if (gitDirFile != null && WIN_BIN_DIRS.contains(gitDirFile.getName()) && (bashFile = new File(gitDirFile.getParentFile(), "bin/bash.exe")).exists()) {
            return bashFile.getPath();
        }
        return null;
    }

    @NotNull
    public static List<Path> getDependencyPaths(@NotNull Path executablePath) {
        block5: {
            List list;
            if (executablePath == null) {
                GitExecutableDetector.$$$reportNull$$$0(10);
            }
            try {
                if (!SystemInfo.isMac || !ArrayUtil.contains((String)executablePath.toString(), (String[])APPLEGIT_PATHS)) break block5;
                list = ContainerUtil.map((Object[])APPLEGIT_DEPENDENCY_PATHS, path -> Paths.get(path, new String[0]));
            }
            catch (InvalidPathException e) {
                LOG.warn((Throwable)e);
            }
            if (list == null) {
                GitExecutableDetector.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<Path> list = Collections.emptyList();
        if (list == null) {
            GitExecutableDetector.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableDetector";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectors";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitExecutable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detectExecutable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDetectors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyPaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectExecutable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExecutable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkWslDistribution";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkWslDistributionSafe";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchExecutablePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBashExecutablePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    private static interface Detector {
        @Nullable
        public DetectionResult getPath();

        public void runDetection();
    }

    private static class DetectionResult {
        @Nullable
        public final String detectedPath;

        private DetectionResult(@Nullable String path) {
            this.detectedPath = path;
        }
    }

    private class WslDetector
    implements Detector {
        private final WSLDistribution myDistribution;

        private WslDetector(WSLDistribution distribution) {
            if (distribution == null) {
                WslDetector.$$$reportNull$$$0(0);
            }
            this.myDistribution = distribution;
        }

        @Override
        @Nullable
        public DetectionResult getPath() {
            return GitExecutableDetector.this.myWslExecutables.get(this.myDistribution);
        }

        @Override
        public void runDetection() {
            String result2 = GitExecutableDetector.this.checkWslDistributionSafe(this.myDistribution);
            GitExecutableDetector.this.myWslExecutables.put(this.myDistribution, new DetectionResult(result2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "distribution", "git4idea/config/GitExecutableDetector$WslDetector", "<init>"));
        }
    }

    private class EnvDetector
    implements Detector {
        private EnvDetector() {
        }

        @Override
        @Nullable
        public DetectionResult getPath() {
            return GitExecutableDetector.this.myEnvExecutable.get();
        }

        @Override
        public void runDetection() {
            String executableName = SystemInfo.isWindows ? GitExecutableDetector.WIN_EXECUTABLE : GitExecutableDetector.UNIX_EXECUTABLE;
            File executableFromEnv = PathEnvironmentVariableUtil.findInPath((String)executableName, (String)GitExecutableDetector.this.getPathEnv(), null);
            String path = executableFromEnv != null ? executableFromEnv.getAbsolutePath() : null;
            GitExecutableDetector.this.myEnvExecutable.set(new DetectionResult(path));
        }
    }

    private class WinSystemPathDetector
    implements Detector {
        private WinSystemPathDetector() {
        }

        @Override
        @Nullable
        public DetectionResult getPath() {
            return GitExecutableDetector.this.mySystemExecutable.get();
        }

        @Override
        public void runDetection() {
            String executable = this.detectForWindows();
            GitExecutableDetector.this.mySystemExecutable.set(new DetectionResult(executable));
        }

        @Nullable
        private String detectForWindows() {
            String exec = this.checkProgramFiles();
            if (exec != null) {
                return exec;
            }
            exec = WinSystemPathDetector.checkAppLocal();
            if (exec != null) {
                return exec;
            }
            exec = this.checkCygwin();
            if (exec != null) {
                return exec;
            }
            return null;
        }

        @Nullable
        private String checkProgramFiles() {
            File winRootInTests = GitExecutableDetector.this.getWinRootInTests();
            File winRoot = (File)ObjectUtils.chooseNotNull((Object)winRootInTests, (Object)new File("C:\\"));
            String programFiles = System.getenv("PROGRAMFILES");
            String programFilesX86 = System.getenv("PROGRAMFILES(X86)");
            File programFilesFile = !StringUtil.isEmpty((String)programFiles) && winRootInTests == null ? new File(programFiles) : new File(winRoot, "Program Files");
            File programFilesX86File = !StringUtil.isEmpty((String)programFilesX86) && winRootInTests == null ? new File(programFilesX86) : new File(winRoot, "Program Files (x86)");
            List<File> dirsToCheck = List.of(programFilesFile, programFilesX86File);
            ArrayList<File> distrs = new ArrayList<File>();
            for (File dir : dirsToCheck) {
                distrs.addAll(WinSystemPathDetector.findGitDistrsIn(dir));
            }
            return WinSystemPathDetector.getPreferredDistrExecutablePath(distrs);
        }

        @Nullable
        private static String checkAppLocal() {
            String appLocal = System.getenv("LocalAppData");
            if (StringUtil.isEmpty((String)appLocal)) {
                return null;
            }
            File appLocalFile = new File(appLocal + "\\Programs");
            List<File> dirsToCheck = List.of(appLocalFile);
            ArrayList<File> distrs = new ArrayList<File>();
            for (File dir : dirsToCheck) {
                distrs.addAll(WinSystemPathDetector.findGitDistrsIn(dir));
            }
            return WinSystemPathDetector.getPreferredDistrExecutablePath(distrs);
        }

        @Nullable
        private String checkCygwin() {
            File winRootInTests = GitExecutableDetector.this.getWinRootInTests();
            File winRoot = (File)ObjectUtils.chooseNotNull((Object)winRootInTests, (Object)new File("C:\\"));
            File defaultCygwinExe = new File(winRoot, "cygwin/bin/git.exe");
            List<File> exeToCheck = List.of(defaultCygwinExe);
            for (File file : exeToCheck) {
                if (!file.exists()) continue;
                return file.getPath();
            }
            return null;
        }

        @NotNull
        private static List<File> findGitDistrsIn(@NotNull File dir) {
            if (dir == null) {
                WinSystemPathDetector.$$$reportNull$$$0(0);
            }
            File[] children = dir.listFiles(pathname -> pathname.isDirectory() && StringUtil.toLowerCase((String)pathname.getName()).startsWith(GitExecutableDetector.UNIX_EXECUTABLE));
            if (!dir.exists() || children == null) {
                List<File> list = Collections.emptyList();
                if (list == null) {
                    WinSystemPathDetector.$$$reportNull$$$0(1);
                }
                return list;
            }
            List<File> list = Arrays.asList(children);
            if (list == null) {
                WinSystemPathDetector.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        private static String getPreferredDistrExecutablePath(@NotNull List<File> distrs) {
            if (distrs == null) {
                WinSystemPathDetector.$$$reportNull$$$0(3);
            }
            distrs.sort(Collections.reverseOrder(new VersionDirsComparator()));
            for (File distr : distrs) {
                String exec = WinSystemPathDetector.getDistrExecutablePath(distr);
                if (exec == null) continue;
                return exec;
            }
            return null;
        }

        @Nullable
        private static String getDistrExecutablePath(@Nullable File distr) {
            if (distr == null || !distr.exists()) {
                return null;
            }
            for (String binDirName : WIN_BIN_DIRS) {
                File fe;
                File binDir = new File(distr, binDirName);
                if (!binDir.exists() || !(fe = new File(binDir, GitExecutableDetector.WIN_EXECUTABLE)).exists()) continue;
                return fe.getPath();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/config/GitExecutableDetector$WinSystemPathDetector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "distrs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/config/GitExecutableDetector$WinSystemPathDetector";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findGitDistrsIn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findGitDistrsIn";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPreferredDistrExecutablePath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private class UnixSystemPathDetector
    implements Detector {
        private UnixSystemPathDetector() {
        }

        @Override
        @Nullable
        public DetectionResult getPath() {
            return GitExecutableDetector.this.mySystemExecutable.get();
        }

        @Override
        public void runDetection() {
            String executable = UnixSystemPathDetector.detectForUnix();
            GitExecutableDetector.this.mySystemExecutable.set(new DetectionResult(executable));
        }

        @Nullable
        private static String detectForUnix() {
            for (String p : UNIX_PATHS) {
                File f = new File(p, GitExecutableDetector.UNIX_EXECUTABLE);
                if (!f.exists()) continue;
                return f.getPath();
            }
            return null;
        }
    }

    private class GlobalWslDetector
    implements Detector {
        private GlobalWslDetector() {
        }

        @Override
        @Nullable
        public DetectionResult getPath() {
            if (!GitExecutableDetector.this.myWslDistributionsProcessed) {
                return null;
            }
            List knownDistros = ContainerUtil.mapNotNull(GitExecutableDetector.this.myWslExecutables.values(), it -> it.detectedPath);
            if (knownDistros.size() != 1) {
                return new DetectionResult(null);
            }
            String path = (String)knownDistros.iterator().next();
            return new DetectionResult(path);
        }

        @Override
        public void runDetection() {
            List distributions = WslDistributionManager.getInstance().getInstalledDistributions();
            for (WSLDistribution distribution : distributions) {
                String result2 = GitExecutableDetector.this.checkWslDistributionSafe(distribution);
                GitExecutableDetector.this.myWslExecutables.put(distribution, new DetectionResult(result2));
            }
            GitExecutableDetector.this.myWslDistributionsProcessed = true;
        }
    }

    private static class VersionDirsComparator
    implements Comparator<File> {
        private VersionDirsComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String name1 = StringUtil.toLowerCase((String)f1.getName());
            String name2 = StringUtil.toLowerCase((String)f2.getName());
            if (name1.equals(GitExecutableDetector.UNIX_EXECUTABLE)) {
                return name2.equals(GitExecutableDetector.UNIX_EXECUTABLE) ? VersionDirsComparator.fallback(f1, f2) : 1;
            }
            if (name2.equals(GitExecutableDetector.UNIX_EXECUTABLE)) {
                return -1;
            }
            Pattern GIT_WITH_VERSION = Pattern.compile("^git[ _]*([\\d\\.]*).*$");
            Matcher m1 = GIT_WITH_VERSION.matcher(name1);
            Matcher m2 = GIT_WITH_VERSION.matcher(name2);
            if (m1.matches() && m2.matches()) {
                GitVersion v1 = VersionDirsComparator.parseGitVersion(m1.group(1));
                GitVersion v2 = VersionDirsComparator.parseGitVersion(m2.group(1));
                if (v1 == null || v2 == null) {
                    return VersionDirsComparator.fallback(f1, f2);
                }
                int compareVersions = v1.compareTo(v2);
                return compareVersions == 0 ? VersionDirsComparator.fallback(f1, f2) : compareVersions;
            }
            return VersionDirsComparator.fallback(f1, f2);
        }

        private static int fallback(@NotNull File f1, @NotNull File f2) {
            int compareParents;
            if (f1 == null) {
                VersionDirsComparator.$$$reportNull$$$0(0);
            }
            if (f2 == null) {
                VersionDirsComparator.$$$reportNull$$$0(1);
            }
            if ((compareParents = f1.getParentFile().getName().compareTo(f2.getParentFile().getName())) != 0) {
                return -compareParents;
            }
            String name1 = StringUtil.toLowerCase((String)f1.getName());
            String name2 = StringUtil.toLowerCase((String)f2.getName());
            return name1.compareTo(name2);
        }

        @Nullable
        private static GitVersion parseGitVersion(@Nullable String name) {
            if (name == null) {
                return null;
            }
            Pattern VERSION = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?.*");
            Matcher m = VERSION.matcher(name);
            if (!m.matches()) {
                return null;
            }
            try {
                int major = Integer.parseInt(m.group(1));
                return new GitVersion(major, VersionDirsComparator.parseOrNull(m.group(2)), VersionDirsComparator.parseOrNull(m.group(3)), VersionDirsComparator.parseOrNull(m.group(4)));
            }
            catch (NumberFormatException e) {
                LOG.info("Unexpected NFE when parsing [" + name + "]", (Throwable)e);
                return null;
            }
        }

        private static int parseOrNull(String group) {
            return group == null ? 0 : Integer.parseInt(group);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "f1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "f2";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitExecutableDetector$VersionDirsComparator";
            objectArray[2] = "fallback";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

