/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog;

import com.intellij.util.ui.EditableModel;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseEntryKt;
import git4idea.rebase.interactive.GitRebaseTodoModel;
import git4idea.rebase.interactive.GitRebaseTodoModelConverterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 7*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u000278B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0002J \u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0004\u0012\u00020\u00120\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u001d\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0017H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\"\u0010%\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0013\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00020\u0017\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000-2\u0006\u0010)\u001a\u00020\u0017J\u0012\u0010.\u001a\u00020!2\n\u0010/\u001a\u0006\u0012\u0002\b\u000300J\u0012\u00101\u001a\u00020!2\n\u0010/\u001a\u0006\u0012\u0002\b\u000300J\u000e\u00102\u001a\u0002032\u0006\u0010)\u001a\u00020\u0017J\u000e\u00104\u001a\u0002032\u0006\u0010)\u001a\u00020\u0017J\u0006\u00105\u001a\u00020\u0012J\u0006\u00106\u001a\u00020\u0012R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel;", "T", "Lgit4idea/rebase/GitRebaseEntry;", "Ljavax/swing/table/AbstractTableModel;", "Lcom/intellij/util/ui/EditableModel;", "initialEntries", "", "<init>", "(Ljava/util/List;)V", "value", "Lgit4idea/rebase/interactive/GitRebaseTodoModel;", "rebaseTodoModel", "getRebaseTodoModel", "()Lgit4idea/rebase/interactive/GitRebaseTodoModel;", "createRebaseTodoModel", "savedStates", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel$SavedStates;", "updateModel", "", "f", "Lkotlin/Function1;", "resetEntries", "getRowCount", "", "getColumnCount", "getValueAt", "rowIndex", "columnIndex", "(II)Lgit4idea/rebase/GitRebaseEntry;", "exchangeRows", "oldIndex", "newIndex", "canExchangeRows", "", "removeRow", "idx", "addRow", "setValueAt", "aValue", "", "getEntry", "row", "(I)Lgit4idea/rebase/GitRebaseEntry;", "isCellEditable", "getElement", "Lgit4idea/rebase/interactive/GitRebaseTodoModel$Element;", "isFirstFixup", "child", "Lgit4idea/rebase/interactive/GitRebaseTodoModel$Element$UniteChild;", "isLastFixup", "getCommitMessage", "", "getPresentation", "undo", "redo", "Companion", "SavedStates", "intellij.vcs.git"})
public final class GitRebaseCommitsTableModel<T extends GitRebaseEntry>
extends AbstractTableModel
implements EditableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<T> initialEntries;
    @NotNull
    private GitRebaseTodoModel<T> rebaseTodoModel;
    @NotNull
    private final SavedStates<T> savedStates;
    public static final int COMMIT_ICON_COLUMN = 0;
    public static final int SUBJECT_COLUMN = 1;

    public GitRebaseCommitsTableModel(@NotNull List<? extends T> initialEntries) {
        Intrinsics.checkNotNullParameter(initialEntries, (String)"initialEntries");
        this.initialEntries = initialEntries;
        this.rebaseTodoModel = this.createRebaseTodoModel();
        this.savedStates = new SavedStates<T>(this.rebaseTodoModel.getElements());
    }

    @NotNull
    public final GitRebaseTodoModel<T> getRebaseTodoModel() {
        return this.rebaseTodoModel;
    }

    private final GitRebaseTodoModel<T> createRebaseTodoModel() {
        return GitRebaseTodoModelConverterKt.convertToModel(this.initialEntries);
    }

    public final void updateModel(@NotNull Function1<? super GitRebaseTodoModel<T>, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke(this.rebaseTodoModel);
        this.savedStates.addState(this.rebaseTodoModel.getElements());
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public final void resetEntries() {
        this.rebaseTodoModel = this.createRebaseTodoModel();
        this.savedStates.addState(this.rebaseTodoModel.getElements());
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    @Override
    public int getRowCount() {
        return this.rebaseTodoModel.getElements().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @NotNull
    public T getValueAt(int rowIndex, int columnIndex) {
        return this.getEntry(rowIndex);
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        this.updateModel(arg_0 -> GitRebaseCommitsTableModel.exchangeRows$lambda$0(oldIndex, newIndex, arg_0));
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    public void removeRow(int idx) {
        throw new UnsupportedOperationException();
    }

    public void addRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof String) {
            String string = GitRebaseEntryKt.getFullCommitMessage(this.getEntry(rowIndex));
            if (string == null) {
                throw new IllegalStateException();
            }
            String commitMessage = string;
            if (Intrinsics.areEqual((Object)aValue, (Object)commitMessage)) {
                this.rebaseTodoModel.pick(CollectionsKt.listOf((Object)rowIndex));
            } else {
                this.rebaseTodoModel.reword(rowIndex, (String)aValue);
            }
        }
    }

    @NotNull
    public final T getEntry(int row) {
        return this.rebaseTodoModel.getElements().get(row).getEntry();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 && this.rebaseTodoModel.canReword(rowIndex);
    }

    @NotNull
    public final GitRebaseTodoModel.Element<T> getElement(int row) {
        return this.rebaseTodoModel.getElements().get(row);
    }

    public final boolean isFirstFixup(@NotNull GitRebaseTodoModel.Element.UniteChild<?> child) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        return child == CollectionsKt.first(child.getRoot().getChildren());
    }

    public final boolean isLastFixup(@NotNull GitRebaseTodoModel.Element.UniteChild<?> child) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        return child == CollectionsKt.last(child.getRoot().getChildren());
    }

    @NotNull
    public final String getCommitMessage(int row) {
        String string;
        GitRebaseTodoModel.Type elementType = this.getElement(row).getType();
        if (elementType instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword) {
            string = ((GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword)elementType).getNewMessage();
        } else {
            string = GitRebaseEntryKt.getFullCommitMessage(this.getEntry(row));
            if (string == null) {
                throw new IllegalStateException();
            }
        }
        return string;
    }

    @NotNull
    public final String getPresentation(int row) {
        Object object;
        GitRebaseTodoModel.Type elementType = this.getElement(row).getType();
        if (elementType instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword) {
            object = ((GitRebaseTodoModel.Type.NonUnite.KeepCommit.Reword)elementType).getNewMessage();
        } else {
            T entry = this.getEntry(row);
            object = GitRebaseEntryKt.getFullCommitMessage(entry);
            if (object == null) {
                object = ((GitRebaseEntry)entry).getAction().getCommand() + " " + ((GitRebaseEntry)entry).getCommit();
            }
        }
        return object;
    }

    public final void undo() {
        List<GitRebaseTodoModel.Element<T>> list = this.savedStates.prevState();
        if (list != null) {
            List<GitRebaseTodoModel.Element<T>> it = list;
            boolean bl = false;
            this.rebaseTodoModel = new GitRebaseTodoModel<T>(it);
        }
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public final void redo() {
        List<GitRebaseTodoModel.Element<T>> list = this.savedStates.nextState();
        if (list != null) {
            List<GitRebaseTodoModel.Element<T>> it = list;
            boolean bl = false;
            this.rebaseTodoModel = new GitRebaseTodoModel<T>(it);
        }
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    private static final Unit exchangeRows$lambda$0(int $oldIndex, int $newIndex, GitRebaseTodoModel rebaseTodoModel) {
        Intrinsics.checkNotNullParameter((Object)rebaseTodoModel, (String)"rebaseTodoModel");
        rebaseTodoModel.exchangeIndices($oldIndex, $newIndex);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel$Companion;", "", "<init>", "()V", "COMMIT_ICON_COLUMN", "", "SUBJECT_COLUMN", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u0015*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0015B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\r\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0006\u0018\u00010\u0005H\u0002J\u0014\u0010\u000e\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0006\u0018\u00010\u0005J\u0014\u0010\u000f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0006\u0018\u00010\u0005J\u001a\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005J(\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u00052\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel$SavedStates;", "T", "Lgit4idea/rebase/GitRebaseEntry;", "", "initialState", "", "Lgit4idea/rebase/interactive/GitRebaseTodoModel$Element;", "<init>", "(Ljava/util/List;)V", "currentState", "", "states", "", "checkBoundsAndGetState", "prevState", "nextState", "addState", "", "newState", "copyElements", "elements", "Companion", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitRebaseCommitsTableModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseCommitsTableModel.kt\ngit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel$SavedStates\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1863#2,2:176\n*S KotlinDebug\n*F\n+ 1 GitRebaseCommitsTableModel.kt\ngit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel$SavedStates\n*L\n155#1:176,2\n*E\n"})
    private static final class SavedStates<T extends GitRebaseEntry> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int currentState;
        @NotNull
        private final List<List<GitRebaseTodoModel.Element<T>>> states;
        private static final int MAX_SIZE = 10;

        public SavedStates(@NotNull List<? extends GitRebaseTodoModel.Element<? extends T>> initialState) {
            Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
            Object[] objectArray = new List[]{this.copyElements(initialState)};
            this.states = CollectionsKt.mutableListOf((Object[])objectArray);
        }

        private final List<GitRebaseTodoModel.Element<T>> checkBoundsAndGetState() {
            int n = ((Collection)this.states).size();
            int n2 = this.currentState;
            if (!(0 <= n2 ? n2 < n : false)) {
                this.currentState = RangesKt.coerceIn((int)this.currentState, (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)this.states)));
                return null;
            }
            return this.copyElements(this.states.get(this.currentState));
        }

        @Nullable
        public final List<GitRebaseTodoModel.Element<T>> prevState() {
            int n = this.currentState;
            this.currentState = n + -1;
            return this.checkBoundsAndGetState();
        }

        @Nullable
        public final List<GitRebaseTodoModel.Element<T>> nextState() {
            int n = this.currentState;
            this.currentState = n + 1;
            return this.checkBoundsAndGetState();
        }

        public final void addState(@NotNull List<? extends GitRebaseTodoModel.Element<? extends T>> newState) {
            Intrinsics.checkNotNullParameter(newState, (String)"newState");
            int n = this.currentState;
            this.currentState = n + 1;
            if (this.currentState == 10) {
                this.currentState = 9;
                this.states.remove(0);
            }
            while (CollectionsKt.getLastIndex(this.states) != this.currentState - 1) {
                this.states.remove(CollectionsKt.getLastIndex(this.states));
            }
            this.states.add(this.currentState, this.copyElements(newState));
        }

        private final List<GitRebaseTodoModel.Element<T>> copyElements(List<? extends GitRebaseTodoModel.Element<? extends T>> elements) {
            List result2 = new ArrayList();
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                GitRebaseTodoModel.Element elementToCopy = (GitRebaseTodoModel.Element)element$iv;
                boolean bl2 = false;
                GitRebaseTodoModel.Element element = elementToCopy;
                if (element instanceof GitRebaseTodoModel.Element.Simple) {
                    bl = result2.add(new GitRebaseTodoModel.Element.Simple(((GitRebaseTodoModel.Element.Simple)elementToCopy).getIndex(), ((GitRebaseTodoModel.Element.Simple)elementToCopy).getType(), ((GitRebaseTodoModel.Element.Simple)elementToCopy).getEntry()));
                    continue;
                }
                if (element instanceof GitRebaseTodoModel.Element.UniteRoot) {
                    bl = result2.add(new GitRebaseTodoModel.Element.UniteRoot(((GitRebaseTodoModel.Element.UniteRoot)elementToCopy).getIndex(), ((GitRebaseTodoModel.Element.UniteRoot)elementToCopy).getType(), ((GitRebaseTodoModel.Element.UniteRoot)elementToCopy).getEntry()));
                    continue;
                }
                if (element instanceof GitRebaseTodoModel.Element.UniteChild) {
                    int rootIndex = ((GitRebaseTodoModel.Element.UniteChild)elementToCopy).getRoot().getIndex();
                    Object e = result2.get(rootIndex);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type git4idea.rebase.interactive.GitRebaseTodoModel.Element.UniteRoot<T of git4idea.rebase.interactive.dialog.GitRebaseCommitsTableModel.SavedStates>");
                    GitRebaseTodoModel.Element.UniteRoot root = (GitRebaseTodoModel.Element.UniteRoot)e;
                    GitRebaseTodoModel.Element.UniteChild child = new GitRebaseTodoModel.Element.UniteChild(((GitRebaseTodoModel.Element.UniteChild)elementToCopy).getIndex(), ((GitRebaseTodoModel.Element.UniteChild)elementToCopy).getEntry(), root);
                    root.addChild(child);
                    bl = result2.add(child);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            return result2;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel$SavedStates$Companion;", "", "<init>", "()V", "MAX_SIZE", "", "intellij.vcs.git"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

