/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.OptimizeImportsQuickFix;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.psi.impl.stubs.PyVersionSpecificStubBaseKt;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000f\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/inspections/PyUnusedImportsInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "inspectionFinished", "", "getAlternativeID", "", "Lorg/jetbrains/annotations/NonNls;", "Visitor", "Companion", "intellij.python.psi.impl"})
public final class PyUnusedImportsInspection
extends PyInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Visitor> KEY;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PyInspection pyInspection = this;
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        LanguageLevel languageLevel = PythonLanguageLevelPusher.getLanguageLevelForFile(session.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"getLanguageLevelForFile(...)");
        Visitor visitor2 = new Visitor(holder, pyInspection, typeEvalContext, languageLevel);
        session.putUserData(KEY, (Object)visitor2);
        return visitor2;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Object object = session.getUserData(KEY);
        Intrinsics.checkNotNull((Object)object);
        Visitor visitor2 = (Visitor)((Object)object);
        ReadAction.run(() -> PyUnusedImportsInspection.inspectionFinished$lambda$0(visitor2));
        session.putUserData(KEY, null);
    }

    @Nullable
    public String getAlternativeID() {
        return "PyUnresolvedReferences";
    }

    private static final void inspectionFinished$lambda$0(Visitor $visitor) {
        if (PyCodeInsightSettings.getInstance().HIGHLIGHT_UNUSED_IMPORTS) {
            $visitor.highlightUnusedImports();
        }
        $visitor.highlightImportsInsideGuards();
    }

    static {
        Key key = Key.create((String)"PyUnusedImportsInspection.Visitor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/inspections/PyUnusedImportsInspection$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/python/inspections/PyUnusedImportsInspection$Visitor;", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010&2\u0006\u0010\u0016\u001a\u00020\u001eH\u0002J\u0012\u0010/\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u000100H\u0002J\u0010\u00101\u001a\u00020\u00152\u0006\u0010 \u001a\u000202H\u0002J\u0006\u00103\u001a\u00020\u0015J\u0006\u00104\u001a\u00020\u0015J\f\u00105\u001a\b\u0012\u0004\u0012\u00020,06J\u001e\u00107\u001a\u00020#2\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000e0;H\u0002J\u0006\u0010<\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/jetbrains/python/inspections/PyUnusedImportsInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "myInspection", "Lcom/jetbrains/python/inspections/PyInspection;", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "languageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/inspections/PyInspection;Lcom/jetbrains/python/psi/types/TypeEvalContext;Lcom/jetbrains/python/psi/LanguageLevel;)V", "myAllImports", "", "Lcom/jetbrains/python/psi/PyImportedNameDefiner;", "myImportsInsideGuard", "myUsedImports", "myUnresolvedImports", "myVersion", "Lcom/intellij/openapi/util/Version;", "visitPyImportElement", "", "node", "Lcom/jetbrains/python/psi/PyImportElement;", "visitPyStarImportElement", "Lcom/jetbrains/python/psi/PyStarImportElement;", "visitComment", "comment", "Lcom/intellij/psi/PsiComment;", "visitPyElement", "Lcom/jetbrains/python/psi/PyElement;", "processReference", "reference", "Lcom/intellij/psi/PsiReference;", "ignoreUnresolved", "", "processReferenceInImportGuard", "guard", "Lcom/jetbrains/python/psi/PyExceptPart;", "shouldSkipMissingWriteInsideGuard", "name", "", "isDefinedInParentScope", "anchor", "Lcom/intellij/psi/PsiElement;", "controlFlowAlwaysTerminatesInsideGuard", "getImportErrorGuard", "processInjection", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "markTargetImportsAsUsed", "Lcom/intellij/psi/PsiPolyVariantReference;", "highlightUnusedImports", "highlightImportsInsideGuards", "collectUnusedImportElements", "", "areAllImportsUnused", "importStatement", "Lcom/jetbrains/python/psi/PyImportStatementBase;", "unusedImports", "", "optimizeImports", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyUnusedImportsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyUnusedImportsInspection.kt\ncom/jetbrains/python/inspections/PyUnusedImportsInspection$Visitor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,402:1\n66#2,2:403\n66#2,2:405\n66#2,2:410\n66#2,2:412\n66#2,2:414\n66#2,2:424\n66#2,2:426\n66#2,2:428\n1761#3,3:407\n1761#3,3:418\n1761#3,3:421\n1761#3,3:430\n1310#4,2:416\n12434#4,2:433\n*S KotlinDebug\n*F\n+ 1 PyUnusedImportsInspection.kt\ncom/jetbrains/python/inspections/PyUnusedImportsInspection$Visitor\n*L\n74#1:403,2\n164#1:405,2\n206#1:410,2\n207#1:412,2\n208#1:414,2\n321#1:424,2\n327#1:426,2\n331#1:428,2\n170#1:407,3\n247#1:418,3\n292#1:421,3\n332#1:430,3\n210#1:416,2\n382#1:433,2\n*E\n"})
    public static final class Visitor
    extends PyInspectionVisitor {
        @NotNull
        private final PyInspection myInspection;
        @NotNull
        private final Set<PyImportedNameDefiner> myAllImports;
        @NotNull
        private final Set<PyImportedNameDefiner> myImportsInsideGuard;
        @NotNull
        private final Set<PyImportedNameDefiner> myUsedImports;
        @NotNull
        private final Set<PyImportedNameDefiner> myUnresolvedImports;
        @NotNull
        private final Version myVersion;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull PyInspection myInspection, @NotNull TypeEvalContext typeEvalContext, @NotNull LanguageLevel languageLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)myInspection), (String)"myInspection");
            Intrinsics.checkNotNullParameter((Object)typeEvalContext, (String)"typeEvalContext");
            Intrinsics.checkNotNullParameter((Object)((Object)languageLevel), (String)"languageLevel");
            super(holder, typeEvalContext);
            this.myInspection = myInspection;
            this.myAllImports = new LinkedHashSet();
            this.myImportsInsideGuard = new LinkedHashSet();
            this.myUsedImports = new LinkedHashSet();
            this.myUnresolvedImports = new LinkedHashSet();
            this.myVersion = new Version(languageLevel.getMajorVersion(), languageLevel.getMinorVersion(), 0);
        }

        @Override
        public void visitPyImportElement(@NotNull PyImportElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyImportElement(node);
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)node;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PyFromImportStatement fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyFromImportStatement.class, (boolean)true);
            if (fromImport == null || !fromImport.isFromFuture()) {
                this.myAllImports.add(node);
            }
        }

        @Override
        public void visitPyStarImportElement(@NotNull PyStarImportElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyStarImportElement(node);
            this.myAllImports.add(node);
        }

        public void visitComment(@NotNull PsiComment comment) {
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            super.visitComment(comment);
            if (comment instanceof PsiLanguageInjectionHost) {
                this.processInjection((PsiLanguageInjectionHost)comment);
            }
        }

        @Override
        public void visitPyElement(@NotNull PyElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyElement(node);
            if (node instanceof PyReferenceOwner) {
                PyResolveContext pyResolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext);
                Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(...)");
                PyResolveContext resolveContext = pyResolveContext;
                this.processReference(node, (PsiReference)((PyReferenceOwner)node).getReference(resolveContext));
            } else {
                for (PsiReference reference : node.getReferences()) {
                    this.processReference(node, reference);
                }
            }
        }

        private final void processReference(PyElement node, PsiReference reference) {
            if (reference == null || reference.isSoft()) {
                return;
            }
            PyExceptPart guard = this.getImportErrorGuard(node);
            if (guard != null) {
                this.processReferenceInImportGuard(node, guard);
                return;
            }
            PsiElement target = null;
            boolean unresolved = false;
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)reference).multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                ResolveResult[] resolveResults = resolveResultArray;
                unresolved = resolveResults.length == 0;
                for (ResolveResult resolveResult : resolveResults) {
                    PyImportedNameDefiner definer;
                    if (target == null && resolveResult.isValidResult()) {
                        target = resolveResult.getElement();
                    }
                    if (!(resolveResult instanceof ImportedResolveResult) || (definer = ((ImportedResolveResult)resolveResult).getDefiner()) == null) continue;
                    this.myUsedImports.add(definer);
                }
            } else {
                target = reference.resolve();
                boolean bl = unresolved = target == null;
            }
            if (unresolved) {
                PsiElement psiElement;
                PyImportElement importElement;
                boolean ignoreUnresolved;
                boolean bl = ignoreUnresolved = this.ignoreUnresolved(node, reference) || !PyVersionSpecificStubBaseKt.evaluateVersionsForElement((PsiElement)node).contains((Comparable)this.myVersion);
                if (!ignoreUnresolved) {
                    HighlightSeverity severity;
                    HighlightSeverity highlightSeverity = severity = reference instanceof PsiReferenceEx ? ((PsiReferenceEx)reference).getUnresolvedHighlightSeverity(this.myTypeEvalContext) : HighlightSeverity.ERROR;
                    if (severity == null) {
                        return;
                    }
                }
                PyImportElement pyImportElement = importElement = (psiElement = node.getParent()) instanceof PyImportElement ? (PyImportElement)psiElement : null;
                if (importElement != null) {
                    this.myUnresolvedImports.add(importElement);
                }
            }
        }

        private final boolean ignoreUnresolved(PyElement node, PsiReference reference) {
            boolean ignoreUnresolved = false;
            for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                if (!extension.ignoreUnresolvedReference(node, reference, this.myTypeEvalContext)) continue;
                ignoreUnresolved = true;
                break;
            }
            return ignoreUnresolved;
        }

        private final void processReferenceInImportGuard(PyElement node, PyExceptPart guard) {
            boolean hasWriteInsideGuard;
            String visibleName;
            PyImportElement importElement;
            block6: {
                PsiElement $this$parentOfType_u24default$iv = (PsiElement)node;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyImportElement.class, (boolean)true);
                if (importElement == null) {
                    return;
                }
                visibleName = importElement.getVisibleName();
                ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)importElement);
                if (visibleName == null || owner == null) {
                    return;
                }
                List<PsiElement> list = ScopeUtil.getElementsOfAccessType(visibleName, owner, ReadWriteInstruction.ACCESS.WRITE);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getElementsOfAccessType(...)");
                List<PsiElement> allWrites = list;
                Iterable $this$any$iv = allWrites;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!PsiTreeUtilKt.isAncestor$default((PsiElement)guard, (PsiElement)it, (boolean)false, (int)2, null)) continue;
                        v1 = true;
                        break block6;
                    }
                    v1 = hasWriteInsideGuard = false;
                }
            }
            if (!hasWriteInsideGuard && !this.shouldSkipMissingWriteInsideGuard(guard, visibleName)) {
                this.myImportsInsideGuard.add(importElement);
            }
        }

        private final boolean shouldSkipMissingWriteInsideGuard(PyExceptPart guard, String name2) {
            return this.isDefinedInParentScope(name2, guard) || PyBuiltinCache.Companion.getInstance(guard).getByName(name2) != null || this.controlFlowAlwaysTerminatesInsideGuard(guard);
        }

        private final boolean isDefinedInParentScope(String name2, PsiElement anchor) {
            return ScopeUtil.getDeclarationScopeOwner((PsiElement)ScopeUtil.getScopeOwner(anchor), name2) != null;
        }

        private final boolean controlFlowAlwaysTerminatesInsideGuard(PyExceptPart guard) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(guard);
            if (owner == null) {
                return false;
            }
            ControlFlow controlFlow = ControlFlowCache.getControlFlow(owner);
            Intrinsics.checkNotNullExpressionValue((Object)controlFlow, (String)"getControlFlow(...)");
            ControlFlow flow = controlFlow;
            Instruction[] instructionArray = flow.getInstructions();
            Intrinsics.checkNotNullExpressionValue((Object)instructionArray, (String)"getInstructions(...)");
            Instruction[] instructions = instructionArray;
            int start = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)((PsiElement)guard.getExceptClass()));
            if (start <= 0) {
                return false;
            }
            Ref.BooleanRef canEscapeGuard = new Ref.BooleanRef();
            ControlFlowUtil.process((Instruction[])instructions, (int)start, arg_0 -> Visitor.controlFlowAlwaysTerminatesInsideGuard$lambda$2(arg_0 -> Visitor.controlFlowAlwaysTerminatesInsideGuard$lambda$1(guard, canEscapeGuard, arg_0), arg_0));
            return !canEscapeGuard.element;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final PyExceptPart getImportErrorGuard(PyElement node) {
            void element$iv;
            block2: {
                void $this$firstOrNull$iv;
                void $this$parentOfType_u24default$iv;
                void $this$parentOfType_u24default$iv2;
                PsiElement $this$parentOfType_u24default$iv3 = (PsiElement)node;
                boolean withSelf$iv22 = false;
                boolean $i$f$parentOfType = false;
                PyImportStatementBase pyImportStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv3, PyImportStatementBase.class, (boolean)true);
                if (pyImportStatementBase == null) return null;
                PsiElement withSelf$iv22 = (PsiElement)pyImportStatementBase;
                boolean withSelf$iv32 = false;
                boolean $i$f$parentOfType2 = false;
                PyTryPart pyTryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, PyTryPart.class, (boolean)true);
                if (pyTryPart == null) return null;
                PsiElement withSelf$iv32 = (PsiElement)pyTryPart;
                boolean withSelf$iv42 = false;
                boolean $i$f$parentOfType3 = false;
                PyTryExceptStatement pyTryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyTryExceptStatement.class, (boolean)true);
                if (pyTryExceptStatement == null) return null;
                PyExceptPart[] pyExceptPartArray = pyTryExceptStatement.getExceptParts();
                if (pyExceptPartArray == null) return null;
                PyExceptPart[] withSelf$iv42 = pyExceptPartArray;
                boolean $i$f$firstOrNull = false;
                int n = 0;
                int n2 = ((void)$this$firstOrNull$iv).length;
                while (n < n2) {
                    void it = element$iv = $this$firstOrNull$iv[n];
                    boolean bl = false;
                    PyExpression pyExpression = it.getExceptClass();
                    if (!Intrinsics.areEqual((Object)"ImportError", (Object)(pyExpression != null ? pyExpression.getName() : null))) {
                        ++n;
                        continue;
                    }
                    break block2;
                }
                return null;
            }
            Object v1 = element$iv;
            return v1;
        }

        private final void processInjection(PsiLanguageInjectionHost node) {
            if (node == null) {
                return;
            }
            List files = InjectedLanguageManager.getInstance((Project)node.getProject()).getInjectedPsiFiles((PsiElement)node);
            if (files != null) {
                for (Pair pair : files) {
                    PyRecursiveElementVisitor pyRecursiveElementVisitor = new PyRecursiveElementVisitor(this){
                        final /* synthetic */ Visitor this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void visitPyElement(PyElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            super.visitPyElement(element);
                            if (element instanceof PyReferenceOwner) {
                                PyResolveContext pyResolveContext = PyResolveContext.defaultContext(this.this$0.myTypeEvalContext);
                                Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(...)");
                                PyResolveContext resolveContext = pyResolveContext;
                                PsiPolyVariantReference psiPolyVariantReference = ((PyReferenceOwner)element).getReference(resolveContext);
                                Intrinsics.checkNotNullExpressionValue((Object)psiPolyVariantReference, (String)"getReference(...)");
                                PsiPolyVariantReference reference = psiPolyVariantReference;
                                Visitor.access$markTargetImportsAsUsed(this.this$0, reference);
                            }
                        }
                    };
                    Object object = pair.getFirst();
                    Intrinsics.checkNotNull((Object)object);
                    pyRecursiveElementVisitor.visitElement((PsiElement)object);
                }
            }
        }

        private final void markTargetImportsAsUsed(PsiPolyVariantReference reference) {
            ResolveResult[] resolveResultArray = reference.multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            for (ResolveResult resolveResult : resolveResultArray) {
                PyImportedNameDefiner definer;
                if (!(resolveResult instanceof ImportedResolveResult) || (definer = ((ImportedResolveResult)resolveResult).getDefiner()) == null) continue;
                this.myUsedImports.add(definer);
            }
        }

        public final void highlightUnusedImports() {
            List<PsiElement> unused = this.collectUnusedImportElements();
            for (PsiElement element : unused) {
                boolean bl;
                block4: {
                    Iterable $this$any$iv = PyInspectionExtension.EP_NAME.getExtensionList();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PyInspectionExtension it = (PyInspectionExtension)element$iv;
                            boolean bl2 = false;
                            if (!it.ignoreUnused(element, this.myTypeEvalContext)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (bl || !PyVersionSpecificStubBaseKt.evaluateVersionsForElement(element).contains((Comparable)this.myVersion) || element.getTextLength() <= 0) continue;
                OptimizeImportsQuickFix fix = new OptimizeImportsQuickFix();
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                this.registerProblem(element, PyPsiBundle.message("INSP.unused.imports.unused.import.statement", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, localQuickFixArray);
            }
        }

        public final void highlightImportsInsideGuards() {
            for (PyImportedNameDefiner definer : CollectionsKt.intersect((Iterable)this.myImportsInsideGuard, (Iterable)this.myUsedImports)) {
                PyTargetExpression asElement;
                if (!(definer instanceof PyImportElement)) continue;
                PyTargetExpression pyTargetExpression = asElement = ((PyImportElement)definer).getAsNameElement();
                PyElement toHighlight = pyTargetExpression != null ? (PyElement)pyTargetExpression : (PyElement)((PyImportElement)definer).getImportReferenceExpression();
                Object[] objectArray = new Object[]{((PyImportElement)definer).getVisibleName()};
                this.registerProblem((PsiElement)toHighlight, PyPsiBundle.message("INSP.unused.imports.try.except.import.error", objectArray), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        }

        @NotNull
        public final List<PsiElement> collectUnusedImportElements() {
            if (this.myAllImports.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            PyImportedNameDefiner first = (PyImportedNameDefiner)CollectionsKt.first((Iterable)this.myAllImports);
            if (first.getContainingFile() instanceof PyExpressionCodeFragment || PythonRuntimeService.getInstance().isInPydevConsole((PsiElement)first)) {
                return CollectionsKt.emptyList();
            }
            List result2 = new ArrayList();
            Set unusedImports = new HashSet(this.myAllImports);
            unusedImports.removeAll((Collection)this.myUsedImports);
            unusedImports.removeAll((Collection)this.myUnresolvedImports);
            Set unusedImportToSkip = new HashSet();
            for (Object unusedImport : unusedImports) {
                boolean bl;
                block21: {
                    Iterable $this$any$iv = PyInspectionExtension.EP_NAME.getExtensionList();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PyInspectionExtension it = (PyInspectionExtension)element$iv;
                            boolean bl2 = false;
                            if (!it.ignoreUnusedImports((PyImportedNameDefiner)unusedImport)) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                unusedImportToSkip.add(unusedImport);
            }
            TypeIntrinsics.asMutableCollection((Object)unusedImports).removeAll(unusedImportToSkip);
            Set usedImportNames = new HashSet();
            for (PyImportedNameDefiner usedImport : this.myUsedImports) {
                for (PyElement e : usedImport.iterateNames()) {
                    usedImportNames.add(e.getName());
                }
            }
            Set unusedStatements = new HashSet();
            QualifiedName packageQName = null;
            List<String> dunderAll = null;
            for (PyImportedNameDefiner unusedImport : unusedImports) {
                boolean bl;
                QualifiedName importedQName;
                if (packageQName == null) {
                    PsiFile file = unusedImport.getContainingFile();
                    if (file instanceof PyFile) {
                        dunderAll = ((PyFile)file).getDunderAll();
                    }
                    if (file != null && PyUtil.isPackage(file)) {
                        packageQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file);
                    }
                }
                PsiElement $this$parentOfType_u24default$iv = (PsiElement)unusedImport;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyImportStatementBase.class, (boolean)true);
                if (importStatement == null || unusedStatements.contains(importStatement) || this.myUsedImports.contains(unusedImport) || this.myInspection.isSuppressedFor((PsiElement)importStatement)) continue;
                $this$parentOfType_u24default$iv = (PsiElement)importStatement;
                withSelf$iv = false;
                $i$f$parentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyTryExceptStatement.class, (boolean)true) != null) continue;
                $this$parentOfType_u24default$iv = (PsiElement)unusedImport;
                withSelf$iv = false;
                $i$f$parentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyIfStatement.class, (boolean)true) != null) {
                    boolean bl3;
                    block22: {
                        Iterable<PyElement> $this$any$iv;
                        Intrinsics.checkNotNullExpressionValue(unusedImport.iterateNames(), (String)"iterateNames(...)");
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            Iterator<PyElement> iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                PyElement element$iv;
                                PyElement it = element$iv = iterator.next();
                                boolean bl4 = false;
                                if (!usedImportNames.contains(it.getName())) continue;
                                bl3 = true;
                                break block22;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) continue;
                }
                PsiFileSystemItem importedElement = null;
                if (unusedImport instanceof PyImportElement) {
                    PsiElement element = ((PyImportElement)unusedImport).resolve();
                    if (element == null) {
                        if (((PyImportElement)unusedImport).getImportedQName() == null) continue;
                        boolean bl5 = this.areAllImportsUnused(importStatement, unusedImports) ? result2.add(importStatement) : result2.add(unusedImport);
                        continue;
                    }
                    if (dunderAll != null && CollectionsKt.contains((Iterable)dunderAll, (Object)((PyImportElement)unusedImport).getVisibleName())) continue;
                    importedElement = (PsiFileSystemItem)element.getContainingFile();
                } else {
                    boolean element = importStatement instanceof PyFromImportStatement;
                    if (_Assertions.ENABLED && !element) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    importedElement = ((PyFromImportStatement)importStatement).resolveImportSource();
                    if (importedElement == null) continue;
                }
                if (packageQName != null && importedElement != null && (importedQName = QualifiedNameFinder.findShortestImportableQName(importedElement)) != null && importedQName.matchesPrefix(packageQName)) continue;
                if (unusedImport instanceof PyStarImportElement || this.areAllImportsUnused(importStatement, unusedImports)) {
                    unusedStatements.add(importStatement);
                    bl = result2.add(importStatement);
                    continue;
                }
                bl = result2.add(unusedImport);
            }
            return result2;
        }

        private final boolean areAllImportsUnused(PyImportStatementBase importStatement, Set<? extends PyImportedNameDefiner> unusedImports) {
            boolean bl;
            block1: {
                PyImportElement[] pyImportElementArray = importStatement.getImportElements();
                Intrinsics.checkNotNullExpressionValue((Object)pyImportElementArray, (String)"getImportElements(...)");
                Object[] $this$all$iv = pyImportElementArray;
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    PyImportElement it = (PyImportElement)element$iv;
                    boolean bl2 = false;
                    if (unusedImports.contains(it)) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        public final void optimizeImports() {
            List<PsiElement> elementsToDelete = this.collectUnusedImportElements();
            for (PsiElement element : elementsToDelete) {
                PyPsiUtils.assertValid(element);
                element.delete();
            }
        }

        private static final boolean controlFlowAlwaysTerminatesInsideGuard$lambda$1(PyExceptPart $guard, Ref.BooleanRef $canEscapeGuard, Instruction instruction) {
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            PsiElement e = instruction.getElement();
            if (e != null && !PsiTreeUtilKt.isAncestor((PsiElement)$guard, (PsiElement)e, (boolean)true)) {
                $canEscapeGuard.element = true;
                return false;
            }
            return true;
        }

        private static final boolean controlFlowAlwaysTerminatesInsideGuard$lambda$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$markTargetImportsAsUsed(Visitor $this, PsiPolyVariantReference reference) {
            $this.markTargetImportsAsUsed(reference);
        }
    }
}

