/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.ast.PyAstDecoratorList;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyFunctionBuilder {
    private final String myName;
    private final List<String> myParameters;
    private final List<String> myStatements;
    private final List<String> myDecorators;
    private final PsiElement mySettingAnchor;
    private String myAnnotation;
    @NotNull
    private final Map<String, String> myDecoratorValues;
    private boolean myAsync;
    private PyDocstringGenerator myDocStringGenerator;

    @NotNull
    public static PyFunctionBuilder copySignature(@NotNull PyFunction source, String ... decoratorsToCopyIfExist) {
        String name2;
        if (source == null) {
            PyFunctionBuilder.$$$reportNull$$$0(0);
        }
        if (decoratorsToCopyIfExist == null) {
            PyFunctionBuilder.$$$reportNull$$$0(1);
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder((name2 = source.getName()) != null ? name2 : "", source);
        for (PyParameter parameter : source.getParameterList().getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName == null) continue;
            functionBuilder.parameter(parameterName);
        }
        PyAstDecoratorList decoratorList = source.getDecoratorList();
        if (decoratorList != null) {
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                String decoratorName = decorator.getName();
                if (decoratorName == null || !ArrayUtil.contains((String)decoratorName, (String[])decoratorsToCopyIfExist)) continue;
                functionBuilder.decorate(decoratorName);
            }
        }
        functionBuilder.myDocStringGenerator = PyDocstringGenerator.forDocStringOwner(source);
        PyFunctionBuilder pyFunctionBuilder = functionBuilder;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(2);
        }
        return pyFunctionBuilder;
    }

    public PyFunctionBuilder(@NotNull String name2, @NotNull PsiElement settingsAnchor) {
        if (name2 == null) {
            PyFunctionBuilder.$$$reportNull$$$0(3);
        }
        if (settingsAnchor == null) {
            PyFunctionBuilder.$$$reportNull$$$0(4);
        }
        this.myParameters = new ArrayList<String>();
        this.myStatements = new ArrayList<String>();
        this.myDecorators = new ArrayList<String>();
        this.myAnnotation = null;
        this.myDecoratorValues = new HashMap<String, String>();
        this.myAsync = false;
        this.myName = name2;
        this.myDocStringGenerator = PyDocstringGenerator.create(DocStringParser.getConfiguredDocStringFormatOrPlain(settingsAnchor), PyIndentUtil.getIndentFromSettings(settingsAnchor.getContainingFile()), settingsAnchor);
        this.mySettingAnchor = settingsAnchor;
    }

    @NotNull
    public PyFunctionBuilder parameterWithType(@NotNull String name2, @NotNull String type2) {
        if (name2 == null) {
            PyFunctionBuilder.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            PyFunctionBuilder.$$$reportNull$$$0(6);
        }
        this.parameter(name2);
        this.myDocStringGenerator.withParamTypedByName(name2, type2);
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(7);
        }
        return pyFunctionBuilder;
    }

    public PyFunctionBuilder parameter(String baseName) {
        Object name2 = baseName;
        int uniqueIndex = 0;
        while (this.myParameters.contains(name2)) {
            name2 = baseName + ++uniqueIndex;
        }
        this.myParameters.add((String)name2);
        return this;
    }

    public PyFunctionBuilder annotation(String text) {
        this.myAnnotation = text;
        return this;
    }

    public PyFunctionBuilder makeAsync() {
        this.myAsync = true;
        return this;
    }

    public PyFunctionBuilder statement(String text) {
        this.myStatements.add(text);
        return this;
    }

    public PyFunction addFunction(PsiElement target) {
        return (PyFunction)target.add((PsiElement)this.buildFunction());
    }

    public PyFunction addFunctionAfter(PsiElement target, PsiElement anchor) {
        return (PyFunction)target.addAfter((PsiElement)this.buildFunction(), anchor);
    }

    public PyFunction buildFunction() {
        PyElementGenerator generator = PyElementGenerator.getInstance(this.mySettingAnchor.getProject());
        return generator.createFromText(LanguageLevel.forElement(this.mySettingAnchor), PyFunction.class, this.buildText(generator));
    }

    private String buildText(PyElementGenerator generator) {
        StringBuilder builder = new StringBuilder();
        for (String decorator : this.myDecorators) {
            StringBuilder decoratorAppender = builder.append("@" + decorator);
            if (this.myDecoratorValues.containsKey(decorator)) {
                PyCallExpression fakeCall = generator.createCallExpression(LanguageLevel.forElement(this.mySettingAnchor), "fakeFunction");
                fakeCall.getArgumentList().addArgument(generator.createStringLiteralFromString(this.myDecoratorValues.get(decorator)));
                decoratorAppender.append(fakeCall.getArgumentList().getText());
            }
            decoratorAppender.append("\n");
        }
        if (this.myAsync) {
            builder.append("async ");
        }
        builder.append("def ");
        builder.append(this.myName).append("(");
        builder.append(StringUtil.join(this.myParameters, (String)", "));
        builder.append(")");
        if (this.myAnnotation != null) {
            builder.append(this.myAnnotation);
        }
        builder.append(":");
        List<String> statements = this.myStatements.isEmpty() ? Collections.singletonList("pass") : this.myStatements;
        String indent = PyIndentUtil.getIndentFromSettings(this.mySettingAnchor.getContainingFile());
        if (!this.myDocStringGenerator.isNewMode() || this.myDocStringGenerator.hasParametersToAdd()) {
            String docstring = PyIndentUtil.changeIndent(this.myDocStringGenerator.buildDocString(), true, indent);
            builder.append('\n').append(indent).append(docstring);
        }
        for (String statement : statements) {
            builder.append('\n').append(indent).append(statement);
        }
        return builder.toString();
    }

    public void decorate(@NotNull String decoratorName, @NotNull String value) {
        if (decoratorName == null) {
            PyFunctionBuilder.$$$reportNull$$$0(8);
        }
        if (value == null) {
            PyFunctionBuilder.$$$reportNull$$$0(9);
        }
        this.decorate(decoratorName);
        this.myDecoratorValues.put(decoratorName, value);
    }

    public void decorate(String decoratorName) {
        this.myDecorators.add(decoratorName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorsToCopyIfExist";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFunctionBuilder";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFunctionBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copySignature";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parameterWithType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copySignature";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parameterWithType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "decorate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }
}

