/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyInstantTypeProvider;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalConstraints;
import com.jetbrains.python.psi.types.TypeEvalContextCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class TypeEvalContext {
    @NotNull
    private final TypeEvalConstraints myConstraints;
    private List<String> myTrace;
    private String myTraceIndent;
    private final ThreadLocal<ProcessingContext> myProcessingContext;
    protected final Map<PyTypedElement, PyType> myEvaluated;
    protected final Map<PyCallable, PyType> myEvaluatedReturn;
    protected final Map<Pair<PyExpression, Object>, PyType> contextTypeCache;

    private static <T> Map<T, PyType> createMap() {
        if (Registry.is((String)"python.use.better.control.flow.type.inference")) {
            return new ConcurrentHashMap();
        }
        return CollectionFactory.createConcurrentSoftValueMap();
    }

    private TypeEvalContext(boolean allowDataFlow, boolean allowStubToAST, boolean allowCallContext, @Nullable PsiFile origin) {
        this.myTraceIndent = "";
        this.myProcessingContext = ThreadLocal.withInitial(ProcessingContext::new);
        this.myEvaluated = TypeEvalContext.createMap();
        this.myEvaluatedReturn = TypeEvalContext.createMap();
        this.contextTypeCache = TypeEvalContext.createMap();
        this.myConstraints = new TypeEvalConstraints(allowDataFlow, allowStubToAST, allowCallContext, origin);
    }

    private TypeEvalContext(@NotNull TypeEvalConstraints constraints) {
        if (constraints == null) {
            TypeEvalContext.$$$reportNull$$$0(0);
        }
        this.myTraceIndent = "";
        this.myProcessingContext = ThreadLocal.withInitial(ProcessingContext::new);
        this.myEvaluated = TypeEvalContext.createMap();
        this.myEvaluatedReturn = TypeEvalContext.createMap();
        this.contextTypeCache = TypeEvalContext.createMap();
        this.myConstraints = constraints;
    }

    public String toString() {
        return String.format("TypeEvalContext(%b, %b, %s)", this.myConstraints.myAllowDataFlow, this.myConstraints.myAllowStubToAST, this.myConstraints.myOrigin);
    }

    public boolean allowDataFlow(PsiElement element) {
        return this.myConstraints.myAllowDataFlow || this.inOrigin(element);
    }

    public boolean allowReturnTypes(PsiElement element) {
        return this.myConstraints.myAllowDataFlow || this.inOrigin(element);
    }

    public boolean allowCallContext(@NotNull PsiElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(1);
        }
        return this.myConstraints.myAllowCallContext && this.inOrigin(element);
    }

    @NotNull
    public static TypeEvalContext codeCompletion(@NotNull Project project, @Nullable PsiFile origin) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(2);
        }
        return TypeEvalContext.getContextFromCache(project, new TypeEvalContext(true, true, true, origin));
    }

    public static TypeEvalContext userInitiated(@NotNull Project project, @Nullable PsiFile origin) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(3);
        }
        return TypeEvalContext.getContextFromCache(project, new TypeEvalContext(true, true, false, origin));
    }

    public static TypeEvalContext codeAnalysis(@NotNull Project project, @Nullable PsiFile origin) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(4);
        }
        return TypeEvalContext.getContextFromCache(project, TypeEvalContext.buildCodeAnalysisContext(origin));
    }

    public static TypeEvalContext codeInsightFallback(@Nullable Project project) {
        TypeEvalContext anchor = new TypeEvalContext(false, false, false, null);
        if (project != null) {
            return TypeEvalContext.getContextFromCache(project, anchor);
        }
        return anchor;
    }

    public static TypeEvalContext deepCodeInsight(@NotNull Project project) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(5);
        }
        return TypeEvalContext.getContextFromCache(project, new TypeEvalContext(false, true, false, null));
    }

    private static TypeEvalContext buildCodeAnalysisContext(@Nullable PsiFile origin) {
        if (Registry.is((String)"python.optimized.type.eval.context")) {
            return new OptimizedTypeEvalContext(false, false, false, origin);
        }
        return new TypeEvalContext(false, false, false, origin);
    }

    @NotNull
    private static TypeEvalContext getContextFromCache(@NotNull Project project, @NotNull TypeEvalContext context) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(6);
        }
        if (context == null) {
            TypeEvalContext.$$$reportNull$$$0(7);
        }
        TypeEvalContext typeEvalContext = ((TypeEvalContextCache)project.getService(TypeEvalContextCache.class)).getContext(context);
        if (typeEvalContext == null) {
            TypeEvalContext.$$$reportNull$$$0(8);
        }
        return typeEvalContext;
    }

    public TypeEvalContext withTracing() {
        if (this.myTrace == null) {
            this.myTrace = new ArrayList<String>();
        }
        return this;
    }

    public void trace(String message, Object ... args) {
        if (this.myTrace != null) {
            this.myTrace.add(this.myTraceIndent + String.format(message, args));
        }
    }

    public void traceIndent() {
        if (this.myTrace != null) {
            this.myTraceIndent = this.myTraceIndent + "  ";
        }
    }

    public void traceUnindent() {
        if (this.myTrace != null && this.myTraceIndent.length() >= 2) {
            this.myTraceIndent = this.myTraceIndent.substring(0, this.myTraceIndent.length() - 2);
        }
    }

    public String printTrace() {
        return StringUtil.join(this.myTrace, (String)"\n");
    }

    public boolean tracing() {
        return this.myTrace != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public <R> R assumeType(@NotNull PyTypedElement element, @Nullable PyType type2, @NotNull Function<TypeEvalContext, R> func) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(9);
        }
        if (func == null) {
            TypeEvalContext.$$$reportNull$$$0(10);
        }
        if (this.getKnownType(element) != null) {
            return null;
        }
        AssumptionContext context = new AssumptionContext(this, element, type2);
        R result2 = null;
        try {
            result2 = func.apply(context);
        }
        finally {
            element.getManager().dropResolveCaches();
        }
        return result2;
    }

    @ApiStatus.Internal
    public boolean hasAssumptions() {
        return this instanceof AssumptionContext;
    }

    @Nullable
    protected PyType getKnownType(@NotNull PyTypedElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(11);
        }
        if (element instanceof PyInstantTypeProvider) {
            return element.getType(this, Key.INSTANCE);
        }
        PyType cachedType = this.myEvaluated.get(element);
        if (cachedType != null) {
            TypeEvalContext.assertValid(cachedType, element);
            return cachedType;
        }
        return null;
    }

    @Nullable
    protected PyType getKnownReturnType(@NotNull PyCallable callable) {
        PyType cachedType;
        if (callable == null) {
            TypeEvalContext.$$$reportNull$$$0(12);
        }
        if ((cachedType = this.myEvaluatedReturn.get(callable)) != null) {
            TypeEvalContext.assertValid(cachedType, callable);
            return cachedType;
        }
        return null;
    }

    private static boolean isLibraryElement(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(13);
        }
        VirtualFile vFile = (containingFile = element.getContainingFile()) == null ? null : containingFile.getOriginalFile().getVirtualFile();
        return vFile != null && ("pyi".equals(vFile.getExtension()) || ProjectFileIndex.getInstance((Project)element.getProject()).isInLibrary(vFile));
    }

    @NotNull
    private TypeEvalContext getLibraryContext(@NotNull Project project) {
        if (project == null) {
            TypeEvalContext.$$$reportNull$$$0(14);
        }
        TypeEvalConstraints constraints = new TypeEvalConstraints(this.myConstraints.myAllowDataFlow, this.myConstraints.myAllowStubToAST, this.myConstraints.myAllowCallContext, this.myConstraints.myOrigin != null ? this.myConstraints.myOrigin.getOriginalFile() : null);
        TypeEvalContext typeEvalContext = ((TypeEvalContextCache)project.getService(TypeEvalContextCache.class)).getLibraryContext(new LibraryTypeEvalContext(constraints));
        if (typeEvalContext == null) {
            TypeEvalContext.$$$reportNull$$$0(15);
        }
        return typeEvalContext;
    }

    protected boolean canDelegateToLibraryContext(PyTypedElement element) {
        return Registry.is((String)"python.use.separated.libraries.type.cache") && TypeEvalContext.isLibraryElement((PsiElement)element);
    }

    @Nullable
    public PyType getType(@NotNull PyTypedElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(16);
        }
        if (this.canDelegateToLibraryContext(element)) {
            TypeEvalContext context = this.getLibraryContext(element.getProject());
            return context.getType(element);
        }
        PyType knownType = this.getKnownType(element);
        if (knownType != null) {
            return knownType == PyNullType.INSTANCE ? null : knownType;
        }
        return (PyType)RecursionManager.doPreventingRecursion((Object)Pair.create((Object)element, (Object)this), (boolean)false, () -> {
            PyType type2 = element.getType(this, Key.INSTANCE);
            TypeEvalContext.assertValid(type2, element);
            this.myEvaluated.put(element, type2 == null ? PyNullType.INSTANCE : type2);
            return type2;
        });
    }

    @Nullable
    public PyType getReturnType(@NotNull PyCallable callable) {
        if (callable == null) {
            TypeEvalContext.$$$reportNull$$$0(17);
        }
        if (this.canDelegateToLibraryContext(callable)) {
            TypeEvalContext context = this.getLibraryContext(callable.getProject());
            return context.getReturnType(callable);
        }
        PyType knownReturnType = this.getKnownReturnType(callable);
        if (knownReturnType != null) {
            return knownReturnType == PyNullType.INSTANCE ? null : knownReturnType;
        }
        return (PyType)RecursionManager.doPreventingRecursion((Object)Pair.create((Object)callable, (Object)this), (boolean)false, () -> {
            PyType type2 = callable.getReturnType(this, Key.INSTANCE);
            TypeEvalContext.assertValid(type2, callable);
            this.myEvaluatedReturn.put(callable, type2 == null ? PyNullType.INSTANCE : type2);
            return type2;
        });
    }

    @ApiStatus.Experimental
    @NotNull
    public ProcessingContext getProcessingContext() {
        ProcessingContext processingContext = this.myProcessingContext.get();
        if (processingContext == null) {
            TypeEvalContext.$$$reportNull$$$0(18);
        }
        return processingContext;
    }

    private static void assertValid(@Nullable PyType result2, @NotNull PyTypedElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(19);
        }
        if (result2 != null) {
            result2.assertValid(element.toString());
        }
    }

    public boolean maySwitchToAST(@NotNull PsiElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(20);
        }
        return this.myConstraints.myAllowStubToAST || this.inOrigin(element);
    }

    @Nullable
    public PsiFile getOrigin() {
        return this.myConstraints.myOrigin;
    }

    @ApiStatus.Internal
    @NotNull
    public Map<Pair<PyExpression, Object>, PyType> getContextTypeCache() {
        Map<Pair<PyExpression, Object>, PyType> map2 = this.contextTypeCache;
        if (map2 == null) {
            TypeEvalContext.$$$reportNull$$$0(21);
        }
        return map2;
    }

    @ApiStatus.Internal
    @NotNull
    public TypeEvalConstraints getConstraints() {
        TypeEvalConstraints typeEvalConstraints = this.myConstraints;
        if (typeEvalConstraints == null) {
            TypeEvalContext.$$$reportNull$$$0(22);
        }
        return typeEvalConstraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeEvalContext context = (TypeEvalContext)o;
        return this.myConstraints.equals(context.myConstraints);
    }

    public int hashCode() {
        return this.myConstraints.hashCode();
    }

    private boolean inOrigin(@NotNull PsiElement element) {
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(23);
        }
        return this.myConstraints.myOrigin == element.getContainingFile() || this.myConstraints.myOrigin == TypeEvalContext.getContextFile(element);
    }

    private static PsiFile getContextFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            TypeEvalContext.$$$reportNull$$$0(24);
        }
        if ((file = element.getContainingFile()) == null) {
            return null;
        }
        PsiElement context = file.getContext();
        if (context == null) {
            return file;
        }
        return TypeEvalContext.getContextFile(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 15, 18, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 15: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/TypeEvalContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/TypeEvalContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFromCache";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingContext";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTypeCache";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "allowCallContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "codeCompletion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "userInitiated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "codeAnalysis";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepCodeInsight";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContextFromCache";
                break;
            }
            case 8: 
            case 15: 
            case 18: 
            case 21: 
            case 22: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assumeType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getKnownType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getKnownReturnType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryContext";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "assertValid";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "maySwitchToAST";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "inOrigin";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContextFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 15, 18, 21, 22 -> new IllegalStateException(string);
        };
    }

    static final class OptimizedTypeEvalContext
    extends TypeEvalContext {
        private volatile TypeEvalContext codeInsightFallback;

        OptimizedTypeEvalContext(boolean allowDataFlow, boolean allowStubToAST, boolean allowCallContext, @Nullable PsiFile origin) {
            super(allowDataFlow, allowStubToAST, allowCallContext, origin);
        }

        private boolean shouldSwitchToFallbackContext(PsiElement element) {
            PyExpressionCodeFragment codeFragment;
            PsiElement context;
            PsiFile file = element.getContainingFile();
            if (file instanceof PyExpressionCodeFragment && (context = (codeFragment = (PyExpressionCodeFragment)file).getContext()) != null) {
                file = context.getContainingFile();
            }
            TypeEvalConstraints constraints = this.getConstraints();
            return constraints.myOrigin != null && file != constraints.myOrigin && file instanceof PyFile && !constraints.myAllowDataFlow && !constraints.myAllowStubToAST && !constraints.myAllowCallContext;
        }

        private TypeEvalContext getFallbackContext(Project project) {
            if (this.codeInsightFallback == null) {
                this.codeInsightFallback = OptimizedTypeEvalContext.codeInsightFallback(project);
            }
            return this.codeInsightFallback;
        }

        @Override
        @Nullable
        protected PyType getKnownType(@NotNull PyTypedElement element) {
            if (element == null) {
                OptimizedTypeEvalContext.$$$reportNull$$$0(0);
            }
            if (this.shouldSwitchToFallbackContext((PsiElement)element)) {
                return this.getFallbackContext(element.getProject()).getKnownType(element);
            }
            return super.getKnownType(element);
        }

        @Override
        @Nullable
        protected PyType getKnownReturnType(@NotNull PyCallable callable) {
            if (callable == null) {
                OptimizedTypeEvalContext.$$$reportNull$$$0(1);
            }
            if (this.shouldSwitchToFallbackContext((PsiElement)callable)) {
                return this.getFallbackContext(callable.getProject()).getKnownReturnType(callable);
            }
            return super.getKnownReturnType(callable);
        }

        @Override
        @Nullable
        public PyType getType(@NotNull PyTypedElement element) {
            if (element == null) {
                OptimizedTypeEvalContext.$$$reportNull$$$0(2);
            }
            if (this.shouldSwitchToFallbackContext((PsiElement)element)) {
                return this.getFallbackContext(element.getProject()).getType(element);
            }
            return super.getType(element);
        }

        @Override
        @Nullable
        public PyType getReturnType(@NotNull PyCallable callable) {
            if (callable == null) {
                OptimizedTypeEvalContext.$$$reportNull$$$0(3);
            }
            if (this.shouldSwitchToFallbackContext((PsiElement)callable)) {
                return this.getFallbackContext(callable.getProject()).getReturnType(callable);
            }
            return super.getReturnType(callable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/types/TypeEvalContext$OptimizedTypeEvalContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getKnownType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getKnownReturnType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getReturnType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AssumptionContext
    extends TypeEvalContext {
        @NotNull
        final TypeEvalContext myParent;

        private AssumptionContext(@NotNull TypeEvalContext parent, @NotNull PyTypedElement element, @Nullable PyType type2) {
            if (parent == null) {
                AssumptionContext.$$$reportNull$$$0(0);
            }
            if (element == null) {
                AssumptionContext.$$$reportNull$$$0(1);
            }
            super(parent.myConstraints);
            this.myParent = parent;
            this.myEvaluated.put(element, type2 == null ? PyNullType.INSTANCE : type2);
        }

        @Override
        @Nullable
        protected PyType getKnownType(@NotNull PyTypedElement element) {
            PyType knownType;
            if (element == null) {
                AssumptionContext.$$$reportNull$$$0(2);
            }
            if ((knownType = super.getKnownType(element)) != null) {
                return knownType;
            }
            return this.myParent.getKnownType(element);
        }

        @Override
        @Nullable
        protected PyType getKnownReturnType(@NotNull PyCallable callable) {
            PyType knownReturnType;
            if (callable == null) {
                AssumptionContext.$$$reportNull$$$0(3);
            }
            if ((knownReturnType = super.getKnownReturnType(callable)) != null) {
                return knownReturnType;
            }
            return this.myParent.getKnownReturnType(callable);
        }

        @Override
        public void trace(String message, Object ... args) {
            this.myParent.trace(message, args);
        }

        @Override
        public void traceIndent() {
            this.myParent.traceIndent();
        }

        @Override
        public void traceUnindent() {
            this.myParent.traceUnindent();
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/types/TypeEvalContext$AssumptionContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getKnownType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getKnownReturnType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Key {
        private static final Key INSTANCE = new Key();

        private Key() {
        }
    }

    static final class LibraryTypeEvalContext
    extends TypeEvalContext {
        private LibraryTypeEvalContext(@NotNull TypeEvalConstraints constraints) {
            if (constraints == null) {
                LibraryTypeEvalContext.$$$reportNull$$$0(0);
            }
            super(constraints);
        }

        @Override
        protected boolean canDelegateToLibraryContext(PyTypedElement element) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/jetbrains/python/psi/types/TypeEvalContext$LibraryTypeEvalContext", "<init>"));
        }
    }

    private static class PyNullType
    implements PyType {
        private static final PyNullType INSTANCE = new PyNullType();

        private PyNullType() {
        }

        @Override
        @Nullable
        public List<? extends RatedResolveResult> resolveMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
            if (name2 == null) {
                PyNullType.$$$reportNull$$$0(0);
            }
            if (direction == null) {
                PyNullType.$$$reportNull$$$0(1);
            }
            if (resolveContext == null) {
                PyNullType.$$$reportNull$$$0(2);
            }
            return List.of();
        }

        @Override
        public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @Nullable
        public String getName() {
            return "null";
        }

        @Override
        public boolean isBuiltin() {
            return false;
        }

        @Override
        public void assertValid(String message) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "direction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveContext";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/types/TypeEvalContext$PyNullType";
            objectArray[2] = "resolveMember";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

