/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.PyWithContextExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImplicitImportNameDefiner;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import com.jetbrains.python.psi.impl.stubs.PyVersionSpecificStubBaseKt;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDefUseUtil {
    private static final int MAX_CONTROL_FLOW_SIZE = 200;

    private PyDefUseUtil() {
    }

    @NotNull
    public static List<Instruction> getLatestDefs(@NotNull ScopeOwner block, @NotNull String varName, @NotNull PsiElement anchor, boolean acceptTypeAssertions, boolean acceptImplicitImports, @NotNull TypeEvalContext context) {
        if (block == null) {
            PyDefUseUtil.$$$reportNull$$$0(0);
        }
        if (varName == null) {
            PyDefUseUtil.$$$reportNull$$$0(1);
        }
        if (anchor == null) {
            PyDefUseUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyDefUseUtil.$$$reportNull$$$0(3);
        }
        return PyDefUseUtil.getLatestDefs(ControlFlowCache.getControlFlow(block), varName, anchor, acceptTypeAssertions, acceptImplicitImports, context);
    }

    @NotNull
    public static List<Instruction> getLatestDefs(@NotNull ControlFlow controlFlow, @NotNull String varName, @NotNull PsiElement anchor, boolean acceptTypeAssertions, boolean acceptImplicitImports, @NotNull TypeEvalContext context) {
        Instruction[] instructions;
        int startNum;
        if (controlFlow == null) {
            PyDefUseUtil.$$$reportNull$$$0(4);
        }
        if (varName == null) {
            PyDefUseUtil.$$$reportNull$$$0(5);
        }
        if (anchor == null) {
            PyDefUseUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyDefUseUtil.$$$reportNull$$$0(7);
        }
        if ((startNum = PyDefUseUtil.findStartInstructionId(anchor, instructions = controlFlow.getInstructions())) < 0) {
            List<Instruction> list = Collections.emptyList();
            if (list == null) {
                PyDefUseUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        LanguageLevel languageLevel = PythonLanguageLevelPusher.getLanguageLevelForFile(anchor.getContainingFile());
        LinkedHashSet result2 = new LinkedHashSet();
        HashMap pendingTypeGuard = new HashMap();
        ControlFlowUtil.iteratePrev((int)startNum, (Instruction[])instructions, instruction -> {
            PyImplicitImportNameDefiner implicit;
            ConditionalInstruction conditionalInstruction;
            PsiElement patt5656$temp;
            PyWithContextExitInstruction withExit;
            if (instruction instanceof PyWithContextExitInstruction && !(withExit = (PyWithContextExitInstruction)((Object)instruction)).isSuppressingExceptions(context)) {
                return ControlFlowUtil.Operation.CONTINUE;
            }
            if (acceptTypeAssertions && instruction instanceof CallInstruction) {
                CallInstruction callInstruction = (CallInstruction)((Object)instruction);
                ConditionalInstruction typeGuardInstruction = (ConditionalInstruction)pendingTypeGuard.get(instruction.getElement());
                if (typeGuardInstruction != null) {
                    result2.add(typeGuardInstruction);
                    return ControlFlowUtil.Operation.CONTINUE;
                }
                if (PyDefUseUtil.isNotBackEdge(instruction.num(), startNum) && context.getOrigin() == callInstruction.getElement().getContainingFile()) {
                    TypeEvalContext newContext;
                    TypeEvalContext typeEvalContext = newContext = 200 > instructions.length ? TypeEvalContext.codeAnalysis(context.getOrigin().getProject(), context.getOrigin()) : TypeEvalContext.codeInsightFallback(context.getOrigin().getProject());
                    if (callInstruction.isNoReturnCall(newContext)) {
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                }
            }
            PsiElement element = instruction.getElement();
            if (PyDefUseUtil.isNotBackEdge(instruction.num(), startNum) && acceptTypeAssertions && instruction instanceof ConditionalInstruction && (patt5656$temp = (conditionalInstruction = (ConditionalInstruction)instruction).getCondition()) instanceof PyTypedElement) {
                PyNarrowedType narrowedType;
                TypeEvalContext newContext;
                PyType patt6202$temp;
                PyTypedElement typedElement = (PyTypedElement)patt5656$temp;
                if (context.getOrigin() == typedElement.getContainingFile() && (patt6202$temp = (newContext = 200 > instructions.length ? TypeEvalContext.codeAnalysis(context.getOrigin().getProject(), context.getOrigin()) : TypeEvalContext.codeInsightFallback(context.getOrigin().getProject())).getType(typedElement)) instanceof PyNarrowedType && (narrowedType = (PyNarrowedType)patt6202$temp).isBound() && narrowedType.getQname().equals(varName)) {
                    pendingTypeGuard.put(narrowedType.getOriginal(), conditionalInstruction);
                }
            }
            if (instruction instanceof ReadWriteInstruction) {
                String name2;
                ReadWriteInstruction rwInstruction = (ReadWriteInstruction)((Object)instruction);
                ReadWriteInstruction.ACCESS access = rwInstruction.getAccess();
                if ((access.isWriteAccess() || acceptTypeAssertions && access.isAssertTypeAccess() && PyDefUseUtil.isNotBackEdge(instruction.num(), startNum)) && Comparing.strEqual((String)(name2 = PyDefUseUtil.elementName(element)), (String)varName)) {
                    if (PyDefUseUtil.isReachableWithVersionChecks((Instruction)rwInstruction, languageLevel)) {
                        result2.add(rwInstruction);
                    }
                    return ControlFlowUtil.Operation.CONTINUE;
                }
            } else if (acceptImplicitImports && element instanceof PyImplicitImportNameDefiner && !(implicit = (PyImplicitImportNameDefiner)element).multiResolveName(varName).isEmpty()) {
                if (PyDefUseUtil.isReachableWithVersionChecks(instruction, languageLevel)) {
                    result2.add(instruction);
                }
                return ControlFlowUtil.Operation.CONTINUE;
            }
            return ControlFlowUtil.Operation.NEXT;
        });
        return new ArrayList<Instruction>(result2);
    }

    private static boolean isNotBackEdge(int instNum, int startNum) {
        if (Registry.is((String)"python.use.better.control.flow.type.inference")) {
            return true;
        }
        return instNum < startNum;
    }

    private static int findStartInstructionId(@NotNull PsiElement startAnchor, Instruction @NotNull [] instructions) {
        Collection pred;
        int instr;
        if (startAnchor == null) {
            PyDefUseUtil.$$$reportNull$$$0(9);
        }
        if (instructions == null) {
            PyDefUseUtil.$$$reportNull$$$0(10);
        }
        Object realCfgAnchor = startAnchor;
        PyAugAssignmentStatement augAssignment = PyAugAssignmentStatementNavigator.getStatementByTarget(startAnchor);
        if (augAssignment != null) {
            realCfgAnchor = augAssignment;
        }
        if ((instr = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)realCfgAnchor)) < 0) {
            return instr;
        }
        if (startAnchor instanceof PyTargetExpression && !(pred = instructions[instr].allPred()).isEmpty()) {
            instr = ((Instruction)pred.iterator().next()).num();
        }
        return instr;
    }

    private static boolean isReachableWithVersionChecks(@NotNull Instruction instruction, @NotNull LanguageLevel languageLevel) {
        PsiElement element;
        if (instruction == null) {
            PyDefUseUtil.$$$reportNull$$$0(11);
        }
        if (languageLevel == null) {
            PyDefUseUtil.$$$reportNull$$$0(12);
        }
        if ((element = instruction.getElement()) == null) {
            return true;
        }
        Version version2 = new Version(languageLevel.getMajorVersion(), languageLevel.getMinorVersion(), 0);
        return PyVersionSpecificStubBaseKt.evaluateVersionsForElement(element).contains((Comparable)version2);
    }

    @Nullable
    private static String elementName(PsiElement element) {
        QualifiedName qname;
        if (element instanceof PyImportElement) {
            return ((PyImportElement)element).getVisibleName();
        }
        if ((element instanceof PyReferenceExpression || element instanceof PyTargetExpression) && (qname = ((PyQualifiedExpression)element).asQualifiedName()) != null) {
            return qname.toString();
        }
        return element instanceof PyElement ? ((PyElement)element).getName() : null;
    }

    public static PsiElement @NotNull [] getPostRefs(@NotNull ScopeOwner block, @NotNull PyTargetExpression var, PyExpression anchor) {
        ControlFlow controlFlow;
        Instruction[] instructions;
        int instr;
        if (block == null) {
            PyDefUseUtil.$$$reportNull$$$0(13);
        }
        if (var == null) {
            PyDefUseUtil.$$$reportNull$$$0(14);
        }
        if ((instr = ControlFlowUtil.findInstructionNumberByElement((Instruction[])(instructions = (controlFlow = ControlFlowCache.getControlFlow(block)).getInstructions()), (PsiElement)anchor)) < 0) {
            if (PyElement.EMPTY_ARRAY == null) {
                PyDefUseUtil.$$$reportNull$$$0(15);
            }
            return PyElement.EMPTY_ARRAY;
        }
        boolean[] visited = new boolean[instructions.length];
        HashSet<PyElement> result2 = new HashSet<PyElement>();
        for (Instruction instruction : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction.num(), visited, result2);
        }
        PsiElement[] psiElementArray = (PsiElement[])result2.toArray(PyElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            PyDefUseUtil.$$$reportNull$$$0(16);
        }
        return psiElementArray;
    }

    private static void getPostRefs(@NotNull PyTargetExpression var, Instruction[] instructions, int instr, boolean @NotNull [] visited, @NotNull Collection<PyElement> result2) {
        ReadWriteInstruction instruction;
        PsiElement element;
        String name2;
        if (var == null) {
            PyDefUseUtil.$$$reportNull$$$0(17);
        }
        if (result2 == null) {
            PyDefUseUtil.$$$reportNull$$$0(18);
        }
        if (visited == null) {
            PyDefUseUtil.$$$reportNull$$$0(19);
        }
        if (visited[instr]) {
            return;
        }
        visited[instr] = true;
        Instruction instruction2 = instructions[instr];
        if (instruction2 instanceof ReadWriteInstruction && Comparing.strEqual((String)(name2 = PyDefUseUtil.elementName(element = (instruction = (ReadWriteInstruction)instruction2).getElement())), (String)var.getName())) {
            ReadWriteInstruction.ACCESS access = instruction.getAccess();
            if (access.isWriteAccess()) {
                return;
            }
            result2.add((PyElement)instruction.getElement());
        }
        for (Instruction instruction3 : instructions[instr].allSucc()) {
            PyDefUseUtil.getPostRefs(var, instructions, instruction3.num(), visited, result2);
        }
    }

    public static boolean isDefinedBefore(@NotNull PsiElement searched, @NotNull PsiElement target) {
        Instruction[] instructions;
        int index;
        if (searched == null) {
            PyDefUseUtil.$$$reportNull$$$0(20);
        }
        if (target == null) {
            PyDefUseUtil.$$$reportNull$$$0(21);
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(searched);
        Ref definedBefore = Ref.create((Object)false);
        if (scopeOwner != null && scopeOwner == ScopeUtil.getScopeOwner(target) && (index = ControlFlowUtil.findInstructionNumberByElement((Instruction[])(instructions = ControlFlowCache.getControlFlow(scopeOwner).getInstructions()), (PsiElement)target)) >= 0) {
            ControlFlowUtil.iteratePrev((int)index, (Instruction[])instructions, instruction -> {
                if (instruction.getElement() == searched) {
                    boolean isWriteAccess;
                    boolean isImport = searched instanceof PyImportedNameDefiner;
                    boolean bl = isWriteAccess = instruction instanceof ReadWriteInstruction && ((ReadWriteInstruction)((Object)instruction)).getAccess().isWriteAccess();
                    if (isImport || isWriteAccess) {
                        definedBefore.set((Object)true);
                        return ControlFlowUtil.Operation.BREAK;
                    }
                }
                return ControlFlowUtil.Operation.NEXT;
            });
        }
        return (Boolean)definedBefore.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyDefUseUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startAnchor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searched";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyDefUseUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDefs";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLatestDefs";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findStartInstructionId";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReachableWithVersionChecks";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPostRefs";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDefinedBefore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 15, 16 -> new IllegalStateException(string);
        };
    }

    public static class InstructionNotFoundException
    extends RuntimeException {
    }
}

