/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.packaging.common.PythonPackageManagementListener;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkCoroutineService;
import com.jetbrains.python.sdk.PythonSdkUpdateProjectActivityKt;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/sdk/PythonSdkUpdateProjectActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshPaths", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class PythonSdkUpdateProjectActivity
implements ProjectActivity,
DumbAware {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        Application application = ApplicationManager.getApplication();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(PythonPackageManager.Companion.getPACKAGE_MANAGEMENT_TOPIC(), (Object)new PythonPackageManagementListener(messageBusConnection, this, project){
            final /* synthetic */ MessageBusConnection $messageBusConnection;
            final /* synthetic */ PythonSdkUpdateProjectActivity this$0;
            final /* synthetic */ Project $project;
            {
                this.$messageBusConnection = $messageBusConnection;
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void packagesChanged(Sdk sdk2) {
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                boolean $i$f$service = false;
                Class<PythonSdkCoroutineService> serviceClass$iv = PythonSdkCoroutineService.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                CoroutineScopeKt.cancelOnDispose((Job)BuildersKt.launch$default((CoroutineScope)((PythonSdkCoroutineService)object).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$project, sdk2, null){
                    int label;
                    final /* synthetic */ PythonSdkUpdateProjectActivity this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Sdk $sdk;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$sdk = $sdk;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = PythonSdkUpdateProjectActivity.access$refreshPaths(this.this$0, this.$project, this.$sdk, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null), (Disposable)((Disposable)this.$messageBusConnection));
            }

            public void outdatedPackagesChanged(Sdk sdk2) {
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                DaemonCodeAnalyzer.getInstance((Project)this.$project).restart();
            }
        });
        if (application.isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        if (PythonSdkUpdateProjectActivityKt.dropUpdaterInHeadless()) {
            return Unit.INSTANCE;
        }
        if (project.isDisposed()) {
            return Unit.INSTANCE;
        }
        for (Sdk sdk2 : PythonSdkUpdater.getPythonSdks(project)) {
            PythonSdkUpdater.scheduleUpdate(sdk2, project);
        }
        return Unit.INSTANCE;
    }

    private final Object refreshPaths(Project project, Sdk sdk2, Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.edtWriteAction(() -> PythonSdkUpdateProjectActivity.refreshPaths$lambda$0(sdk2, project), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit refreshPaths$lambda$0(Sdk $sdk, Project $project) {
        if (!ApplicationManager.getApplication().isUnitTestMode() || !SystemInfoRt.isWindows) {
            VirtualFile[] virtualFileArray = $sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        }
        VirtualFile virtualFile = PythonSdkUtil.getSitePackagesDirectory($sdk);
        if (virtualFile != null) {
            virtualFile.refresh(true, true);
        }
        VirtualFile virtualFile2 = PySdkExtKt.getAssociatedModuleDir($sdk);
        if (virtualFile2 != null) {
            virtualFile2.refresh(true, false);
        }
        DaemonCodeAnalyzer.getInstance((Project)$project).restart();
        PythonSdkUpdater.scheduleUpdate($sdk, $project, false);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$refreshPaths(PythonSdkUpdateProjectActivity $this, Project project, Sdk sdk2, Continuation $completion) {
        return $this.refreshPaths(project, sdk2, (Continuation<? super Unit>)$completion);
    }
}

