/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.catboostOld;

import com.jetbrains.ml.tools.model.catboostOld.ModelReader;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/PathModelReader;", "Lcom/jetbrains/ml/tools/model/catboostOld/ModelReader;", "rootPath", "Ljava/nio/file/Path;", "binaryRelativePath", "metadataRelativePath", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "openModelBinaryStream", "Ljava/io/InputStream;", "readBinaryFeatures", "", "readCategoricalFeatures", "readFeatureOrder", "", "readFloatFeatures", "readKnownFeatures", "readMetadataFile", "filename", "readVersion", "ml-tools"})
public final class PathModelReader
implements ModelReader {
    @NotNull
    private final Path rootPath;
    @NotNull
    private final Path binaryRelativePath;
    @NotNull
    private final Path metadataRelativePath;

    public PathModelReader(@NotNull Path rootPath, @NotNull Path binaryRelativePath, @NotNull Path metadataRelativePath) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)binaryRelativePath, (String)"binaryRelativePath");
        Intrinsics.checkNotNullParameter((Object)metadataRelativePath, (String)"metadataRelativePath");
        this.rootPath = rootPath;
        this.binaryRelativePath = binaryRelativePath;
        this.metadataRelativePath = metadataRelativePath;
    }

    @Override
    @NotNull
    public String readBinaryFeatures() {
        return this.readMetadataFile("binary.json");
    }

    @Override
    @NotNull
    public String readFloatFeatures() {
        return this.readMetadataFile("float.json");
    }

    @Override
    @NotNull
    public String readCategoricalFeatures() {
        return this.readMetadataFile("categorical.json");
    }

    @Override
    @NotNull
    public String readKnownFeatures() {
        return this.readMetadataFile("all_features.json");
    }

    @Override
    @NotNull
    public List<String> readFeatureOrder() {
        return StringsKt.lines((CharSequence)this.readMetadataFile("features_order.txt"));
    }

    @Override
    @Nullable
    public String readVersion() {
        return null;
    }

    @Override
    @NotNull
    public InputStream openModelBinaryStream() {
        Path path = this.rootPath.resolve(this.binaryRelativePath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        Path path2 = path.resolve("model.bin");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path2, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
        InputStream modelInputStream = inputStream;
        return modelInputStream;
    }

    private final String readMetadataFile(String filename) {
        Path path = this.rootPath.resolve(this.metadataRelativePath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        Path path2 = path.resolve(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
        return PathsKt.readText$default((Path)path2, null, (int)1, null);
    }
}

