# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Rule message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class Rule < Message
      ##
      # The location of the `Rule` keyword
      ##
      attr_reader :location

      ##
      # All the tags placed above the `Rule` keyword
      ##
      attr_reader :tags

      attr_reader :keyword

      attr_reader :name

      attr_reader :description

      attr_reader :children

      attr_reader :id

      def initialize(
        location: Location.new,
        tags: [],
        keyword: '',
        name: '',
        description: '',
        children: [],
        id: ''
      )
        @location = location
        @tags = tags
        @keyword = keyword
        @name = name
        @description = description
        @children = children
        @id = id
        super()
      end

      ##
      # Returns a new Rule from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Rule.from_h(some_hash) # => #<Cucumber::Messages::Rule:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          location: Location.from_h(hash[:location]),
          tags: hash[:tags]&.map { |item| Tag.from_h(item) },
          keyword: hash[:keyword],
          name: hash[:name],
          description: hash[:description],
          children: hash[:children]&.map { |item| RuleChild.from_h(item) },
          id: hash[:id]
        )
      end
    end
  end
end
