/******************************************************************************
* Copyright (C) 2022-2023, Advanced Micro Devices, Inc. All Rights Reserved.  *
* SPDX-License-Identifier: MIT
******************************************************************************/


/*****************************************************************************/
/**
* @file xaie_util_events_aieml.h
* @{
*
* This file contains function implementations for AIE utilities
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who     Date     Changes
* ----- ------  -------- -----------------------------------------------------
* 1.0   Keerthanna 03/10/2023  Initial creation
* </pre>
*
******************************************************************************/

/***************************** Include Files *********************************/
#include "xaie_feature_config.h"
#include "xaie_events.h"
#include "xaie_events_aieml.h"

#ifdef XAIE_FEATURE_UTIL_STATUS_ENABLE

/**************************** Variable Definitions *******************************/

/* Event string lookup table indexed by event number */
static const char* XAie_EventCoreModStrings[][128] = {

	{
		[XAIEML_EVENTS_MEM_NONE] 			   =   "NONE_MEM",
		[XAIEML_EVENTS_MEM_TRUE]                           =   "TRUE_MEM",
		[XAIEML_EVENTS_MEM_GROUP_0]                        =   "GROUP_0_MEM",
		[XAIEML_EVENTS_MEM_TIMER_SYNC]                     =   "TIMER_SYNC_MEM",
		[XAIEML_EVENTS_MEM_TIMER_VALUE_REACHED]            =   "TIMER_VALUE_REACHED_MEM",
		[XAIEML_EVENTS_MEM_PERF_CNT_0]                     =   "PERF_CNT_0_MEM",
		[XAIEML_EVENTS_MEM_PERF_CNT_1]                     =   "PERF_CNT_1_MEM",
		[XAIEML_EVENTS_MEM_COMBO_EVENT_0]                  =   "COMBO_EVENT_0_MEM",
		[XAIEML_EVENTS_MEM_COMBO_EVENT_1]                  =   "COMBO_EVENT_1_MEM",
		[XAIEML_EVENTS_MEM_COMBO_EVENT_2]                  =   "COMBO_EVENT_2_MEM",
		[XAIEML_EVENTS_MEM_COMBO_EVENT_3]                  =   "COMBO_EVENT_3_MEM",
		[XAIEML_EVENTS_MEM_GROUP_WATCHPOINT]               =   "GROUP_WATCHPOINT_MEM",
		[XAIEML_EVENTS_MEM_WATCHPOINT_0]                   =   "WATCHPOINT_0_MEM",
		[XAIEML_EVENTS_MEM_WATCHPOINT_1]                   =   "WATCHPOINT_1_MEM",
		[XAIEML_EVENTS_MEM_GROUP_DMA_ACTIVITY]             =   "GROUP_DMA_ACTIVITY_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_0_FINISHED_BD]         =   "DMA_S2MM_0_FINISHED_BD_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_1_FINISHED_BD]         =   "DMA_S2MM_1_FINISHED_BD_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_0_FINISHED_BD]         =   "DMA_MM2S_0_FINISHED_BD_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_1_FINISHED_BD]         =   "DMA_MM2S_1_FINISHED_BD_MEM",
		[XAIEML_EVENTS_MEM_GROUP_LOCK]                     =   "GROUP_LOCK_MEM",
		[XAIEML_EVENTS_MEM_LOCK_0_REL]                     =   "LOCK_0_REL_MEM",
		[XAIEML_EVENTS_MEM_LOCK_1_REL]                     =   "LOCK_1_REL_MEM",
		[XAIEML_EVENTS_MEM_LOCK_2_REL]                     =   "LOCK_2_REL_MEM",
		[XAIEML_EVENTS_MEM_LOCK_3_REL]                     =   "LOCK_3_REL_MEM",
		[XAIEML_EVENTS_MEM_LOCK_4_REL]                     =   "LOCK_4_REL_MEM",
		[XAIEML_EVENTS_MEM_LOCK_5_REL]                     =   "LOCK_5_REL_MEM",
		[XAIEML_EVENTS_MEM_LOCK_6_REL]                     =   "LOCK_6_REL_MEM",
		[XAIEML_EVENTS_MEM_LOCK_7_REL]                     =   "LOCK_7_REL_MEM",
		[XAIEML_EVENTS_MEM_GROUP_MEMORY_CONFLICT]          =   "GROUP_MEMORY_CONFLICT_MEM",
		[XAIEML_EVENTS_MEM_CONFLICT_DM_BANK_0]             =   "CONFLICT_DM_BANK_0_MEM",
		[XAIEML_EVENTS_MEM_CONFLICT_DM_BANK_1]             =   "CONFLICT_DM_BANK_1_MEM",
		[XAIEML_EVENTS_MEM_CONFLICT_DM_BANK_2]             =   "CONFLICT_DM_BANK_2_MEM",
		[XAIEML_EVENTS_MEM_CONFLICT_DM_BANK_3]             =   "CONFLICT_DM_BANK_3_MEM",
		[XAIEML_EVENTS_MEM_CONFLICT_DM_BANK_4]             =   "CONFLICT_DM_BANK_4_MEM",
		[XAIEML_EVENTS_MEM_CONFLICT_DM_BANK_5]             =   "CONFLICT_DM_BANK_5_MEM",
		[XAIEML_EVENTS_MEM_CONFLICT_DM_BANK_6]             =   "CONFLICT_DM_BANK_6_MEM",
		[XAIEML_EVENTS_MEM_CONFLICT_DM_BANK_7]             =   "CONFLICT_DM_BANK_7_MEM",
		[XAIEML_EVENTS_MEM_GROUP_ERRORS]                   =   "GROUP_ERRORS_MEM",
		[XAIEML_EVENTS_MEM_DM_ECC_ERROR_SCRUB_CORRECTED]   =   "DM_ECC_ERROR_SCRUB_CORRECTED_MEM",
		[XAIEML_EVENTS_MEM_DM_ECC_ERROR_SCRUB_2BIT]        =   "DM_ECC_ERROR_SCRUB_2BIT_MEM",
		[XAIEML_EVENTS_MEM_DM_ECC_ERROR_1BIT]              =   "DM_ECC_ERROR_1BIT_MEM",
		[XAIEML_EVENTS_MEM_DM_ECC_ERROR_2BIT]              =   "DM_ECC_ERROR_2BIT_MEM",
		[XAIEML_EVENTS_MEM_DM_PARITY_ERROR_BANK_2]         =   "DM_PARITY_ERROR_BANK_2_MEM",
		[XAIEML_EVENTS_MEM_DM_PARITY_ERROR_BANK_3]         =   "DM_PARITY_ERROR_BANK_3_MEM",
		[XAIEML_EVENTS_MEM_DM_PARITY_ERROR_BANK_4]         =   "DM_PARITY_ERROR_BANK_4_MEM",
		[XAIEML_EVENTS_MEM_DM_PARITY_ERROR_BANK_5]         =   "DM_PARITY_ERROR_BANK_5_MEM",
		[XAIEML_EVENTS_MEM_DM_PARITY_ERROR_BANK_6]         =   "DM_PARITY_ERROR_BANK_6_MEM",
		[XAIEML_EVENTS_MEM_DM_PARITY_ERROR_BANK_7]         =   "DM_PARITY_ERROR_BANK_7_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_0_ERROR]               =   "DMA_S2MM_0_ERROR_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_1_ERROR]               =   "DMA_S2MM_1_ERROR_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_0_ERROR]               =   "DMA_MM2S_0_ERROR_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_1_ERROR]               =   "DMA_MM2S_1_ERROR_MEM",
		[XAIEML_EVENTS_MEM_GROUP_BROADCAST]                =   "GROUP_BROADCAST_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_0]                    =   "BROADCAST_0_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_1]                    =   "BROADCAST_1_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_2]                    =   "BROADCAST_2_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_3]                    =   "BROADCAST_3_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_4]                    =   "BROADCAST_4_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_5]                    =   "BROADCAST_5_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_6]                    =   "BROADCAST_6_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_7]                    =   "BROADCAST_7_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_8]                    =   "BROADCAST_8_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_9]                    =   "BROADCAST_9_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_10]                   =   "BROADCAST_10_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_11]                   =   "BROADCAST_11_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_12]                   =   "BROADCAST_12_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_13]                   =   "BROADCAST_13_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_14]                   =   "BROADCAST_14_MEM",
		[XAIEML_EVENTS_MEM_BROADCAST_15]                   =   "BROADCAST_15_MEM",
		[XAIEML_EVENTS_MEM_GROUP_USER_EVENT]               =   "GROUP_USER_EVENT_MEM",
		[XAIEML_EVENTS_MEM_USER_EVENT_0]                   =   "USER_EVENT_0_MEM",
		[XAIEML_EVENTS_MEM_USER_EVENT_1]                   =   "USER_EVENT_1_MEM",
		[XAIEML_EVENTS_MEM_USER_EVENT_2]                   =   "USER_EVENT_2_MEM",
		[XAIEML_EVENTS_MEM_USER_EVENT_3]                   =   "USER_EVENT_3_MEM",
		[XAIEML_EVENTS_MEM_EDGE_DETECTION_EVENT_0]         =   "EDGE_DETECTION_EVENT_0_MEM",
		[XAIEML_EVENTS_MEM_EDGE_DETECTION_EVENT_1]         =   "EDGE_DETECTION_EVENT_1_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_0_START_TASK]          =   "DMA_S2MM_0_START_TASK_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_1_START_TASK]          =   "DMA_S2MM_1_START_TASK_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_0_START_TASK]          =   "DMA_MM2S_0_START_TASK_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_1_START_TASK]          =   "DMA_MM2S_1_START_TASK_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_0_FINISHED_TASK]       =   "DMA_S2MM_0_FINISHED_TASK_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_1_FINISHED_TASK]       =   "DMA_S2MM_1_FINISHED_TASK_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_0_FINISHED_TASK]       =   "DMA_MM2S_0_FINISHED_TASK_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_1_FINISHED_TASK]       =   "DMA_MM2S_1_FINISHED_TASK_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_0_STALLED_LOCK]        =   "DMA_S2MM_0_STALLED_LOCK_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_1_STALLED_LOCK]        =   "DMA_S2MM_1_STALLED_LOCK_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_0_STALLED_LOCK]        =   "DMA_MM2S_0_STALLED_LOCK_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_1_STALLED_LOCK]        =   "DMA_MM2S_1_STALLED_LOCK_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_0_STREAM_STARVATION]   =   "DMA_S2MM_0_STREAM_STARVATION_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_1_STREAM_STARVATION]   =   "DMA_S2MM_1_STREAM_STARVATION_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_0_STREAM_BACKPRESSURE] =   "DMA_MM2S_0_STREAM_BACKPRESSURE_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_1_STREAM_BACKPRESSURE] =   "DMA_MM2S_1_STREAM_BACKPRESSURE_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_0_MEMORY_BACKPRESSURE] =   "DMA_S2MM_0_MEMORY_BACKPRESSURE_MEM",
		[XAIEML_EVENTS_MEM_DMA_S2MM_1_MEMORY_BACKPRESSURE] =   "DMA_S2MM_1_MEMORY_BACKPRESSURE_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_0_MEMORY_STARVATION]   =   "DMA_MM2S_0_MEMORY_STARVATION_MEM",
		[XAIEML_EVENTS_MEM_DMA_MM2S_1_MEMORY_STARVATION]   =   "DMA_MM2S_1_MEMORY_STARVATION_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL0_ACQ_EQ]               =   "LOCK_SEL0_ACQ_EQ_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL0_ACQ_GE]               =   "LOCK_SEL0_ACQ_GE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL0_EQUAL_TO_VALUE]       =   "LOCK_SEL0_EQUAL_TO_VALUE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL1_ACQ_EQ]               =   "LOCK_SEL1_ACQ_EQ_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL1_ACQ_GE]               =   "LOCK_SEL1_ACQ_GE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL1_EQUAL_TO_VALUE]       =   "LOCK_SEL1_EQUAL_TO_VALUE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL2_ACQ_EQ]               =   "LOCK_SEL2_ACQ_EQ_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL2_ACQ_GE]               =   "LOCK_SEL2_ACQ_GE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL2_EQUAL_TO_VALUE]       =   "LOCK_SEL2_EQUAL_TO_VALUE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL3_ACQ_EQ]               =   "LOCK_SEL3_ACQ_EQ_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL3_ACQ_GE]               =   "LOCK_SEL3_ACQ_GE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL3_EQUAL_TO_VALUE]       =   "LOCK_SEL3_EQUAL_TO_VALUE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL4_ACQ_EQ]               =   "LOCK_SEL4_ACQ_EQ_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL4_ACQ_GE]               =   "LOCK_SEL4_ACQ_GE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL4_EQUAL_TO_VALUE]       =   "LOCK_SEL4_EQUAL_TO_VALUE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL5_ACQ_EQ]               =   "LOCK_SEL5_ACQ_EQ_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL5_ACQ_GE]               =   "LOCK_SEL5_ACQ_GE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL5_EQUAL_TO_VALUE]       =   "LOCK_SEL5_EQUAL_TO_VALUE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL6_ACQ_EQ]               =   "LOCK_SEL6_ACQ_EQ_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL6_ACQ_GE]               =   "LOCK_SEL6_ACQ_GE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL6_EQUAL_TO_VALUE]       =   "LOCK_SEL6_EQUAL_TO_VALUE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL7_ACQ_EQ]               =   "LOCK_SEL7_ACQ_EQ_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL7_ACQ_GE]               =   "LOCK_SEL7_ACQ_GE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_SEL7_EQUAL_TO_VALUE]       =   "LOCK_SEL7_EQUAL_TO_VALUE_MEM",
		[XAIEML_EVENTS_MEM_LOCK_ERROR]                     =   "LOCK_ERROR_MEM",
		[XAIEML_EVENTS_MEM_DMA_TASK_TOKEN_STALL]           =   "DMA_TASK_TOKEN_STALL_MEM",
	},

	{

		[XAIEML_EVENTS_CORE_NONE]                            =     "NONE_CORE",
		[XAIEML_EVENTS_CORE_TRUE]                            =     "TRUE_CORE",
		[XAIEML_EVENTS_CORE_GROUP_0]                         =     "GROUP_0_CORE",
		[XAIEML_EVENTS_CORE_TIMER_SYNC]                      =     "TIMER_SYNC_CORE",
		[XAIEML_EVENTS_CORE_TIMER_VALUE_REACHED]             =     "TIMER_VALUE_REACHED_CORE",
		[XAIEML_EVENTS_CORE_PERF_CNT_0]                      =     "PERF_CNT_0_CORE",
		[XAIEML_EVENTS_CORE_PERF_CNT_1]                      =     "PERF_CNT_1_CORE",
		[XAIEML_EVENTS_CORE_PERF_CNT_2]                      =     "PERF_CNT_2_CORE",
		[XAIEML_EVENTS_CORE_PERF_CNT_3]                      =     "PERF_CNT_3_CORE",
		[XAIEML_EVENTS_CORE_COMBO_EVENT_0]                   =     "COMBO_EVENT_0_CORE",
		[XAIEML_EVENTS_CORE_COMBO_EVENT_1]                   =     "COMBO_EVENT_1_CORE",
		[XAIEML_EVENTS_CORE_COMBO_EVENT_2]                   =     "COMBO_EVENT_2_CORE",
		[XAIEML_EVENTS_CORE_COMBO_EVENT_3]                   =     "COMBO_EVENT_3_CORE",
		[XAIEML_EVENTS_CORE_GROUP_PC_EVENT]                  =     "GROUP_PC_EVENT_CORE",
		[XAIEML_EVENTS_CORE_PC_0]                            =     "PC_0_CORE",
		[XAIEML_EVENTS_CORE_PC_1]                            =     "PC_1_CORE",
		[XAIEML_EVENTS_CORE_PC_2]                            =     "PC_2_CORE",
		[XAIEML_EVENTS_CORE_PC_3]                            =     "PC_3_CORE",
		[XAIEML_EVENTS_CORE_PC_RANGE_0_1]                    =     "PC_RANGE_0_1_CORE",
		[XAIEML_EVENTS_CORE_PC_RANGE_2_3]                    =     "PC_RANGE_2_3_CORE",
		[XAIEML_EVENTS_CORE_GROUP_STALL]                     =     "GROUP_CORE_STALL_CORE",
		[XAIEML_EVENTS_CORE_MEMORY_STALL]                    =     "MEMORY_STALL_CORE",
		[XAIEML_EVENTS_CORE_STREAM_STALL]                    =     "STREAM_STALL_CORE",
		[XAIEML_EVENTS_CORE_CASCADE_STALL]                   =     "CASCADE_STALL_CORE",
		[XAIEML_EVENTS_CORE_LOCK_STALL]                      =     "LOCK_STALL_CORE",
		[XAIEML_EVENTS_CORE_DEBUG_HALTED]                    =     "DEBUG_HALTED_CORE",
		[XAIEML_EVENTS_CORE_ACTIVE]                          =     "ACTIVE_CORE",
		[XAIEML_EVENTS_CORE_DISABLED]                        =     "DISABLED_CORE",
		[XAIEML_EVENTS_CORE_ECC_ERROR_STALL]                 =     "ECC_ERROR_STALL_CORE",
		[XAIEML_EVENTS_CORE_ECC_SCRUBBING_STALL]             =     "ECC_SCRUBBING_STALL_CORE",
		[XAIEML_EVENTS_CORE_GROUP_PROGRAM_FLOW]              =     "GROUP_CORE_PROGRAM_FLOW_CORE",
		[XAIEML_EVENTS_CORE_INSTR_EVENT_0]                   =     "INSTR_EVENT_0_CORE",
		[XAIEML_EVENTS_CORE_INSTR_EVENT_1]                   =     "INSTR_EVENT_1_CORE",
		[XAIEML_EVENTS_CORE_INSTR_CALL]                      =     "INSTR_CALL_CORE",
		[XAIEML_EVENTS_CORE_INSTR_RETURN]                    =     "INSTR_RETURN_CORE",
		[XAIEML_EVENTS_CORE_INSTR_VECTOR]                    =     "INSTR_VECTOR_CORE",
		[XAIEML_EVENTS_CORE_INSTR_LOAD]                      =     "INSTR_LOAD_CORE",
		[XAIEML_EVENTS_CORE_INSTR_STORE]                     =     "INSTR_STORE_CORE",
		[XAIEML_EVENTS_CORE_INSTR_STREAM_GET]                =     "INSTR_STREAM_GET_CORE",
		[XAIEML_EVENTS_CORE_INSTR_STREAM_PUT]                =     "INSTR_STREAM_PUT_CORE",
		[XAIEML_EVENTS_CORE_INSTR_CASCADE_GET]               =     "INSTR_CASCADE_GET_CORE",
		[XAIEML_EVENTS_CORE_INSTR_CASCADE_PUT]               =     "INSTR_CASCADE_PUT_CORE",
		[XAIEML_EVENTS_CORE_INSTR_LOCK_ACQUIRE_REQ]          =     "INSTR_LOCK_ACQUIRE_REQ_CORE",
		[XAIEML_EVENTS_CORE_INSTR_LOCK_RELEASE_REQ]          =     "INSTR_LOCK_RELEASE_REQ_CORE",
		[XAIEML_EVENTS_CORE_GROUP_ERRORS_0]                  =     "GROUP_ERRORS_0_CORE",
		[XAIEML_EVENTS_CORE_GROUP_ERRORS_1]                  =     "GROUP_ERRORS_1_CORE",
		[XAIEML_EVENTS_CORE_SRS_OVERFLOW]                    =     "SRS_SATURATE_CORE",
		[XAIEML_EVENTS_CORE_UPS_OVERFLOW]                    =     "UPS_SATURATE_CORE",
		[XAIEML_EVENTS_CORE_FP_INVALID]                      =     "FP_INVALID_CORE",
		[XAIEML_EVENTS_CORE_PM_REG_ACCESS_FAILURE]           =     "PM_REG_ACCESS_FAILURE_CORE",
		[XAIEML_EVENTS_CORE_STREAM_PKT_PARITY_ERROR]         =     "STREAM_PKT_PARITY_ERROR_CORE",
		[XAIEML_EVENTS_CORE_CONTROL_PKT_ERROR]               =     "CONTROL_PKT_ERROR_CORE",
		[XAIEML_EVENTS_CORE_AXI_MM_SLAVE_ERROR]              =     "AXI_MM_SLAVE_ERROR_CORE",
		[XAIEML_EVENTS_CORE_INSTR_DECOMPRSN_ERROR]           =     "INSTR_DECOMPRSN_ERROR_CORE",
		[XAIEML_EVENTS_CORE_DM_ADDRESS_OUT_OF_RANGE]         =     "DM_ADDRESS_OUT_OF_RANGE_CORE",
		[XAIEML_EVENTS_CORE_PM_ECC_ERROR_SCRUB_CORRECTED]    =     "PM_ECC_ERROR_SCRUB_CORRECTED_CORE",
		[XAIEML_EVENTS_CORE_PM_ECC_ERROR_SCRUB_2BIT]         =     "PM_ECC_ERROR_SCRUB_2BIT_CORE",
		[XAIEML_EVENTS_CORE_PM_ECC_ERROR_1BIT]               =     "PM_ECC_ERROR_1BIT_CORE",
		[XAIEML_EVENTS_CORE_PM_ECC_ERROR_2BIT]               =     "PM_ECC_ERROR_2BIT_CORE",
		[XAIEML_EVENTS_CORE_PM_ADDRESS_OUT_OF_RANGE]         =     "PM_ADDRESS_OUT_OF_RANGE_CORE",
		[XAIEML_EVENTS_CORE_DM_ACCESS_TO_UNAVAILABLE]        =     "DM_ACCESS_TO_UNAVAILABLE_CORE",
		[XAIEML_EVENTS_CORE_LOCK_ACCESS_TO_UNAVAILABLE]      =     "LOCK_ACCESS_TO_UNAVAILABLE_CORE",
		[XAIEML_EVENTS_CORE_GROUP_STREAM_SWITCH]             =     "GROUP_STREAM_SWITCH_CORE",
		[XAIEML_EVENTS_CORE_PORT_IDLE_0]                     =     "PORT_IDLE_0_CORE",
		[XAIEML_EVENTS_CORE_PORT_RUNNING_0]                  =     "PORT_RUNNING_0_CORE",
		[XAIEML_EVENTS_CORE_PORT_STALLED_0]                  =     "PORT_STALLED_0_CORE",
		[XAIEML_EVENTS_CORE_PORT_TLAST_0]                    =     "PORT_TLAST_0_CORE",
		[XAIEML_EVENTS_CORE_PORT_IDLE_1]                     =     "PORT_IDLE_1_CORE",
		[XAIEML_EVENTS_CORE_PORT_RUNNING_1]                  =     "PORT_RUNNING_1_CORE",
		[XAIEML_EVENTS_CORE_PORT_STALLED_1]                  =     "PORT_STALLED_1_CORE",
		[XAIEML_EVENTS_CORE_PORT_TLAST_1]                    =     "PORT_TLAST_1_CORE",
		[XAIEML_EVENTS_CORE_PORT_IDLE_2]                     =     "PORT_IDLE_2_CORE",
		[XAIEML_EVENTS_CORE_PORT_RUNNING_2]                  =     "PORT_RUNNING_2_CORE",
		[XAIEML_EVENTS_CORE_PORT_STALLED_2]                  =     "PORT_STALLED_2_CORE",
		[XAIEML_EVENTS_CORE_PORT_TLAST_2]                    =     "PORT_TLAST_2_CORE",
		[XAIEML_EVENTS_CORE_PORT_IDLE_3]                     =     "PORT_IDLE_3_CORE",
		[XAIEML_EVENTS_CORE_PORT_RUNNING_3]                  =     "PORT_RUNNING_3_CORE",
		[XAIEML_EVENTS_CORE_PORT_STALLED_3]                  =     "PORT_STALLED_3_CORE",
		[XAIEML_EVENTS_CORE_PORT_TLAST_3]                    =     "PORT_TLAST_3_CORE",
		[XAIEML_EVENTS_CORE_PORT_IDLE_4]                     =     "PORT_IDLE_4_CORE",
		[XAIEML_EVENTS_CORE_PORT_RUNNING_4]                  =     "PORT_RUNNING_4_CORE",
		[XAIEML_EVENTS_CORE_PORT_STALLED_4]                  =     "PORT_STALLED_4_CORE",
		[XAIEML_EVENTS_CORE_PORT_TLAST_4]                    =     "PORT_TLAST_4_CORE",
		[XAIEML_EVENTS_CORE_PORT_IDLE_5]                     =     "PORT_IDLE_5_CORE",
		[XAIEML_EVENTS_CORE_PORT_RUNNING_5]                  =     "PORT_RUNNING_5_CORE",
		[XAIEML_EVENTS_CORE_PORT_STALLED_5]                  =     "PORT_STALLED_5_CORE",
		[XAIEML_EVENTS_CORE_PORT_TLAST_5]                    =     "PORT_TLAST_5_CORE",
		[XAIEML_EVENTS_CORE_PORT_IDLE_6]                     =     "PORT_IDLE_6_CORE",
		[XAIEML_EVENTS_CORE_PORT_RUNNING_6]                  =     "PORT_RUNNING_6_CORE",
		[XAIEML_EVENTS_CORE_PORT_STALLED_6]                  =     "PORT_STALLED_6_CORE",
		[XAIEML_EVENTS_CORE_PORT_TLAST_6]                    =     "PORT_TLAST_6_CORE",
		[XAIEML_EVENTS_CORE_PORT_IDLE_7]                     =     "PORT_IDLE_7_CORE",
		[XAIEML_EVENTS_CORE_PORT_RUNNING_7]                  =     "PORT_RUNNING_7_CORE",
		[XAIEML_EVENTS_CORE_PORT_STALLED_7]                  =     "PORT_STALLED_7_CORE",
		[XAIEML_EVENTS_CORE_PORT_TLAST_7]                    =     "PORT_TLAST_7_CORE",
		[XAIEML_EVENTS_CORE_GROUP_BROADCAST]                 =     "GROUP_BROADCAST_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_0]                     =     "BROADCAST_0_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_1]                     =     "BROADCAST_1_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_2]                     =     "BROADCAST_2_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_3]                     =     "BROADCAST_3_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_4]                     =     "BROADCAST_4_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_5]                     =     "BROADCAST_5_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_6]                     =     "BROADCAST_6_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_7]                     =     "BROADCAST_7_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_8]                     =     "BROADCAST_8_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_9]                     =     "BROADCAST_9_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_10]                    =     "BROADCAST_10_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_11]                    =     "BROADCAST_11_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_12]                    =     "BROADCAST_12_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_13]                    =     "BROADCAST_13_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_14]                    =     "BROADCAST_14_CORE",
		[XAIEML_EVENTS_CORE_BROADCAST_15]                    =     "BROADCAST_15_CORE",
		[XAIEML_EVENTS_CORE_GROUP_USER_EVENT]                =     "GROUP_USER_EVENT_CORE",
		[XAIEML_EVENTS_CORE_USER_EVENT_0]                    =     "USER_EVENT_0_CORE",
		[XAIEML_EVENTS_CORE_USER_EVENT_1]                    =     "USER_EVENT_1_CORE",
		[XAIEML_EVENTS_CORE_USER_EVENT_2]                    =     "USER_EVENT_2_CORE",
		[XAIEML_EVENTS_CORE_USER_EVENT_3]                    =     "USER_EVENT_3_CORE",
		[XAIEML_EVENTS_CORE_EDGE_DETECTION_EVENT_0]          =     "EDGE_DETECTION_EVENT_0_CORE",
		[XAIEML_EVENTS_CORE_EDGE_DETECTION_EVENT_1]          =     "EDGE_DETECTION_EVENT_1_CORE",
		[XAIEML_EVENTS_CORE_FP_HUGE]                         =     "FP_HUGE_CORE",
		[XAIEML_EVENTS_CORE_INT_FP_0]                        =     "INT_FP_0_CORE",
		[XAIEML_EVENTS_CORE_FP_INF]                          =     "FP_INF_CORE",
		[XAIEML_EVENTS_CORE_INSTR_WARNING]                   =     "INSTR_WARNING_CORE",
		[XAIEML_EVENTS_CORE_INSTR_ERROR]                     =     "INSTR_ERROR_CORE",
		[XAIEML_EVENTS_CORE_DECOMPRESSION_UNDERFLOW]         =     "DECOMPRESSION_UNDERFLOW_CORE",
		[XAIEML_EVENTS_CORE_STREAM_SWITCH_PORT_PARITY_ERROR] =    "STREAM_SWITCH_PORT_PARITY_ERROR_CORE",
		[XAIEML_EVENTS_CORE_PROCESSOR_BUS_ERROR]             =    "PROCESSOR_BUS_ERROR_CORE",
	}
};

static const char* XAie_EventNoCStrings[] = {
	[XAIEML_EVENTS_PL_NONE]                                    =    "NONE_PL",
	[XAIEML_EVENTS_PL_TRUE]                                    =    "TRUE_PL",
	[XAIEML_EVENTS_PL_GROUP_0]                                 =    "GROUP_0_PL",
	[XAIEML_EVENTS_PL_TIMER_SYNC]                              =    "TIMER_SYNC_PL",
	[XAIEML_EVENTS_PL_TIMER_VALUE_REACHED]                     =    "TIMER_VALUE_REACHED_PL",
	[XAIEML_EVENTS_PL_PERF_CNT_0]                              =    "PERF_CNT_0_PL",
	[XAIEML_EVENTS_PL_PERF_CNT_1]                              =    "PERF_CNT_1_PL",
	[XAIEML_EVENTS_PL_COMBO_EVENT_0]                           =    "COMBO_EVENT_0_PL",
	[XAIEML_EVENTS_PL_COMBO_EVENT_1]                           =    "COMBO_EVENT_1_PL",
	[XAIEML_EVENTS_PL_COMBO_EVENT_2]                           =    "COMBO_EVENT_2_PL",
	[XAIEML_EVENTS_PL_COMBO_EVENT_3]                           =    "COMBO_EVENT_3_PL",
	[XAIEML_EVENTS_PL_GROUP_DMA_ACTIVITY]                      =    "GROUP_DMA_ACTIVITY_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_0_FINISHED_BD]                  =    "DMA_S2MM_0_FINISHED_BD_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_1_FINISHED_BD]                  =    "DMA_S2MM_1_FINISHED_BD_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_0_FINISHED_BD]                  =    "DMA_MM2S_0_FINISHED_BD_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_1_FINISHED_BD]                  =    "DMA_MM2S_1_FINISHED_BD_PL",
	[XAIEML_EVENTS_PL_GROUP_LOCK]                              =    "GROUP_LOCK_PL",
	[XAIEML_EVENTS_PL_LOCK_0_REL]                              =    "LOCK_0_RELEASED_PL",
	[XAIEML_EVENTS_PL_LOCK_1_REL]                              =    "LOCK_1_RELEASED_PL",
	[XAIEML_EVENTS_PL_LOCK_2_REL]                              =    "LOCK_2_RELEASED_PL",
	[XAIEML_EVENTS_PL_LOCK_3_REL]                              =    "LOCK_3_RELEASED_PL",
	[XAIEML_EVENTS_PL_LOCK_4_REL]                              =    "LOCK_4_RELEASED_PL",
	[XAIEML_EVENTS_PL_LOCK_5_REL]                              =    "LOCK_5_RELEASED_PL",
	[XAIEML_EVENTS_PL_GROUP_ERRORS]                            =    "GROUP_ERRORS_PL",
	[XAIEML_EVENTS_PL_AXI_MM_SLAVE_ERROR]                      =    "AXI_MM_SLAVE_TILE_ERROR_PL",
	[XAIEML_EVENTS_PL_CONTROL_PKT_ERROR]                       =    "CONTROL_PKT_ERROR_PL",
	[XAIEML_EVENTS_PL_AXI_MM_DECODE_NSU_ERROR]                 =    "AXI_MM_DECODE_NSU_ERROR_PL",
	[XAIEML_EVENTS_PL_AXI_MM_SLAVE_NSU_ERROR]                  =    "AXI_MM_SLAVE_NSU_ERROR_PL",
	[XAIEML_EVENTS_PL_AXI_MM_UNSUPPORTED_TRAFFIC]              =    "AXI_MM_UNSUPPORTED_TRAFFIC_PL",
	[XAIEML_EVENTS_PL_AXI_MM_UNSECURE_ACCESS_IN_SECURE_MODE]   =    "AXI_MM_UNSECURE_ACCESS_IN_SECURE_MODE_PL",
	[XAIEML_EVENTS_PL_AXI_MM_BYTE_STROBE_ERROR]                =    "AXI_MM_BYTE_STROBE_ERROR_PL",
	[XAIEML_EVENTS_PL_GROUP_STREAM_SWITCH]                     =    "GROUP_STREAM_SWITCH_PL",
	[XAIEML_EVENTS_PL_PORT_IDLE_0]                             =    "PORT_IDLE_0_PL",
	[XAIEML_EVENTS_PL_PORT_RUNNING_0]                          =    "PORT_RUNNING_0_PL",
	[XAIEML_EVENTS_PL_PORT_STALLED_0]                          =    "PORT_STALLED_0_PL",
	[XAIEML_EVENTS_PL_PORT_TLAST_0]                            =    "PORT_TLAST_0_PL",
	[XAIEML_EVENTS_PL_PORT_IDLE_1]                             =    "PORT_IDLE_1_PL",
	[XAIEML_EVENTS_PL_PORT_RUNNING_1]                          =    "PORT_RUNNING_1_PL",
	[XAIEML_EVENTS_PL_PORT_STALLED_1]                          =    "PORT_STALLED_1_PL",
	[XAIEML_EVENTS_PL_PORT_TLAST_1]                            =    "PORT_TLAST_1_PL",
	[XAIEML_EVENTS_PL_PORT_IDLE_2]                             =    "PORT_IDLE_2_PL",
	[XAIEML_EVENTS_PL_PORT_RUNNING_2]                          =    "PORT_RUNNING_2_PL",
	[XAIEML_EVENTS_PL_PORT_STALLED_2]                          =    "PORT_STALLED_2_PL",
	[XAIEML_EVENTS_PL_PORT_TLAST_2]                            =    "PORT_TLAST_2_PL",
	[XAIEML_EVENTS_PL_PORT_IDLE_3]                             =    "PORT_IDLE_3_PL",
	[XAIEML_EVENTS_PL_PORT_RUNNING_3]                          =    "PORT_RUNNING_3_PL",
	[XAIEML_EVENTS_PL_PORT_STALLED_3]                          =    "PORT_STALLED_3_PL",
	[XAIEML_EVENTS_PL_PORT_TLAST_3]                            =    "PORT_TLAST_3_PL",
	[XAIEML_EVENTS_PL_PORT_IDLE_4]                             =    "PORT_IDLE_4_PL",
	[XAIEML_EVENTS_PL_PORT_RUNNING_4]                          =    "PORT_RUNNING_4_PL",
	[XAIEML_EVENTS_PL_PORT_STALLED_4]                          =    "PORT_STALLED_4_PL",
	[XAIEML_EVENTS_PL_PORT_TLAST_4]                            =    "PORT_TLAST_4_PL",
	[XAIEML_EVENTS_PL_PORT_IDLE_5]                             =    "PORT_IDLE_5_PL",
	[XAIEML_EVENTS_PL_PORT_RUNNING_5]                          =    "PORT_RUNNING_5_PL",
	[XAIEML_EVENTS_PL_PORT_STALLED_5]                          =    "PORT_STALLED_5_PL",
	[XAIEML_EVENTS_PL_PORT_TLAST_5]                            =    "PORT_TLAST_5_PL",
	[XAIEML_EVENTS_PL_PORT_IDLE_6]                             =    "PORT_IDLE_6_PL",
	[XAIEML_EVENTS_PL_PORT_RUNNING_6]                          =    "PORT_RUNNING_6_PL",
	[XAIEML_EVENTS_PL_PORT_STALLED_6]                          =    "PORT_STALLED_6_PL",
	[XAIEML_EVENTS_PL_PORT_TLAST_6]                            =    "PORT_TLAST_6_PL",
	[XAIEML_EVENTS_PL_PORT_IDLE_7]                             =    "PORT_IDLE_7_PL",
	[XAIEML_EVENTS_PL_PORT_RUNNING_7]                          =    "PORT_RUNNING_7_PL",
	[XAIEML_EVENTS_PL_PORT_STALLED_7]                          =    "PORT_STALLED_7_PL",
	[XAIEML_EVENTS_PL_PORT_TLAST_7]                            =    "PORT_TLAST_7_PL",
	[XAIEML_EVENTS_PL_GROUP_BROADCAST_A]                       =    "GROUP_BROADCAST_A_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_0]                           =    "BROADCAST_A_0_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_1]                           =    "BROADCAST_A_1_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_2]                           =    "BROADCAST_A_2_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_3]                           =    "BROADCAST_A_3_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_4]                           =    "BROADCAST_A_4_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_5]                           =    "BROADCAST_A_5_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_6]                           =    "BROADCAST_A_6_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_7]                           =    "BROADCAST_A_7_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_8]                           =    "BROADCAST_A_8_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_9]                           =    "BROADCAST_A_9_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_10]                          =    "BROADCAST_A_10_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_11]                          =    "BROADCAST_A_11_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_12]                          =    "BROADCAST_A_12_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_13]                          =    "BROADCAST_A_13_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_14]                          =    "BROADCAST_A_14_PL",
	[XAIEML_EVENTS_PL_BROADCAST_A_15]                          =    "BROADCAST_A_15_PL",
	[XAIEML_EVENTS_PL_USER_EVENT_0]                            =    "USER_EVENT_0_PL",
	[XAIEML_EVENTS_PL_USER_EVENT_1]                            =    "USER_EVENT_1_PL",
	[XAIEML_EVENTS_PL_EDGE_DETECTION_EVENT_0]                  =    "EDGE_DETECTION_EVENT_0_PL",
	[XAIEML_EVENTS_PL_EDGE_DETECTION_EVENT_1]                  =    "EDGE_DETECTION_EVENT_1_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_0_START_TASK]                   =    "DMA_S2MM_0_START_TASK_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_1_START_TASK]                   =    "DMA_S2MM_1_START_TASK_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_0_START_TASK]                   =    "DMA_MM2S_0_START_TASK_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_1_START_TASK]                   =    "DMA_MM2S_1_START_TASK_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_0_FINISHED_TASK]                =    "DMA_S2MM_0_FINISHED_TASK_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_1_FINISHED_TASK]                =    "DMA_S2MM_1_FINISHED_TASK_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_0_FINISHED_TASK]                =    "DMA_MM2S_0_FINISHED_TASK_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_1_FINISHED_TASK]                =    "DMA_MM2S_1_FINISHED_TASK_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_0_STALLED_LOCK]                 =    "DMA_S2MM_0_STALLED_LOCK_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_1_STALLED_LOCK]                 =    "DMA_S2MM_1_STALLED_LOCK_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_0_STALLED_LOCK]                 =    "DMA_MM2S_0_STALLED_LOCK_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_1_STALLED_LOCK]                 =    "DMA_MM2S_1_STALLED_LOCK_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_0_STREAM_STARVATION]            =    "DMA_S2MM_0_STREAM_STARVATION_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_1_STREAM_STARVATION]            =    "DMA_S2MM_1_STREAM_STARVATION_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_0_STREAM_BACKPRESSURE]          =    "DMA_MM2S_0_STREAM_BACKPRESSURE_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_1_STREAM_BACKPRESSURE]          =    "DMA_MM2S_1_STREAM_BACKPRESSURE_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_0_MEMORY_BACKPRESSURE]          =    "DMA_S2MM_0_MEMORY_BACKPRESSURE_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_1_MEMORY_BACKPRESSURE]          =    "DMA_S2MM_1_MEMORY_BACKPRESSURE_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_0_MEMORY_STARVATION]            =    "DMA_MM2S_0_MEMORY_STARVATION_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_1_MEMORY_STARVATION]            =    "DMA_MM2S_1_MEMORY_STARVATION_PL",
	[XAIEML_EVENTS_PL_LOCK_0_ACQ_EQ]                           =    "LOCK_0_ACQ_EQ_PL",
	[XAIEML_EVENTS_PL_LOCK_0_ACQ_GE]                           =    "LOCK_0_ACQ_GE_PL",
	[XAIEML_EVENTS_PL_LOCK_0_EQUAL_TO_VALUE]                   =    "LOCK_0_EQUAL_TO_VALUE_PL",
	[XAIEML_EVENTS_PL_LOCK_1_ACQ_EQ]                           =    "LOCK_1_ACQ_EQ_PL",
	[XAIEML_EVENTS_PL_LOCK_1_ACQ_GE]                           =    "LOCK_1_ACQ_GE_PL",
	[XAIEML_EVENTS_PL_LOCK_1_EQUAL_TO_VALUE]                   =    "LOCK_1_EQUAL_TO_VALUE_PL",
	[XAIEML_EVENTS_PL_LOCK_2_ACQ_EQ]                           =    "LOCK_2_ACQ_EQ_PL",
	[XAIEML_EVENTS_PL_LOCK_2_ACQ_GE]                           =    "LOCK_2_ACQ_GE_PL",
	[XAIEML_EVENTS_PL_LOCK_2_EQUAL_TO_VALUE]                   =    "LOCK_2_EQUAL_TO_VALUE_PL",
	[XAIEML_EVENTS_PL_LOCK_3_ACQ_EQ]                           =    "LOCK_3_ACQ_EQ_PL",
	[XAIEML_EVENTS_PL_LOCK_3_ACQ_GE]                           =    "LOCK_3_ACQ_GE_PL",
	[XAIEML_EVENTS_PL_LOCK_3_EQUAL_TO_VALUE]                   =    "LOCK_3_EQUAL_TO_VALUE_PL",
	[XAIEML_EVENTS_PL_LOCK_4_ACQ_EQ]                           =    "LOCK_4_ACQ_EQ_PL",
	[XAIEML_EVENTS_PL_LOCK_4_ACQ_GE]                           =    "LOCK_4_ACQ_GE_PL",
	[XAIEML_EVENTS_PL_LOCK_4_EQUAL_TO_VALUE]                   =    "LOCK_4_EQUAL_TO_VALUE_PL",
	[XAIEML_EVENTS_PL_LOCK_5_ACQ_EQ]                           =    "LOCK_5_ACQ_EQ_PL",
	[XAIEML_EVENTS_PL_LOCK_5_ACQ_GE]                           =    "LOCK_5_ACQ_GE_PL",
	[XAIEML_EVENTS_PL_LOCK_5_EQUAL_TO_VALUE]                   =    "LOCK_5_EQUAL_TO_VALUE_PL",
	[XAIEML_EVENTS_PL_STREAM_SWITCH_PARITY_ERROR]              =    "STREAM_SWITCH_PARITY_ERROR_PL",
	[XAIEML_EVENTS_PL_DMA_S2MM_ERROR]                          =    "DMA_S2MM_ERROR_PL",
	[XAIEML_EVENTS_PL_DMA_MM2S_ERROR]                          =    "DMA_MM2S_ERROR_PL",
	[XAIEML_EVENTS_PL_LOCK_ERROR]                              =    "LOCK_ERROR_PL",
	[XAIEML_EVENTS_PL_DMA_TASK_TOKEN_STALL]                    =    "DMA_TASK_TOKEN_STALL_PL",
};

static const char* XAie_EventMemTileStrings[] = {
	[XAIEML_EVENTS_MEM_TILE_NONE]                               =   "NONE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_TRUE]                               =   "TRUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_0]                            =   "GROUP_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_TIMER_SYNC]                         =   "TIMER_SYNC_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_TIMER_VALUE_REACHED]                =   "TIMER_VALUE_REACHED_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PERF_CNT0_EVENT]                    =   "PERF_CNT0_EVENT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PERF_CNT1_EVENT]                    =   "PERF_CNT1_EVENT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PERF_CNT2_EVENT]                    =   "PERF_CNT2_EVENT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PERF_CNT3_EVENT]                    =   "PERF_CNT3_EVENT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_COMBO_EVENT_0]                      =   "COMBO_EVENT_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_COMBO_EVENT_1]                      =   "COMBO_EVENT_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_COMBO_EVENT_2]                      =   "COMBO_EVENT_2_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_COMBO_EVENT_3]                      =   "COMBO_EVENT_3_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_EDGE_DETECTION_EVENT_0]             =   "EDGE_DETECTION_EVENT_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_EDGE_DETECTION_EVENT_1]             =   "EDGE_DETECTION_EVENT_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_WATCHPOINT]                   =   "GROUP_WATCHPOINT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_WATCHPOINT_0]                       =   "WATCHPOINT_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_WATCHPOINT_1]                       =   "WATCHPOINT_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_WATCHPOINT_2]                       =   "WATCHPOINT_2_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_WATCHPOINT_3]                       =   "WATCHPOINT_3_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_DMA_ACTIVITY]                 =   "GROUP_DMA_ACTIVITY_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL0_START_TASK]           =   "DMA_S2MM_SEL0_START_TASK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL1_START_TASK]           =   "DMA_S2MM_SEL1_START_TASK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL0_START_TASK]           =   "DMA_MM2S_SEL0_START_TASK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL1_START_TASK]           =   "DMA_MM2S_SEL1_START_TASK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL0_FINISHED_BD]          =   "DMA_S2MM_SEL0_FINISHED_BD_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL1_FINISHED_BD]          =   "DMA_S2MM_SEL1_FINISHED_BD_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL0_FINISHED_BD]          =   "DMA_MM2S_SEL0_FINISHED_BD_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL1_FINISHED_BD]          =   "DMA_MM2S_SEL1_FINISHED_BD_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL0_FINISHED_TASK]        =   "DMA_S2MM_SEL0_FINISHED_TASK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL1_FINISHED_TASK]        =   "DMA_S2MM_SEL1_FINISHED_TASK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL0_FINISHED_TASK]        =   "DMA_MM2S_SEL0_FINISHED_TASK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL1_FINISHED_TASK]        =   "DMA_MM2S_SEL1_FINISHED_TASK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL0_STALLED_LOCK]         =   "DMA_S2MM_SEL0_STALLED_LOCK_ACQUIRE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL1_STALLED_LOCK]         =   "DMA_S2MM_SEL1_STALLED_LOCK_ACQUIRE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL0_STALLED_LOCK]         =   "DMA_MM2S_SEL0_STALLED_LOCK_ACQUIRE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL1_STALLED_LOCK]         =   "DMA_MM2S_SEL1_STALLED_LOCK_ACQUIRE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL0_STREAM_STARVATION]    =   "DMA_S2MM_SEL0_STREAM_STARVATION_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL1_STREAM_STARVATION]    =   "DMA_S2MM_SEL1_STREAM_STARVATION_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL0_STREAM_BACKPRESSURE]  =   "DMA_MM2S_SEL0_STREAM_BACKPRESSURE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL1_STREAM_BACKPRESSURE]  =   "DMA_MM2S_SEL1_STREAM_BACKPRESSURE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL0_MEMORY_BACKPRESSURE]  =   "DMA_S2MM_SEL0_MEMORY_BACKPRESSURE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_SEL1_MEMORY_BACKPRESSURE]  =   "DMA_S2MM_SEL1_MEMORY_BACKPRESSURE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL0_MEMORY_STARVATION]    =   "DMA_MM2S_SEL0_MEMORY_STARVATION_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_SEL1_MEMORY_STARVATION]    =   "DMA_MM2S_SEL1_MEMORY_STARVATION_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_LOCK]                         =   "GROUP_LOCK_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL0_ACQ_EQ]                   =   "LOCK_SEL0_ACQ_EQ_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL0_ACQ_GE]                   =   "LOCK_SEL0_ACQ_GE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL0_REL]                      =   "LOCK_SEL0_REL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL0_EQUAL_TO_VALUE]           =   "LOCK_SEL0_EQUAL_TO_VALUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL1_ACQ_EQ]                   =   "LOCK_SEL1_ACQ_EQ_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL1_ACQ_GE]                   =   "LOCK_SEL1_ACQ_GE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL1_REL]                      =   "LOCK_SEL1_REL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL1_EQUAL_TO_VALUE]           =   "LOCK_SEL1_EQUAL_TO_VALUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL2_ACQ_EQ]                   =   "LOCK_SEL2_ACQ_EQ_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL2_ACQ_GE]                   =   "LOCK_SEL2_ACQ_GE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL2_REL]                      =   "LOCK_SEL2_REL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL2_EQUAL_TO_VALUE]           =   "LOCK_SEL2_EQUAL_TO_VALUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL3_ACQ_EQ]                   =   "LOCK_SEL3_ACQ_EQ_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL3_ACQ_GE]                   =   "LOCK_SEL3_ACQ_GE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL3_REL]                      =   "LOCK_SEL3_REL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL3_EQUAL_TO_VALUE]           =   "LOCK_SEL3_EQUAL_TO_VALUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL4_ACQ_EQ]                   =   "LOCK_SEL4_ACQ_EQ_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL4_ACQ_GE]                   =   "LOCK_SEL4_ACQ_GE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL4_REL]                      =   "LOCK_SEL4_REL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL4_EQUAL_TO_VALUE]           =   "LOCK_SEL4_EQUAL_TO_VALUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL5_ACQ_EQ]                   =   "LOCK_SEL5_ACQ_EQ_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL5_ACQ_GE]                   =   "LOCK_SEL5_ACQ_GE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL5_REL]                      =   "LOCK_SEL5_REL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL5_EQUAL_TO_VALUE]           =   "LOCK_SEL5_EQUAL_TO_VALUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL6_ACQ_EQ]                   =   "LOCK_SEL6_ACQ_EQ_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL6_ACQ_GE]                   =   "LOCK_SEL6_ACQ_GE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL6_REL]                      =   "LOCK_SEL6_REL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL6_EQUAL_TO_VALUE]           =   "LOCK_SEL6_EQUAL_TO_VALUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL7_ACQ_EQ]                   =   "LOCK_SEL7_ACQ_EQ_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL7_ACQ_GE]                   =   "LOCK_SEL7_ACQ_GE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL7_REL]                      =   "LOCK_SEL7_REL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_SEL7_EQUAL_TO_VALUE]           =   "LOCK_SEL7_EQUAL_TO_VALUE_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_STREAM_SWITCH]                =   "GROUP_STREAM_SWITCH_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_IDLE_0]                        =   "PORT_IDLE_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_RUNNING_0]                     =   "PORT_RUNNING_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_STALLED_0]                     =   "PORT_STALLED_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_TLAST_0]                       =   "PORT_TLAST_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_IDLE_1]                        =   "PORT_IDLE_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_RUNNING_1]                     =   "PORT_RUNNING_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_STALLED_1]                     =   "PORT_STALLED_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_TLAST_1]                       =   "PORT_TLAST_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_IDLE_2]                        =   "PORT_IDLE_2_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_RUNNING_2]                     =   "PORT_RUNNING_2_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_STALLED_2]                     =   "PORT_STALLED_2_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_TLAST_2]                       =   "PORT_TLAST_2_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_IDLE_3]                        =   "PORT_IDLE_3_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_RUNNING_3]                     =   "PORT_RUNNING_3_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_STALLED_3]                     =   "PORT_STALLED_3_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_TLAST_3]                       =   "PORT_TLAST_3_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_IDLE_4]                        =   "PORT_IDLE_4_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_RUNNING_4]                     =   "PORT_RUNNING_4_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_STALLED_4]                     =   "PORT_STALLED_4_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_TLAST_4]                       =   "PORT_TLAST_4_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_IDLE_5]                        =   "PORT_IDLE_5_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_RUNNING_5]                     =   "PORT_RUNNING_5_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_STALLED_5]                     =   "PORT_STALLED_5_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_TLAST_5]                       =   "PORT_TLAST_5_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_IDLE_6]                        =   "PORT_IDLE_6_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_RUNNING_6]                     =   "PORT_RUNNING_6_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_STALLED_6]                     =   "PORT_STALLED_6_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_TLAST_6]                       =   "PORT_TLAST_6_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_IDLE_7]                        =   "PORT_IDLE_7_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_RUNNING_7]                     =   "PORT_RUNNING_7_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_STALLED_7]                     =   "PORT_STALLED_7_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_PORT_TLAST_7]                       =   "PORT_TLAST_7_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_MEMORY_CONFLICT]              =   "GROUP_MEMORY_CONFLICT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_0]                 =   "CONFLICT_DM_BANK_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_1]                 =   "CONFLICT_DM_BANK_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_2]                 =   "CONFLICT_DM_BANK_2_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_3]                 =   "CONFLICT_DM_BANK_3_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_4]                 =   "CONFLICT_DM_BANK_4_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_5]                 =   "CONFLICT_DM_BANK_5_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_6]                 =   "CONFLICT_DM_BANK_6_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_7]                 =   "CONFLICT_DM_BANK_7_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_8]                 =   "CONFLICT_DM_BANK_8_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_9]                 =   "CONFLICT_DM_BANK_9_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_10]                =   "CONFLICT_DM_BANK_10_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_11]                =   "CONFLICT_DM_BANK_11_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_12]                =   "CONFLICT_DM_BANK_12_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_13]                =   "CONFLICT_DM_BANK_13_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_14]                =   "CONFLICT_DM_BANK_14_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONFLICT_DM_BANK_15]                =   "CONFLICT_DM_BANK_15_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_ERRORS]                       =   "GROUP_ERRORS_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DM_ECC_ERROR_SCRUB_CORRECTED]       =   "DM_ECC_ERROR_SCRUB_CORRECTED_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DM_ECC_ERROR_SCRUB_2BIT]            =   "DM_ECC_ERROR_SCRUB_2BIT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DM_ECC_ERROR_1BIT]                  =   "DM_ECC_ERROR_1BIT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DM_ECC_ERROR_2BIT]                  =   "DM_ECC_ERROR_2BIT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_S2MM_ERROR]                     =   "DMA_S2MM_ERROR_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_MM2S_ERROR]                     =   "DMA_MM2S_ERROR_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_STREAM_SWITCH_PARITY_ERROR]         =   "STREAM_SWITCH_PARITY_ERROR_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_STREAM_PKT_ERROR]                   =   "STREAM_PKT_ERROR_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_CONTROL_PKT_ERROR]                  =   "CONTROL_PKT_ERROR_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_AXI_MM_SLAVE_ERROR]                 =   "AXI_MM_SLAVE_ERROR_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_LOCK_ERROR]                         =   "LOCK_ERROR_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_DMA_TASK_TOKEN_STALL]               =   "DMA_TASK_TOKEN_STALL_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_BROADCAST]                    =   "GROUP_BROADCAST_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_0]                        =   "BROADCAST_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_1]                        =   "BROADCAST_1_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_2]                        =   "BROADCAST_2_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_3]                        =   "BROADCAST_3_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_4]                        =   "BROADCAST_4_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_5]                        =   "BROADCAST_5_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_6]                        =   "BROADCAST_6_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_7]                        =   "BROADCAST_7_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_8]                        =   "BROADCAST_8_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_9]                        =   "BROADCAST_9_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_10]                       =   "BROADCAST_10_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_11]                       =   "BROADCAST_11_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_12]                       =   "BROADCAST_12_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_13]                       =   "BROADCAST_13_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_14]                       =   "BROADCAST_14_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_BROADCAST_15]                       =   "BROADCAST_15_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_GROUP_USER_EVENT]                   =   "GROUP_USER_EVENT_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_USER_EVENT_0]                       =   "USER_EVENT_0_MEM_TILE",
	[XAIEML_EVENTS_MEM_TILE_USER_EVENT_1]                       =   "USER_EVENT_1_MEM_TILE",

};

/**************************** Function Prototypes *******************************/
int XAie_EventStatus_CSV(XAie_DevInst* DevInst, u32 Reg, char *Buf, u32 BufSize,
		u8 TType, XAie_ModuleType Mod, u8 RegNum);

#endif  /* XAIE_FEATURE_UTIL_STATUS_ENABLE */

/** @} */
