#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.1
visibility:           public
id:                   arch-hs-0.12.0.1-Cuc0cxPgGr42VatxP4re4p
key:                  arch-hs-0.12.0.1-Cuc0cxPgGr42VatxP4re4p
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  f2021a8c2e4e695a3f1a24a5254b1707
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.1-Cuc0cxPgGr42VatxP4re4p
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.1/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-644Hl6gJ6c41D4iXUJ55VB
    aeson-2.1.2.1-Ex7WnNUT1auEGSF1Md5zyM
    algebraic-graphs-0.7-E0FcE6j6DzDIzVgzwTrBLi
    arch-web-0.3.1-7A48QWP6ozhHtrZwy4VVtB base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-IZ8OSXmnRyPK1N2pz1JDDM
    conduit-extra-1.3.6-FeP3PJUxzIFFgQ0giCiqnz containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-8NF32oJG9iuFNrf7QfLZxO
    http-client-0.7.17-7FoGmHilSaNBsOApDiQmhp
    http-client-tls-0.3.6.4-1V2YjihKQe57spPR9YDllk
    megaparsec-9.6.1-7Wx3qSFb3vpB15hbe2AAJD
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO
    neat-interpolation-0.5.1.4-8YhyHYNAtoc3nJ6x2IT1FE
    optparse-simple-0.1.1.4-GEEDCsVOK1W5zMp45NGNe
    polysemy-1.9.2.0-LWN8tC8GASO8QpeJslYjHj
    prettyprinter-1.7.1-5dDyiINWv3JvkTPn41dcY
    prettyprinter-ansi-terminal-1.1.3-CrDoL6rlO20GPbWZEwOwP7
    servant-client-0.20-K1zwTYxpNorLtztmx1Bock
    split-0.2.5-8MbgSD03gYABvLDzr4SwW7
    tar-conduit-0.4.1-K3RAaLoGdsBLZztuu2Nfnk template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

