#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.1
visibility:           public
id:                   dhall-1.42.1-GYPRq5sog4XHS9lOxTFhYI
key:                  dhall-1.42.1-GYPRq5sog4XHS9lOxTFhYI
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  08926b7396cf87e1abb9c2add9e461a3
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.1-GYPRq5sog4XHS9lOxTFhYI
depends:
    Diff-0.4.1-AZUE6X4VFrn1KwicRR603j
    aeson-2.1.2.1-KaceSWeAWkBK9urIr7RMHq
    aeson-pretty-0.8.10-IkhSIawo37D6gbGZctBJxQ
    ansi-terminal-1.0.2-EhzJoAzi53XHL1K3CBirLP
    atomic-write-0.2.1.1-H5KlqrljYwX8tE1N65GXNT base-4.17.2.1
    base16-bytestring-1.0.2.0-KtYitFsTneELM2hKpf73Fg
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-LMolnZwpRvW7BfRj8XMS7A
    cborg-0.2.9.0-E2a8XArxeDX4Jrsli47GqT
    cborg-json-0.2.5.0-J8NimIWKnQjJ3bRXLZKIUA containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-3vKTzB6TP3e4Y0ovdPWm89
    data-fix-0.3.3-Ae95BGkNJ6M2ZtAewHkPPT deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.2-6MEZCkUlk8B7hUt9LI9vXn exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-2RdCsGXaISy88aGVJxSJFf
    hashable-1.4.4.0-9MfualSpDNWnshBkTCGL2 haskeline-0.8.2
    http-client-0.7.17-Dq9DKpPNcLC4AQxJXgluzq
    http-client-tls-0.3.6.4-Ig2geyAlqG4AsOU96o5xjf
    http-types-0.12.4-57pHf4hFiOh2bb0nmyfV8P
    indexed-traversable-0.1.4-1gYNbSveFbG1F58HXav72S
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-LsGlFZLL4kx9NfYo2s5ICp
    mmorph-1.2.0-3nIz0RIlBAUER45blfkK28 mtl-2.2.2
    network-uri-2.6.4.2-2zvAvfFkls42ip9Twf1aZ
    optparse-applicative-0.17.1.0-1zwl3BwOIHmKNlRMhkhfu3
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-UfS94awdkY7ENYi5DmjkR
    pretty-simple-4.1.3.0-789lvsbfTYw8zvBRyJrY5H
    prettyprinter-1.7.1-6KCRwZiz9dxAfJnrHaz498
    prettyprinter-ansi-terminal-1.1.3-DsjS54B6SVRJcQWBCbeS0Q
    profunctors-5.6.2-LJDcUqkrAVyKPBPzv6byyz
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.7.0-9lDvYfmnlPP71p7oN4wX8g
    serialise-0.2.6.1-ETzYb05abQ73awhazkZaPS template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-D6sIVAuCuzT4Er3HBu2UCX
    text-short-0.1.6-KTOEO6mCUJO8IKWfVBmsiu
    th-lift-instances-0.1.20-B7uVUMsyq8p3a6tDnL2f7O time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.3-ILfkwL4pHaK6MLsi38S1eQ
    unordered-containers-0.2.20-LkuwqgGHy2J6l9MBSYA9kS
    vector-0.13.1.0-GCmMsLcrTyFGJ15LkY6umX

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

