#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-5bPmAXg46l9Jt1qFXlxkAM
key:                  glirc-2.40-5bPmAXg46l9Jt1qFXlxkAM
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  4bd8ac030adb7077b424d11bdca0f750
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-5bPmAXg46l9Jt1qFXlxkAM
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-DOFe4pp4bx8IaMc92KUbtc
    async-2.2.5-KSZIoACaSMlHctQ7vOTAKz
    attoparsec-0.14.4-4lxImiie977LVZ07Q4RuOa base-4.17.2.1
    base64-bytestring-1.2.1.0-Ho7haZ0JPmRAFS27fbQFVQ
    bytestring-0.11.5.3 config-schema-1.3.0.0-CLc6B2wj51hihd4RFSikY
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8-20ry2x9XXX21PRw4p6VNPK directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-2WzVmrLBKBvLiHZdNNdusx
    githash-0.1.6.3-4DCygkaYdo13dMTCEGBzs4
    hashable-1.4.4.0-G3df7eBPFu1LRujEcYqf5c
    hookup-0.8-9CitoCNdorT8o5k9XyVv8Q
    irc-core-2.12-AkCFxR4pSviI0AkqEs9HzB
    kan-extensions-5.2.6-IEaMYrpcdgOf7JCwypdVe
    lens-5.2.3-3fSsMRucgnZ99PomxyWs7a
    network-3.1.4.0-6nVv84Orn5X1dkWXH7HumR
    psqueues-0.2.8.1-1HDL2kD8I9E8xvZFlmMSL4
    random-1.2.1.2-23MFWqKwy7yBKL8EDiRtc8
    regex-tdfa-1.3.2.3-1KOOZGaJQ2ADpVIAJeQf05
    semigroupoids-6.0.1-E3fPbzgLBLRGnvfb0DVC6s
    split-0.2.5-8MbgSD03gYABvLDzr4SwW7 stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.12.0-6wkil3oeXaI81gwDddTXKl
    unix-2.7.3 unordered-containers-0.2.20-EFINKuAnn2VCsrMAVqSNI6
    vector-0.13.1.0-KSX0XQMPS0MKwOGi5hYJAY
    vty-6.1-L1uhO7ba4T78BGEoCx6ZiP

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

