#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 configurator
version:              0.3.0.0
visibility:           public
id:                   configurator-0.3.0.0-JOPJlvTHRmBLLoArfDYOqH
key:                  configurator-0.3.0.0-JOPJlvTHRmBLLoArfDYOqH
license:              BSD-3-Clause
copyright:
    Copyright 2011 MailRank, Inc.
    Copyright 2011-2014 Bryan O'\''Sullivan

maintainer:           Bryan O'\''Sullivan <bos@serpentine.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             http://github.com/bos/configurator
synopsis:             Configuration management
description:
    A configuration management library for programs and daemons.

    Features include:

    * Automatic, dynamic reloading in response to modifications to
    configuration files.

    * A simple, but flexible, configuration language, supporting several
    of the most commonly needed types of data, along with
    interpolation of strings from the configuration or the system
    environment (e.g. @$(HOME)@).

    * Subscription-based notification of changes to configuration
    properties.

    * An @import@ directive allows the configuration of a complex
    application to be split across several smaller files, or common
    configuration data to be shared across several applications.

    For details of the configuration file format, see
    <http://hackage.haskell.org/packages/archive/configurator/latest/doc/html/Data-Configurator.html>.

category:             Configuration, Data
abi:                  6f31ea7f78bcc2f61959fd0dca764a1a
exposed:              True
exposed-modules:      Data.Configurator Data.Configurator.Types
hidden-modules:
    Data.Configurator.Instances Data.Configurator.Parser
    Data.Configurator.Types.Internal

import-dirs:          /usr/lib/ghc-9.2.8/site-local/configurator-0.3.0.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/configurator-0.3.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-configurator
hs-libraries:         HSconfigurator-0.3.0.0-JOPJlvTHRmBLLoArfDYOqH
depends:
    attoparsec-0.14.4-HI028cZ2WwJ53VFJd3R6KF base-4.16.4.0
    bytestring-0.11.4.0 directory-1.3.6.2
    hashable-1.4.4.0-7BSyPsBurXt9vEzyIgxmkb text-1.2.5.0
    unix-compat-0.7.3-GMbRcTa3W8S37RJEukw37Q
    unordered-containers-0.2.20-DtI6Ump4gwL4XOoZ2vYwmp

haddock-interfaces:
    /usr/share/doc/haskell-configurator/html/configurator.haddock

haddock-html:         /usr/share/doc/haskell-configurator/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

