#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 feed
version:              1.3.2.1
visibility:           public
id:                   feed-1.3.2.1-HE2utIK1t2e2sntHaaXMvk
key:                  feed-1.3.2.1-HE2utIK1t2e2sntHaaXMvk
license:              BSD-3-Clause
maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Sigbjorn Finne <sof@forkIO.com>
homepage:             https://github.com/haskell-party/feed
synopsis:             Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.
description:
    Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.

    To help working with the multiple feed formats we'\''ve
    ended up with, this set of modules provides parsers,
    pretty printers and some utility code for querying
    and just generally working with a concrete representation
    of feeds in Haskell.

    See here for an example of how to create an Atom feed:
    <https://github.com/haskell-party/feed/blob/master/tests/Example/CreateAtom.hs>

    For basic reading and editing of feeds, consult
    the documentation of the Text.Feed.* hierarchy.

category:             Text
abi:                  94378d7c3cdfc576c70d7162e5143180
exposed:              True
exposed-modules:
    Text.Atom.Feed Text.Atom.Feed.Export Text.Atom.Feed.Import
    Text.Atom.Feed.Link Text.Atom.Feed.Validate Text.Atom.Pub
    Text.Atom.Pub.Export Text.DublinCore.Types Text.Feed.Constructor
    Text.Feed.Export Text.Feed.Import Text.Feed.Query
    Text.Feed.Translate Text.Feed.Types Text.Feed.Util Text.RSS.Export
    Text.RSS.Import Text.RSS.Syntax Text.RSS1.Export Text.RSS1.Import
    Text.RSS1.Syntax Text.RSS1.Utils

hidden-modules:       Data.Text.Util Data.XML.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/feed-1.3.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/feed-1.3.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/feed-1.3.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-feed
hs-libraries:         HSfeed-1.3.2.1-HE2utIK1t2e2sntHaaXMvk
depends:
    base-4.17.2.1 base-compat-0.12.2-3peTS4EQIw912qC0ETmbL5
    bytestring-0.11.5.3 old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    safe-0.3.21-AhsGjgyzf9PtCbhiN6ATk text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    xml-conduit-1.9.1.4-LThySNIt92wIZwxnEsq580
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25

haddock-interfaces:   /usr/share/doc/haskell-feed/html/feed.haddock
haddock-html:         /usr/share/doc/haskell-feed/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

