#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hashable
version:              1.4.4.0
visibility:           public
id:                   hashable-1.4.4.0-GlHmxadJMPDAuB7eaK8Jlw
key:                  hashable-1.4.4.0-GlHmxadJMPDAuB7eaK8Jlw
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Milan Straka <fox@ucw.cz>
    Johan Tibell <johan.tibell@gmail.com>

stability:            Provisional
homepage:             http://github.com/haskell-unordered-containers/hashable
synopsis:             A class for types that can be converted to a hash value
description:
    This package defines a class, '\''Hashable'\'', for types that
    can be converted to a hash value.  This class
    exists for the benefit of hashing-based data
    structures.  The package provides instances for
    basic types and a way to combine hash values.

    The '\''Hashable'\'' '\''hash'\'' values are not guaranteed to be stable across library versions, operating systems or architectures. For stable hashing use named hashes: SHA256, CRC32 etc.

category:             Data
abi:                  adf08511877725916e7e811700505357
exposed:              True
exposed-modules:
    Data.Hashable Data.Hashable.Generic Data.Hashable.Lifted

hidden-modules:
    Data.Hashable.Class Data.Hashable.Generic.Instances
    Data.Hashable.Imports Data.Hashable.LowLevel

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hashable-1.4.4.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hashable-1.4.4.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hashable-1.4.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hashable
hs-libraries:         HShashable-1.4.4.0-GlHmxadJMPDAuB7eaK8Jlw
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    filepath-1.4.2.2 ghc-bignum-1.3 ghc-prim-0.9.1
    os-string-2.0.7-3sIJAN6mzxp5NiSt1CRv4s text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-hashable/html/hashable.haddock
haddock-html:         /usr/share/doc/haskell-hashable/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

