#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hasql
version:              1.5.0.4
visibility:           public
id:                   hasql-1.5.0.4-C5u42j0kd6yKdcCfWiLCOO
key:                  hasql-1.5.0.4-C5u42j0kd6yKdcCfWiLCOO
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  5059db9787a4ac966481c04a36b7147a
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hasql-1.5.0.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hasql-1.5.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hasql
hs-libraries:         HShasql-1.5.0.4-C5u42j0kd6yKdcCfWiLCOO
depends:
    attoparsec-0.14.4-HI028cZ2WwJ53VFJd3R6KF base-4.16.4.0
    bytestring-0.11.4.0
    bytestring-strict-builder-0.4.5.7-Jx9MX2YeLkQ6vwI0bYWmhi
    contravariant-1.5.5-6oWUjmJNxDBFhugVD5s9dq
    dlist-1.0-HCxoMn9TirQDgPCFxho7O
    hashable-1.4.4.0-7BSyPsBurXt9vEzyIgxmkb
    hashtables-1.3.1-wnosz65fsL1zLRXv1XqyS mtl-2.2.2
    postgresql-binary-0.12.5-5qZsZ2KPAd51HzzUoIunUf
    postgresql-libpq-0.9.4.3-KEIdZq7PBXuLHl7WTAWu9q
    profunctors-5.6.2-GShwRP90Jtv64Kn3eksX1P text-1.2.5.0
    text-builder-0.6.7-6qn4KvNYBVGCnq9JS3NR6q transformers-0.5.6.2
    vector-0.13.1.0-fp7g3DnwvJ21p5JSIbLxP

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

