#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-D8MysIRsuH0IVmz03Tqz6t
key:                  arch-hs-0.11.1.0-D8MysIRsuH0IVmz03Tqz6t
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  8d8600d9de3195021984aa63bd670267
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-D8MysIRsuH0IVmz03Tqz6t
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.6.3.0 Diff-0.4.1-FQGoMszL7yvHgYjHqpLdBw
    aeson-2.1.2.1-EcnOkqJy6qkFyx4PSoTHhT
    algebraic-graphs-0.7-Vlo1zKaKxPGfPzyLuwRpz
    arch-web-0.2-4uNmCDm0HmN7FZ26lBs1a1 base-4.16.4.0
    bytestring-0.11.4.0 conduit-1.3.6.1-ISJMpaJF58t3dEZ3o38RNe
    conduit-extra-1.3.6-8wnHA6l0vImF42f8TTslKW containers-0.6.5.1
    deepseq-1.4.6.1 directory-1.3.6.2 filepath-1.4.2.2
    hackage-db-2.1.3-ItuJShAp4e2G0fwBqqIOrx
    http-client-0.7.17-Fh4ihEswmBz5CjbyQqfjpG
    http-client-tls-0.3.6.3-4ijR9PRS7wrBZo5PtXOIet
    megaparsec-9.6.1-1rJqRfK4Cgi6LJwevmLrVi
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-th-0.4.3.17-ChCJJ2TX2AIKBqljNVmheD
    neat-interpolation-0.5.1.4-5ShGXwEUdEL7pMLUKIbUk9
    optparse-simple-0.1.1.4-JwOqo1GyJTIAg3NX4fCrp8
    polysemy-1.9.2.0-2XspwnBhCdqFOy5hptFlRt
    prettyprinter-1.7.1-7366Y65hgcyJTp3r9w4dh7
    prettyprinter-ansi-terminal-1.1.3-1ZK8buEiUJp3iI6d5WR83V
    servant-client-0.20-KxpFSjluCPkIFE3SbdJ5nl
    split-0.2.5-fPWkUXEXZHvXnPhPWCGf
    tar-conduit-0.4.1-7LSm5Let7Y4ADNaTJpw2dt template-haskell-2.18.0.0
    text-1.2.5.0

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

