#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-ghc
version:              1.8.1
visibility:           public
id:                   clash-ghc-1.8.1-1VjL0Gd3annBFNqrRScinx
key:                  clash-ghc-1.8.1-1VjL0Gd3annBFNqrRScinx
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  74566411185b677b8a82c4056ee5bd35
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.Leak Clash.GHCi.UI Clash.GHCi.UI.Info
    Clash.GHCi.UI.Monad Clash.GHC.ClashFlags Clash.GHC.GHC2Core
    Clash.GHC.LoadInterfaceFiles Clash.GHC.Util Paths_clash_ghc
    Clash.GHCi.Util Clash.GHCi.UI.Tags

import-dirs:          /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/clash-ghc-1.8.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/clash-ghc
hs-libraries:         HSclash-ghc-1.8.1-1VjL0Gd3annBFNqrRScinx
depends:
    Cabal-3.8.1.0 array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3
    clash-lib-1.8.1-JaftHg4MssgERH8eBuXGzw
    clash-prelude-1.8.1-6fcQDTf2V2BHpPfMt1WemZ
    concurrent-supply-0.1.8-8UdKBoIlAKFBTJXJ4MDHY0 containers-0.6.7
    data-binary-ieee754-0.4.4-3K4wyZ8KRa1CgKftL8GYsk deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5
    extra-1.7.16-7xWSq5sOOT2ClgTEM6hqi4 filepath-1.4.2.2 ghc-9.4.8
    ghc-bignum-1.3 ghc-boot-9.4.8 ghc-prim-0.9.1
    ghc-typelits-extra-0.4.5-PC9Hyw6F1FEx9yNqkonWy
    ghc-typelits-knownnat-0.7.8-EgTPyvDIdDaJbaeifar5UM
    ghc-typelits-natnormalise-0.7.9-JnwZbvtKiff3tIubt0OX9r ghci-9.4.8
    hashable-1.4.4.0-5O85VrI4oZ4EDBPYdTgwgk haskeline-0.8.2
    lens-5.2.3-6LjFCusMfYNH72ou1m3jdq mtl-2.2.2
    primitive-0.8.0.0-KvNzOAcw1vIIZ8l6YzsRlk process-1.6.18.0
    reflection-2.1.8-9Ke1IWdp93KDez6btU0gXt
    split-0.2.5-LghWP1sjueiF0Ln6STtUGf
    string-interpolate-0.3.4.0-Jza8yfGEkDBAoIq0EoVigg
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 uniplate-1.6.13-3t4NeuKPUknBzYHBQ5ITf
    unix-2.7.3 unordered-containers-0.2.20-2kG5VEC3Gy42AwINT9WJ9w
    utf8-string-1.0.2-FnO1h94XkEn7naEuvLflUO
    vector-0.13.1.0-Dc65CzydytHE52tdajtbOv

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

