#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cryptol
version:              3.1.0
visibility:           public
id:                   cryptol-3.1.0-KvfdGUNSOntEeDjS7YiYjz
key:                  cryptol-3.1.0-KvfdGUNSOntEeDjS7YiYjz
license:              BSD-3-Clause
copyright:            2013-2022 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             http://www.cryptol.net/
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  ff5ab51bd7540f0c0e7406e63b326f16
exposed:              True
exposed-modules:
    Cryptol.AES Cryptol.Backend Cryptol.Backend.Arch
    Cryptol.Backend.Concrete Cryptol.Backend.FFI
    Cryptol.Backend.FFI.Error Cryptol.Backend.FloatHelpers
    Cryptol.Backend.Monad Cryptol.Backend.SBV Cryptol.Backend.SeqMap
    Cryptol.Backend.What4 Cryptol.Backend.WordValue Cryptol.Eval
    Cryptol.Eval.Concrete Cryptol.Eval.Env Cryptol.Eval.FFI
    Cryptol.Eval.FFI.GenHeader Cryptol.Eval.Generic Cryptol.Eval.Prims
    Cryptol.Eval.Reference Cryptol.Eval.SBV Cryptol.Eval.Type
    Cryptol.Eval.Value Cryptol.Eval.What4 Cryptol.F2
    Cryptol.IR.FreeVars Cryptol.IR.TraverseNames Cryptol.ModuleSystem
    Cryptol.ModuleSystem.Base Cryptol.ModuleSystem.Binds
    Cryptol.ModuleSystem.Env Cryptol.ModuleSystem.Exports
    Cryptol.ModuleSystem.Fingerprint Cryptol.ModuleSystem.Interface
    Cryptol.ModuleSystem.Monad Cryptol.ModuleSystem.Name
    Cryptol.ModuleSystem.Names Cryptol.ModuleSystem.NamingEnv
    Cryptol.ModuleSystem.NamingEnv.Types Cryptol.ModuleSystem.Renamer
    Cryptol.ModuleSystem.Renamer.Error
    Cryptol.ModuleSystem.Renamer.ImplicitImports
    Cryptol.ModuleSystem.Renamer.Imports
    Cryptol.ModuleSystem.Renamer.Monad Cryptol.Parser
    Cryptol.Parser.AST Cryptol.Parser.ExpandPropGuards
    Cryptol.Parser.Layout Cryptol.Parser.Lexer Cryptol.Parser.Name
    Cryptol.Parser.Names Cryptol.Parser.NoInclude Cryptol.Parser.NoPat
    Cryptol.Parser.Position Cryptol.Parser.Selector
    Cryptol.Parser.Token Cryptol.Parser.Unlit Cryptol.Parser.Utils
    Cryptol.PrimeEC Cryptol.REPL.Browse Cryptol.REPL.Command
    Cryptol.REPL.Help Cryptol.REPL.Monad Cryptol.REPL.Trie Cryptol.SHA
    Cryptol.Symbolic Cryptol.Symbolic.SBV Cryptol.Symbolic.What4
    Cryptol.Testing.Random Cryptol.Transform.MonoValues
    Cryptol.Transform.Specialize Cryptol.TypeCheck
    Cryptol.TypeCheck.AST Cryptol.TypeCheck.Default
    Cryptol.TypeCheck.Error Cryptol.TypeCheck.FFI
    Cryptol.TypeCheck.FFI.Error Cryptol.TypeCheck.FFI.FFIType
    Cryptol.TypeCheck.Infer Cryptol.TypeCheck.InferTypes
    Cryptol.TypeCheck.Instantiate Cryptol.TypeCheck.Interface
    Cryptol.TypeCheck.Kind Cryptol.TypeCheck.Module
    Cryptol.TypeCheck.ModuleBacktickInstance
    Cryptol.TypeCheck.ModuleInstance Cryptol.TypeCheck.Monad
    Cryptol.TypeCheck.PP Cryptol.TypeCheck.Parseable
    Cryptol.TypeCheck.Sanity Cryptol.TypeCheck.SimpType
    Cryptol.TypeCheck.SimpleSolver Cryptol.TypeCheck.Solve
    Cryptol.TypeCheck.Solver.Class Cryptol.TypeCheck.Solver.Improve
    Cryptol.TypeCheck.Solver.InfNat Cryptol.TypeCheck.Solver.Numeric
    Cryptol.TypeCheck.Solver.Numeric.Fin
    Cryptol.TypeCheck.Solver.Numeric.Interval
    Cryptol.TypeCheck.Solver.SMT Cryptol.TypeCheck.Solver.Selector
    Cryptol.TypeCheck.Solver.Types Cryptol.TypeCheck.Solver.Utils
    Cryptol.TypeCheck.Subst Cryptol.TypeCheck.TCon
    Cryptol.TypeCheck.Type Cryptol.TypeCheck.TypeMap
    Cryptol.TypeCheck.TypeOf Cryptol.TypeCheck.TypePat
    Cryptol.TypeCheck.Unify Cryptol.Utils.Benchmark Cryptol.Utils.Debug
    Cryptol.Utils.Fixity Cryptol.Utils.Ident Cryptol.Utils.Logger
    Cryptol.Utils.Misc Cryptol.Utils.PP Cryptol.Utils.Panic
    Cryptol.Utils.Patterns Cryptol.Utils.RecordMap Cryptol.Utils.Types
    Cryptol.Version

hidden-modules:
    Cryptol.Parser.LexerUtils Cryptol.Parser.ParserUtils
    Cryptol.Prelude GHC.Num.Compat Paths_cryptol GitRev

import-dirs:          /usr/lib/ghc-9.2.8/site-local/cryptol-3.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/cryptol-3.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-3.1.0-KvfdGUNSOntEeDjS7YiYjz
depends:
    GraphSCC-1.0.4-HIuJHf8edQx6sQ4gT752DA
    MemoTrie-0.6.11-KrmH5Bs6xX4Et9wvm5DdOr
    arithmoi-0.13.0.1-2z0xt63vld31oDoTa4eIEy array-0.5.4.0
    async-2.2.5-FKfvvqWRs5hKqVa0zqZISU base-4.16.4.0
    base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd
    bv-sized-1.0.5-GeiADLA93XM2PByyvKbMdl bytestring-0.11.4.0
    containers-0.6.5.1
    criterion-measurement-0.2.2.0-Ajgox5hULwOHUZ4snOmHK7
    cryptohash-sha1-0.11.101.0-Csqu1JwdGK49Tt3hHK8UXr deepseq-1.4.6.1
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.2 ghc-bignum-1.2
    ghc-prim-0.8.0 gitrev-1.3.1-9lQGgHpaqCODNpyMdeEqev
    heredoc-0.2.0.0-D3AW9S2AOKs91e3wqBbhAD
    hgmp-0.1.2.1-6fixHkdcy1s3XJJACtdoUs
    language-c99-0.2.0-DdMaUcm9U227hCUvFeLVWh
    language-c99-simple-0.3.0-2ykQRBHl54DIcZLsD9NrhC
    libBF-0.6.6-GWm9mtoIeG89lIPbY3YakV
    libffi-0.2.1-LccIAuoU8yrBMDFxV9AXvd
    monad-control-1.0.3.1-GkuZPEUBz3BKbX9xfvMljM
    monadLib-3.10.1-3LclK5fklWJvr1ecJa4EI mtl-2.2.2
    panic-0.4.0.1-HPbW5wuhX2x4TYrkc6yjYz
    parameterized-utils-2.1.9.0-EoYqytPCIj4AaOJHoiqxuG pretty-1.1.3.6
    pretty-show-1.10-JwphvxEdk99BsHrT870tUy
    prettyprinter-1.7.1-P4nIstiPm4DFD12od2xCI process-1.6.16.0
    sbv-9.1-CvNbkVMjny8BPoi9zIfsa
    simple-smt-0.9.7-FEpCzzfYgxq2SGFIvC6IdK stm-2.5.0.2
    strict-0.5-Yc3zPjSaDYDi2NCzfFNIf text-1.2.5.0
    tf-random-0.5-1SqaqlBB7CyBYUG1vy9t9n time-1.11.1.1
    transformers-base-0.4.6-KOD2bxom1n4If90CQp5Jjk unix-2.7.2.2
    vector-0.13.1.0-IOJlwkRydAuH1Lkdw56w5r
    what4-1.5.1-6z8Nr6cS4onASITMTTZ9R6

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

