#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 uuid
version:              1.3.15
visibility:           public
id:                   uuid-1.3.15-3CviI3xieCwKBwBru8112R
key:                  uuid-1.3.15-3CviI3xieCwKBwBru8112R
license:              BSD-3-Clause
copyright:            (c) 2008-2014 Antoine Latter
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:
    For creating, comparing, parsing and printing Universally Unique Identifiers

description:
    This library is useful for creating, comparing, parsing and
    printing Universally Unique Identifiers.

    See <http://en.wikipedia.org/wiki/UUID> for the general idea.

category:             Data
abi:                  be6e13030cff0c01b38bce7c1071657f
exposed:              True
exposed-modules:
    Data.UUID Data.UUID.Util Data.UUID.V1 Data.UUID.V3 Data.UUID.V4
    Data.UUID.V5

hidden-modules:       Data.UUID.Named Data.Word.Util
import-dirs:          /usr/lib/ghc-9.2.8/site-local/uuid-1.3.15
library-dirs:         /usr/lib/ghc-9.2.8/site-local/uuid-1.3.15
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uuid
hs-libraries:         HSuuid-1.3.15-3CviI3xieCwKBwBru8112R
depends:
    base-4.16.4.0 binary-0.8.9.0 bytestring-0.11.4.0
    cryptohash-md5-0.11.101.0-ESNMa3piw6S3CcIY6OIE8H
    cryptohash-sha1-0.11.101.0-JWHGwwpgMnx55X1UCthTS7
    entropy-0.4.1.10-C5y4ZMubclPFkOssafbGqV
    network-info-0.2.1-KKhPoqXltWn3GAhxqG8FXO
    random-1.2.1.2-3aSfWlsu7xc3wK3TRJn2vY text-1.2.5.0 time-1.11.1.1
    uuid-types-1.0.5.1-J2sbKAR6gu99vJPWCEy8Jh

haddock-interfaces:   /usr/share/doc/haskell-uuid/html/uuid.haddock
haddock-html:         /usr/share/doc/haskell-uuid/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

